/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.resource;

import java.util.concurrent.atomic.AtomicInteger;

public abstract class ReferenceCounted<T>
implements AutoCloseable {
    protected T subject;
    protected AtomicInteger refcount = new AtomicInteger(0);

    public ReferenceCounted(T subject, int refcount) {
        this.subject = subject;
        this.refcount.set(refcount);
    }

    public T getSubject() {
        return this.subject;
    }

    protected abstract void onFree();

    public int acquire() {
        return this.refcount.incrementAndGet();
    }

    public int release() {
        int ret = this.refcount.decrementAndGet();
        if (ret <= 0) {
            this.onFree();
        }
        return ret;
    }

    @Override
    public void close() {
        this.release();
    }
}

