/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.resource.pool;

import eu.javaexperience.resource.pool.TrackedResourcePool;
import java.io.Closeable;
import java.io.IOException;

public class IssuedResource<T>
implements Closeable {
    protected final TrackedResourcePool<T> pool;
    protected T resource;
    protected boolean issued = true;

    public IssuedResource(TrackedResourcePool<T> pool, T resource) {
        this.pool = pool;
        this.resource = resource;
    }

    public TrackedResourcePool<T> getPool() {
        return this.pool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        IssuedResource issuedResource = this;
        synchronized (issuedResource) {
            if (!this.issued) {
                throw new RuntimeException("Resource double release!");
            }
            this.pool.releaseResource(this);
            this.resource = null;
            this.issued = false;
        }
    }

    public T getResource() {
        return this.resource;
    }

    @Override
    public void close() throws IOException {
        this.release();
    }
}

