/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.settings;

import eu.javaexperience.collection.CollectionTools;
import eu.javaexperience.io.FileConfigMapper;
import eu.javaexperience.parse.ParsePrimitive;
import eu.javaexperience.settings.ConfigValueChangeListener;
import java.util.ArrayList;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicReference;

public abstract class ConfigEntry<T> {
    FileConfigMapper source;
    protected final String key;
    protected T defaultValue;
    protected ArrayList<ConfigValueChangeListener<T>> listeners = new ArrayList();

    public ConfigEntry(FileConfigMapper owner, String key, T default_value) {
        this.source = owner;
        this.key = key;
        this.defaultValue = default_value;
    }

    protected abstract String format(T var1);

    protected abstract T parse(String var1);

    public T getValue() {
        String v = this.source.get(this.key);
        if (null == v) {
            return this.defaultValue;
        }
        T ret = this.parse(v);
        if (null == ret) {
            return this.defaultValue;
        }
        return ret;
    }

    public void addListener(ConfigValueChangeListener<T> lst) {
        if (null != lst) {
            CollectionTools.addLikeSet(this.listeners, lst);
        }
    }

    public boolean isListenerRegistered(ConfigValueChangeListener<T> lst) {
        return this.listeners.contains(lst);
    }

    public void removeListener(ConfigValueChangeListener<T> lst) {
        this.listeners.remove(lst);
    }

    public void setValue(T obj) {
        if (null == obj) {
            return;
        }
        String save = this.format(obj);
        if (null == save) {
            return;
        }
        this.source.put(this.key, save);
        for (ConfigValueChangeListener<T> c : this.listeners) {
            try {
                c.configValueChanged(this, obj);
            }
            catch (Throwable t) {
                if (null == t) continue;
                t.printStackTrace();
            }
        }
    }

    public static class IntegerConfigEntry
    extends ConfigEntry<Integer> {
        public IntegerConfigEntry(FileConfigMapper owner, String key, Integer default_value) {
            super(owner, key, default_value);
        }

        @Override
        protected String format(Integer value) {
            return value.toString();
        }

        @Override
        protected Integer parse(String value) {
            return ParsePrimitive.tryParseInt(value);
        }
    }

    public static class TrimmedStringConfigEntry
    extends ConfigEntry<String> {
        public TrimmedStringConfigEntry(FileConfigMapper owner, String key, String default_value) {
            super(owner, key, default_value);
        }

        @Override
        protected String format(String value) {
            return value.trim();
        }

        @Override
        protected String parse(String value) {
            return value.trim();
        }
    }

    public static class StringConfigEntry
    extends ConfigEntry<String> {
        public StringConfigEntry(FileConfigMapper owner, String key, String default_value) {
            super(owner, key, default_value);
        }

        @Override
        protected String format(String value) {
            return value;
        }

        @Override
        protected String parse(String value) {
            return value;
        }
    }

    public static class WaitForReloadListener<T>
    implements ConfigValueChangeListener<T> {
        protected final ConfigEntry<T> entry;
        protected final AtomicReference<Semaphore> waiter = new AtomicReference<Semaphore>(new Semaphore(0));

        public WaitForReloadListener(ConfigEntry<T> entry) {
            this.entry = entry;
            entry.addListener(this);
        }

        @Override
        public void configValueChanged(ConfigEntry<T> cfg, T new_value) {
            Semaphore s = this.waiter.get();
            s.release(0x3FFFFFFF);
            this.waiter.set(new Semaphore(0));
        }

        public void waitForReload() throws InterruptedException {
            Semaphore s = this.waiter.get();
            s.acquire();
            s.release();
        }
    }
}

