/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.test;

import eu.javaexperience.log.JavaExperienceLoggingFacility;
import eu.javaexperience.log.LogLevel;
import eu.javaexperience.log.Loggable;
import eu.javaexperience.log.Logger;
import eu.javaexperience.log.LoggingDetailLevel;
import eu.javaexperience.log.LoggingTools;
import eu.javaexperience.semantic.TesterFunction;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;

public class SimpleTester {
    protected static final Logger LOG = JavaExperienceLoggingFacility.getLogger(new Loggable("Tester"));

    public static TestStatistic testClass(Class<?> cls) {
        Method[] ms;
        LoggingTools.tryLogFormat(LOG, (LoggingDetailLevel)LogLevel.INFO, "Discovering class `%s` for @TesterFunction-s", cls);
        TestStatistic ts = new TestStatistic();
        for (Method m : ms = cls.getDeclaredMethods()) {
            if (null == m.getAnnotation(TesterFunction.class)) continue;
            int mods = m.getModifiers();
            if (!Modifier.isStatic(mods)) {
                LoggingTools.tryLogFormat(LOG, (LoggingDetailLevel)LogLevel.WARNING, "Method `%s` has @TesterFunction annotation, but not declared as static, 'skip' testing this function.", (Object)m);
                ++ts.ignored;
                continue;
            }
            Object[] params = m.getParameterTypes();
            if (0 != params.length) {
                LoggingTools.tryLogFormat(LOG, (LoggingDetailLevel)LogLevel.WARNING, "Method `%s` requires parameters of `%s`, 'skip' testing this function.", (Object)m, (Object)Arrays.toString(params));
                ++ts.ignored;
                continue;
            }
            m.setAccessible(true);
            ++ts.tests;
            Object ret = null;
            try {
                ret = m.invoke(null, new Object[0]);
            }
            catch (IllegalAccessException e) {
                LoggingTools.tryLogFormatException(LOG, (LoggingDetailLevel)LogLevel.ERROR, (Throwable)e, "Internal error raised at calling test function `%s`\n", (Object)m);
                ++ts.errors;
                continue;
            }
            catch (IllegalArgumentException e) {
                LoggingTools.tryLogFormatException(LOG, (LoggingDetailLevel)LogLevel.ERROR, (Throwable)e, "'strange, this should'nt to be happened' at calling test function `%s`\n", (Object)m);
                ++ts.errors;
                continue;
            }
            catch (InvocationTargetException e) {
                Throwable t = e;
                if (null != e.getCause()) {
                    t = e.getCause();
                }
                LoggingTools.tryLogFormatException(LOG, (LoggingDetailLevel)LogLevel.FATAL, t, "Exception raised in the `%s` test function, so this test failed!\n", (Object)m);
                ++ts.fails;
                continue;
            }
            if (!Void.class.equals(m.getReturnType())) {
                LoggingTools.tryLogFormat(LOG, (LoggingDetailLevel)LogLevel.INFO, "Test function `%s` has return value of type `%s` and resulted: `%s` test passed", (Object)m, m.getReturnType(), ret);
            }
            ++ts.success;
        }
        LoggingTools.tryLogFormat(LOG, ts.getRecommendedLoggingPriorityForResult(), "Class testing `%s` finished. Result: %s", cls, (Object)ts);
        return ts;
    }

    public static class TestStatistic {
        protected Class<?> testSubjectClass;
        protected int ignored = 0;
        protected int tests = 0;
        protected int errors = 0;
        protected int fails = 0;
        protected int success = 0;

        public int getIgnoredCount() {
            return this.ignored;
        }

        public int getTestsCount() {
            return this.tests;
        }

        public int getErrorsCount() {
            return this.errors;
        }

        public int getFailsCount() {
            return this.fails;
        }

        public int getSuccessCount() {
            return this.success;
        }

        public Class<?> getTestSubjectClass() {
            return this.testSubjectClass;
        }

        public boolean isAllPassed() {
            return 0 == this.ignored && this.tests == this.success;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (0 == this.ignored && this.tests == this.success) {
                sb.append("all of ");
                sb.append(this.tests);
                sb.append(" tests are passed.");
            } else {
                boolean needComma = false;
                if (0 != this.ignored) {
                    sb.append(this.ignored);
                    sb.append(" test ignored");
                    needComma = true;
                }
                if (0 != this.errors) {
                    if (needComma) {
                        sb.append(", ");
                    }
                    sb.append(this.errors);
                    sb.append(" test caused internal error");
                    needComma = true;
                }
                if (0 != this.fails) {
                    if (needComma) {
                        sb.append(", ");
                    }
                    sb.append(this.fails);
                    sb.append(" test failed");
                    needComma = true;
                }
                if (needComma) {
                    sb.append(", ");
                }
                sb.append(this.success);
                sb.append(" test succeed");
                boolean bl = true;
            }
            return sb.toString();
        }

        public LoggingDetailLevel getRecommendedLoggingPriorityForResult() {
            if (0 == this.ignored && this.tests == this.success) {
                return LogLevel.INFO;
            }
            if (0 != this.errors) {
                return LogLevel.FATAL;
            }
            return LogLevel.WARNING;
        }
    }
}

