/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.text;

import eu.javaexperience.reflect.Mirror;
import java.util.Arrays;

public class MutaString
implements CharSequence {
    protected int len = 0;
    protected char[] data = Mirror.emptyCharArray;

    public MutaString() {
    }

    public MutaString(String str) {
        this.replaceWith(str);
    }

    @Override
    public char charAt(int index) {
        return this.data[index];
    }

    @Override
    public int length() {
        return this.len;
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        if (end < start) {
            return null;
        }
        MutaString ret = new MutaString();
        ret.len = end - start;
        ret.data = new char[ret.len];
        for (int i = 0; i < ret.len; ++i) {
            ret.data[i] = this.data[start + i];
        }
        return ret;
    }

    public boolean removeBTW(int start, int end) {
        int diff = end - start;
        if (diff < 1) {
            return false;
        }
        this.len -= diff;
        for (int i = start; i < this.len; ++i) {
            this.data[i] = this.data[i + diff];
        }
        return true;
    }

    @Override
    public String toString() {
        return new String(this.data, 0, this.len);
    }

    public boolean equals(Object o) {
        if (!(o instanceof MutaString)) {
            return false;
        }
        return this.equals((MutaString)o);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(MutaString obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.len != this.len) {
            return false;
        }
        for (int i = 0; i < this.len; ++i) {
            if (obj.data[i] == this.data[i]) continue;
            return false;
        }
        return true;
    }

    public boolean removeStringOnce(String str) {
        if (str == null) {
            return false;
        }
        int indexof = this.indexOf(str);
        if (indexof != -1) {
            this.removeBTW(indexof, indexof + str.length());
            return true;
        }
        return false;
    }

    static int indexOf(CharSequence source, CharSequence target, int fromIndex, int endindex) {
        if (target == null) {
            return -1;
        }
        if (fromIndex >= endindex) {
            return target.length() == 0 ? endindex : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (target.length() == 0) {
            return fromIndex;
        }
        char first = target.charAt(0);
        int max = endindex - target.length();
        for (int i = fromIndex; i <= max; ++i) {
            if (source.charAt(i) != first) {
                while (++i <= max && source.charAt(i) != first) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + target.length() - 1;
            int k = 1;
            while (j < end && source.charAt(j) == target.charAt(k)) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i;
        }
        return -1;
    }

    static int indexOf(CharSequence source, CharSequence target, int fromIndex) {
        if (target == null) {
            return -1;
        }
        if (fromIndex >= source.length()) {
            return target.length() == 0 ? source.length() : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (target.length() == 0) {
            return fromIndex;
        }
        char first = target.charAt(0);
        int max = source.length() - target.length();
        for (int i = fromIndex; i <= max; ++i) {
            if (source.charAt(i) != first) {
                while (++i <= max && source.charAt(i) != first) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + target.length() - 1;
            int k = 1;
            while (j < end && source.charAt(j) == target.charAt(k)) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(CharSequence str) {
        return this.indexOf(str, 0);
    }

    public int indexOf(CharSequence str, int fromIndex) {
        return MutaString.indexOf(this, str, fromIndex);
    }

    public int indexOf(CharSequence str, int fromIndex, int toIndex) {
        return MutaString.indexOf(this, str, fromIndex, toIndex);
    }

    public void replaceWith(String str) {
        this.len = str.length();
        this.data = new char[this.len];
        for (int i = 0; i < this.len; ++i) {
            this.data[i] = str.charAt(i);
        }
    }

    public void replaceWith(char[] cbuf, int off, int len) {
        this.data = Arrays.copyOfRange(cbuf, off, off + len);
        this.len = len;
    }

    @Deprecated
    public void actAs(char[] cbuf, int off, int len) {
        if (0 == off) {
            this.data = cbuf;
            this.len = len;
        } else {
            this.replaceWith(cbuf, off, len);
        }
    }
}

