/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.text.tokenize;

import eu.javaexperience.collection.CollectionTools;
import eu.javaexperience.text.StringTools;
import eu.javaexperience.text.tokenize.ParsedToken;
import eu.javaexperience.text.tokenize.TokenGroup;
import java.util.ArrayList;
import java.util.Collection;

public class Tokenizer<T> {
    protected ArrayList<TokenGroup<T>> tokenizers = new ArrayList();

    public Tokenizer(Collection<TokenGroup<T>> grps) {
        CollectionTools.copyInto(grps, this.tokenizers);
    }

    public void tokenize(Collection<ParsedToken<T>> dst, String source) {
        ParsedToken<T> ret;
        int len = source.length();
        block0: for (int from = 0; from < len; from += ret.content.length()) {
            for (TokenGroup<T> t : this.tokenizers) {
                ret = t.tryMatch(from, source);
                if (null == ret) continue;
                dst.add(ret);
                continue block0;
            }
            throw new RuntimeException("Unrecognisable token at positon: " + from + ", content: \n" + source + "\n" + StringTools.repeatChar(' ', from) + "^\n");
        }
    }

    public String toString() {
        return super.toString();
    }
}

