/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.version;

import eu.javaexperience.asserts.AssertArgument;
import eu.javaexperience.parse.ParsePrimitive;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.text.StringTools;
import eu.javaexperience.version.Version;
import java.util.Arrays;
import java.util.Comparator;

public class VariVersion
implements Version {
    protected final int[] version;
    public static final Comparator<Version> COMPARATOR = new VariVersion(Mirror.emptyIntArray);

    public VariVersion(int[] ver) {
        this.version = ver;
    }

    public static VariVersion parse(String str) {
        String[] vers = str.split("\\.");
        int[] a = new int[vers.length];
        int ep = 0;
        for (int i = 0; i < vers.length; ++i) {
            String s = StringTools.passOnlyNumbers(vers[i]);
            int val = ParsePrimitive.tryParseInt(s, -1);
            if (val < 0) continue;
            a[ep++] = val;
        }
        return new VariVersion(VariVersion.cutTrailingZero(a, ep));
    }

    protected static int[] cutTrailingZero(int[] arr, int ep) {
        int i = ep - 1;
        while (i >= 0 && 0 == arr[i]) {
            ep = i--;
        }
        if (arr.length == ep) {
            return arr;
        }
        return Arrays.copyOf(arr, ep);
    }

    public int hashCode() {
        int ret = 31;
        for (int i = 0; i < this.version.length; ++i) {
            ret = 37 * ret + this.version[i];
        }
        return ret;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof VariVersion)) {
            return false;
        }
        VariVersion v = (VariVersion)o;
        if (this.version.length != v.version.length) {
            return false;
        }
        for (int i = 0; i < this.version.length; ++i) {
            if (this.version[i] == v.version[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compare(Version other_this, Version other_thanThis) {
        if (null == other_this && null == other_thanThis) {
            return 0;
        }
        if (null == other_thanThis) {
            return 1;
        }
        if (null == other_this) {
            return -1;
        }
        VariVersion _this = other_this.asVariVersion();
        VariVersion thanThis = other_thanThis.asVariVersion();
        int maxlen = Math.min(_this.version.length, thanThis.version.length);
        for (int i = 0; i < maxlen; ++i) {
            if (_this.version[i] > thanThis.version[i]) {
                return 1;
            }
            if (_this.version[i] >= thanThis.version[i]) continue;
            return -1;
        }
        if (_this.version.length > thanThis.version.length) {
            return 1;
        }
        if (_this.version.length < thanThis.version.length) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("v");
        for (int i = 0; i < this.version.length; ++i) {
            if (0 != i) {
                sb.append(".");
            }
            sb.append(this.version[i]);
        }
        return sb.toString();
    }

    @Override
    public VariVersion asVariVersion() {
        return this;
    }

    @Override
    public int compareTo(Version o) {
        return this.compare(this, o);
    }

    protected static void assertCmp(String a, String b, int mag) {
        VariVersion _b;
        VariVersion _a = VariVersion.parse(a);
        int res = _a.compareTo(_b = VariVersion.parse(b));
        if (mag == res) {
            System.out.println("pass");
        } else {
            System.out.println("cmp fail: " + _a + " <> " + _b + " => " + res + ", req: " + mag);
        }
    }

    protected static void assertNewest(String a, String b, boolean a_newest) {
        if (a_newest != VariVersion.parse(a).isThisNewerThan(VariVersion.parse(b))) {
            throw new RuntimeException("fail");
        }
    }

    public static void main(String[] args) {
        AssertArgument.assertEquals(VariVersion.parse("1.6.23.1.54.2.4").toString(), "v1.6.23.1.54.2.4", "a");
        AssertArgument.assertEquals(VariVersion.parse("").toString(), "v", "b");
        AssertArgument.assertEquals(VariVersion.parse("1.0.0.1").toString(), "v1.0.0.1", "c");
        AssertArgument.assertEquals(VariVersion.parse("1.0.1.0.0").toString(), "v1.0.1", "d");
        VariVersion.assertCmp("", "", 0);
        VariVersion.assertCmp("1", "1", 0);
        VariVersion.assertCmp("1.6.12", "1.6.12", 0);
        VariVersion.assertCmp("1.6.0", "1.6", 0);
        VariVersion.assertCmp("1", "2", -1);
        VariVersion.assertCmp("1.2", "1.3", -1);
        VariVersion.assertCmp("1.3", "1.2", 1);
        VariVersion.assertCmp("1.6.11.5.4.3", "2.0.0.0.0", -1);
        VariVersion.assertCmp("2.0.0.0.0", "1.6.11.5.4.3", 1);
        VariVersion.assertNewest("", "", false);
        VariVersion.assertNewest("1", "1", false);
        VariVersion.assertNewest("1.6.12", "1.6.12", false);
        VariVersion.assertNewest("1.6.0", "1.6", false);
        VariVersion.assertNewest("1", "2", false);
        VariVersion.assertNewest("1.2", "1.3", false);
        VariVersion.assertNewest("1.3", "1.2", true);
        VariVersion.assertNewest("1.6.11.5.4.3", "2.0.0.0.0", false);
        VariVersion.assertNewest("2.0.0.0.0", "1.6.11.5.4.3", true);
        System.out.println("all pass");
    }

    @Override
    public boolean isThisNewerThan(Version thanThis) {
        int mag = this.compareTo(thanThis);
        return mag > 0;
    }

    @Override
    public int versionLevel(int n) {
        if (this.version.length <= n) {
            return 0;
        }
        return this.version[n];
    }

    @Override
    public int getMajor() {
        return this.versionLevel(0);
    }

    @Override
    public int getMinor() {
        return this.versionLevel(1);
    }

    @Override
    public int getPatch() {
        return this.versionLevel(2);
    }

    @Override
    public int getTweak() {
        return this.versionLevel(3);
    }

    @Override
    public VariVersion assertValidVersion() {
        for (int i = 0; i < this.version.length; ++i) {
            if (this.version[i] >= 0) continue;
            throw new RuntimeException("Invalid negative version: " + this);
        }
        return this;
    }

    @Override
    public VariVersion withDifferentOf(int level, int diff) {
        if (0 == diff) {
            return this;
        }
        int[] ret = null;
        ret = this.version.length > level ? Arrays.copyOf(this.version, this.version.length) : Arrays.copyOf(this.version, level + 1);
        int n = level;
        ret[n] = ret[n] + diff;
        return new VariVersion(ret).assertValidVersion();
    }
}

