/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.datastorage;

import eu.javaexperience.collection.CollectionTools;
import eu.javaexperience.collection.map.KeyVal;
import eu.javaexperience.datastorage.DataStorage;
import eu.javaexperience.datastorage.DataTransaction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public abstract class DataStorageTest {
    protected DataStorage ds;

    public DataStorageTest(DataStorage ds) {
        this.ds = ds;
    }

    public static <E extends Map.Entry<String, String>> void matchEntrySet(Set<Map.Entry<String, Object>> ents, E ... req) {
        ArrayList<E> rem = new ArrayList<E>();
        HashSet<Map.Entry<String, Object>> test = new HashSet<Map.Entry<String, Object>>();
        test.addAll(ents);
        for (E e : req) {
            if (test.remove(e)) continue;
            rem.add(e);
        }
        if (!test.isEmpty() || !rem.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            if (!test.isEmpty()) {
                sb.append("Unwanted elements in result:\n");
                sb.append(CollectionTools.toStringMultiline(test));
                sb.append("\n");
            }
            if (!rem.isEmpty()) {
                sb.append("Expected but not found elements:\n");
                sb.append(CollectionTools.toStringMultiline(rem));
            }
            throw new RuntimeException("EntrySetNot Matches: " + sb.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    public void test() throws Throwable {
        Throwable throwable;
        DataTransaction tr;
        try {
            tr = this.ds.startTransaction("t1");
            throwable = null;
            try {
                tr.put((Object)"a", (Object)1);
                tr.put((Object)"b", (Object)2);
                tr.put((Object)"b.a", (Object)3);
                tr.put((Object)"b.b", (Object)4);
                tr.put((Object)"b.c", (Object)5);
                tr.commit();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (tr != null) {
                    if (throwable != null) {
                        try {
                            tr.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        tr.close();
                    }
                }
            }
            tr = this.ds.startTransaction("t1");
            throwable = null;
            try {
                DataStorageTest.matchEntrySet((Set)tr.entrySet(), (Map.Entry[])new KeyVal[]{new KeyVal((Object)"a", (Object)"1"), new KeyVal((Object)"b", (Object)"2"), new KeyVal((Object)"b.a", (Object)"3"), new KeyVal((Object)"b.b", (Object)"4"), new KeyVal((Object)"b.c", (Object)"5")});
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (tr != null) {
                    if (throwable != null) {
                        try {
                            tr.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        tr.close();
                    }
                }
            }
            tr = this.ds.startTransaction("t1.b");
            throwable = null;
            try {
                DataStorageTest.matchEntrySet((Set)tr.entrySet(), (Map.Entry[])new KeyVal[]{new KeyVal((Object)"a", (Object)"3"), new KeyVal((Object)"b", (Object)"4"), new KeyVal((Object)"c", (Object)"5")});
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                if (tr != null) {
                    if (throwable != null) {
                        try {
                            tr.close();
                        }
                        catch (Throwable throwable7) {
                            throwable.addSuppressed(throwable7);
                        }
                    } else {
                        tr.close();
                    }
                }
            }
            tr = this.ds.startTransaction("");
            throwable = null;
            try {
                DataStorageTest.matchEntrySet((Set)tr.entrySet(), (Map.Entry[])new KeyVal[]{new KeyVal((Object)"t1.a", (Object)"1"), new KeyVal((Object)"t1.b", (Object)"2"), new KeyVal((Object)"t1.b.a", (Object)"3"), new KeyVal((Object)"t1.b.b", (Object)"4"), new KeyVal((Object)"t1.b.c", (Object)"5")});
                return;
            }
            catch (Throwable throwable8) {
                throwable = throwable8;
                throw throwable8;
            }
            finally {
                if (tr != null) {
                    if (throwable != null) {
                        try {
                            tr.close();
                        }
                        catch (Throwable throwable9) {
                            throwable.addSuppressed(throwable9);
                        }
                    } else {
                        tr.close();
                    }
                }
            }
        }
        finally {
            tr = this.ds.startTransaction("t1");
            throwable = null;
            try {
                tr.clear();
                tr.commit();
            }
            catch (Throwable throwable10) {
                throwable = throwable10;
                throw throwable10;
            }
            finally {
                if (tr != null) {
                    if (throwable != null) {
                        try {
                            tr.close();
                        }
                        catch (Throwable throwable11) {
                            throwable.addSuppressed(throwable11);
                        }
                    } else {
                        tr.close();
                    }
                }
            }
            tr = this.ds.startTransaction("t1");
            throwable = null;
            try {
                Assert.assertTrue((boolean)tr.keySet().isEmpty());
            }
            catch (Throwable throwable12) {
                throwable = throwable12;
                throw throwable12;
            }
            finally {
                if (tr != null) {
                    if (throwable != null) {
                        try {
                            tr.close();
                        }
                        catch (Throwable throwable13) {
                            throwable.addSuppressed(throwable13);
                        }
                    } else {
                        tr.close();
                    }
                }
            }
        }
    }
}

