/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.datastorage;

import eu.javaexperience.database.ConnectionBuilder;
import eu.javaexperience.database.ConnectionCreator;
import eu.javaexperience.database.ConnectionPool;
import eu.javaexperience.database.JDBC;
import eu.javaexperience.database.JdbcConnectionPool;
import eu.javaexperience.database.JdbcIssuedConnection;
import eu.javaexperience.database.collection.JdbcMap;
import eu.javaexperience.database.collection.JdbcMapImplProviders;
import eu.javaexperience.datastorage.DataStorage;
import eu.javaexperience.datastorage.DataStorageTest;
import eu.javaexperience.datastorage.sql.SqlDataStorage;
import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.javaexperience.reflect.Mirror;
import java.sql.Connection;

public class MysqlDataStorageTest
extends DataStorageTest {
    protected static DataStorage getMysqlStorage() {
        final String table = "test_table";
        JdbcConnectionPool cp = new JdbcConnectionPool(ConnectionCreator.fromConnectionBuilder((ConnectionBuilder)ConnectionBuilder.mysql, (String)"127.0.0.1", (int)3306, (String)"user", (String)"password", (String)"test"));
        try (JdbcIssuedConnection c = cp.getConnection();){
            if (!JDBC.isTableExists((Connection)c, (String)table)) {
                JdbcMapImplProviders.mysqlCreateKeyValTable((Connection)c, (String)table);
            }
        }
        catch (Exception e) {
            Mirror.propagateAnyway((Throwable)e);
        }
        return new SqlDataStorage((ConnectionPool)cp, (GetBy1)new GetBy1<JdbcMap.JdbcMapImplProvider<String, Object>, Connection>(){

            public JdbcMap.JdbcMapImplProvider<String, Object> getBy(Connection conn) {
                return JdbcMapImplProviders.mysql((Connection)conn, (String)table);
            }
        });
    }

    public MysqlDataStorageTest() {
        super(MysqlDataStorageTest.getMysqlStorage());
    }
}

