/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.pdw;

import eu.javaexperience.collection.map.SmallMap;
import eu.javaexperience.exceptions.IllegalOperationException;
import eu.javaexperience.exceptions.UnimplementedCaseException;
import eu.javaexperience.generic.annotations.Ignore;
import eu.javaexperience.io.file.FileTools;
import eu.javaexperience.pdw.BeanTools;
import eu.javaexperience.pdw.ProxyHelpedLazyImplementation;
import java.lang.reflect.Method;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class ProxyDataWrapperTest {
    public static ProxyHelpedLazyImplementation<LazyImplInterface, LazyImplObject, LazyImplRoot> create() throws Throwable {
        return new ProxyHelpedLazyImplementation<LazyImplInterface, LazyImplObject, LazyImplRoot>(LazyImplInterface.class, new LazyImplObject("/"), LazyImplRoot.class){

            public Object handleInterfaceCall(LazyImplObject root, Method method, Object[] params) throws Throwable {
                if (method.getName().equals("cast")) {
                    return this.wrapWithClass((Class)params[0], root);
                }
                if (LazyImplInterface.class.isAssignableFrom(method.getReturnType())) {
                    String[] cmd = BeanTools.decomposeCommand((String)method.getName());
                    if (cmd.length < 2) {
                        throw new IllegalOperationException("Plain operations are not implemented.");
                    }
                    if (!"get".equals(cmd[0])) {
                        throw new UnimplementedCaseException("Only get <T extends LazyImplInterface> implemented.");
                    }
                    return this.wrapWithClass(method.getReturnType(), new LazyImplObject(FileTools.normalizeSlashes((String)(root.path + "/" + BeanTools.getCLikeBeanNameFromMethodName((String)method.getName())))));
                }
                throw new RuntimeException("This is just a test case. What you've expected? :)");
            }
        };
    }

    @Test
    public void testPhli1() throws Throwable {
        ProxyHelpedLazyImplementation<LazyImplInterface, LazyImplObject, LazyImplRoot> h = ProxyDataWrapperTest.create();
        LazyImplRoot root = (LazyImplRoot)h.getRoot();
        Assert.assertEquals((Object)"/", (Object)root.getPath());
        Assert.assertEquals((Object)true, (Object)root.isActive());
        Assert.assertTrue((boolean)(root.cast(LazyImplWildcard.class) instanceof LazyImplWildcard));
        LazyImplLvl1 lvl1 = root.getLvl1();
        Assert.assertTrue((boolean)(lvl1 instanceof LazyImplLvl1));
        Assert.assertTrue((boolean)(lvl1 instanceof LazyImplInterface));
        Assert.assertEquals((Object)"/lvl1", (Object)lvl1.getPath());
    }

    @Test(expected=RuntimeException.class)
    public void testPhli2() throws Throwable {
        ProxyHelpedLazyImplementation<LazyImplInterface, LazyImplObject, LazyImplRoot> h = ProxyDataWrapperTest.create();
        ((LazyImplRoot)h.getRoot()).a();
    }

    @Test(expected=UnimplementedCaseException.class)
    public void testPhli3() throws Throwable {
        ProxyHelpedLazyImplementation<LazyImplInterface, LazyImplObject, LazyImplRoot> h = ProxyDataWrapperTest.create();
        ((LazyImplRoot)h.getRoot()).setLvl1();
    }

    @Test(expected=IllegalOperationException.class)
    public void testPhli4() throws Throwable {
        ProxyHelpedLazyImplementation<LazyImplInterface, LazyImplObject, LazyImplRoot> h = ProxyDataWrapperTest.create();
        ((LazyImplRoot)h.getRoot()).get();
    }

    public static interface LazyImplWildcard
    extends LazyImplInterface {
    }

    public static interface LazyImplLvl1
    extends LazyImplInterface {
    }

    public static interface LazyImplRoot
    extends LazyImplInterface {
        public LazyImplLvl1 getLvl1();

        public LazyImplLvl1 setLvl1();

        public LazyImplLvl1 isLvl1();

        public LazyImplLvl1 get();

        public byte[] a();
    }

    public static class LazyImplObject
    implements LazyImplInterface {
        protected String path;
        protected Map<String, Object> values = new SmallMap();

        public LazyImplObject(String path) {
            this.path = path;
        }

        @Override
        public void setProp(String key, Object value) {
            this.values.put(key, value);
        }

        @Override
        public Object getProp(String key) {
            return this.values.get(key);
        }

        @Override
        public boolean hasProp(String key) {
            return this.values.containsKey(key);
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public boolean isActive() {
            return true;
        }

        @Override
        @Ignore
        public <T extends LazyImplInterface> T cast(Class<T> dst) {
            return null;
        }
    }

    public static interface LazyImplInterface {
        public String getPath();

        public boolean isActive();

        public <T extends LazyImplInterface> T cast(Class<T> var1);

        public Object getProp(String var1);

        public boolean hasProp(String var1);

        public void setProp(String var1, Object var2);
    }
}

