/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.resource.pool;

import eu.javaexperience.resource.pool.IssuedResource;
import eu.javaexperience.resource.pool.TrackedLimitedResourcePool;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;

public class TrackedLimitedResourcePoolTest {
    @Test
    public void testPool1() throws Exception {
        TrackedLimitedResourcePool pool = new TrackedLimitedResourcePool(() -> "asdf", 10);
        Assert.assertEquals((long)0L, (long)pool.getFreeResourcesCount());
        Assert.assertEquals((long)10L, (long)pool.getResourceLimitCount());
        Assert.assertEquals((long)0L, (long)pool.getIssuedResourcesCount());
        try (IssuedResource res = pool.acquireResource();){
            Assert.assertEquals((Object)"asdf", (Object)res.getResource());
            Assert.assertEquals((long)0L, (long)pool.getFreeResourcesCount());
            Assert.assertEquals((long)10L, (long)pool.getResourceLimitCount());
            Assert.assertEquals((long)1L, (long)pool.getIssuedResourcesCount());
        }
        Assert.assertEquals((long)1L, (long)pool.getFreeResourcesCount());
        Assert.assertEquals((long)10L, (long)pool.getResourceLimitCount());
        Assert.assertEquals((long)0L, (long)pool.getIssuedResourcesCount());
        res = pool.acquireResource();
        Assert.assertEquals((long)0L, (long)pool.getFreeResourcesCount());
        Assert.assertEquals((long)10L, (long)pool.getResourceLimitCount());
        Assert.assertEquals((long)1L, (long)pool.getIssuedResourcesCount());
        pool.destroyResource(res);
        Assert.assertEquals((long)0L, (long)pool.getFreeResourcesCount());
        Assert.assertEquals((long)10L, (long)pool.getResourceLimitCount());
        Assert.assertEquals((long)0L, (long)pool.getIssuedResourcesCount());
    }

    @Test(expected=RuntimeException.class)
    public void testPool2() throws Exception {
        TrackedLimitedResourcePool pool = new TrackedLimitedResourcePool(() -> "asdf", 10);
        Assert.assertEquals((long)0L, (long)pool.getFreeResourcesCount());
        Assert.assertEquals((long)10L, (long)pool.getResourceLimitCount());
        Assert.assertEquals((long)0L, (long)pool.getIssuedResourcesCount());
        try (IssuedResource res = pool.acquireResource();){
            Assert.assertEquals((Object)"asdf", (Object)res.getResource());
            Assert.assertEquals((long)0L, (long)pool.getFreeResourcesCount());
            Assert.assertEquals((long)10L, (long)pool.getResourceLimitCount());
            Assert.assertEquals((long)1L, (long)pool.getIssuedResourcesCount());
            pool.destroyResource(res);
        }
    }

    @Test
    public void testPool3() throws Exception {
        TrackedLimitedResourcePool pool = new TrackedLimitedResourcePool(() -> "asdf", 2);
        Assert.assertEquals((long)0L, (long)pool.getFreeResourcesCount());
        Assert.assertEquals((long)2L, (long)pool.getResourceLimitCount());
        Assert.assertEquals((long)0L, (long)pool.getIssuedResourcesCount());
        pool.acquireResource();
        Assert.assertEquals((long)0L, (long)pool.getFreeResourcesCount());
        Assert.assertEquals((long)2L, (long)pool.getResourceLimitCount());
        Assert.assertEquals((long)1L, (long)pool.getIssuedResourcesCount());
        pool.acquireResource();
        Assert.assertEquals((long)0L, (long)pool.getFreeResourcesCount());
        Assert.assertEquals((long)2L, (long)pool.getResourceLimitCount());
        Assert.assertEquals((long)2L, (long)pool.getIssuedResourcesCount());
        long t0 = System.currentTimeMillis();
        Assert.assertNull((Object)pool.tryAcquireResource(1L, TimeUnit.SECONDS));
        Assert.assertTrue((System.currentTimeMillis() - t0 > 900L ? 1 : 0) != 0);
    }
}

