/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.cli;

import eu.javaexperience.cli.CliEntry;
import eu.javaexperience.cli.CliTools;
import eu.javaexperience.reflect.CastTo;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class CliTest {
    protected static final CliEntry<String> WORK_DIR = CliEntry.createFirstArgParserEntry(e -> e, (String)"Working directory", (String[])new String[]{"d", "-working-directory"});
    protected static final CliEntry<String> HOST = CliEntry.createFirstArgParserEntry(e -> e, (String)"host", (String[])new String[]{"h", "-host"});
    protected static final CliEntry<Integer> PORT = CliEntry.createFirstArgParserEntry(e -> Integer.parseInt(e), (String)"port", (String[])new String[]{"p", "-port"});
    protected static final CliEntry<Boolean> ENABLE = CliEntry.createFirstArgParserEntry(e -> (Boolean)CastTo.Boolean.cast(e), (String)"enable", (String[])new String[]{"e", "-enable"});
    protected static final CliEntry<String> ETC = CliEntry.createFirstArgParserEntry(e -> e, (String)"etc", (String[])new String[]{"x", "-etc"});
    protected static final CliEntry[] PROG_CLI_ENTRIES = new CliEntry[]{WORK_DIR, HOST, PORT, ENABLE};

    @Test
    public void testParseArgs1() {
        Map pa = CliTools.parseCliOpts((String[])new String[]{"-d", "/tmp/"});
        Assert.assertEquals((Object)"/tmp/", (Object)WORK_DIR.getSimple(pa));
        List args = WORK_DIR.getAll(pa);
        Assert.assertEquals((long)1L, (long)args.size());
        Assert.assertEquals((Object)"/tmp/", args.get(0));
    }

    @Test
    public void testParseArgs2() {
        Map pa = CliTools.parseCliOpts((String[])new String[]{"--working-directory", "/tmp/"});
        Assert.assertEquals((Object)"/tmp/", (Object)WORK_DIR.getSimple(pa));
        List args = WORK_DIR.getAll(pa);
        Assert.assertEquals((long)1L, (long)args.size());
        Assert.assertEquals((Object)"/tmp/", args.get(0));
    }

    @Test
    public void testParseArgs3() {
        Map pa = CliTools.parseCliOpts((String[])new String[]{"--working-directory", "/tmp/", "-d", "/var/tmp/"});
        Assert.assertEquals((Object)"/var/tmp/", (Object)WORK_DIR.getSimple(pa));
        List args = WORK_DIR.getAll(pa);
        Assert.assertEquals((long)2L, (long)args.size());
        Assert.assertEquals((Object)"/var/tmp/", args.get(0));
        Assert.assertEquals((Object)"/tmp/", args.get(1));
    }

    @Test
    public void testParseArgs4() {
        Map pa = CliTools.parseCliOpts((String[])new String[]{"-d", "/tmp/", "-h", "127.0.0.1", "--port", "80", "-e"});
        Assert.assertEquals((Object)"/tmp/", (Object)WORK_DIR.tryParse(pa));
        Assert.assertEquals((Object)"127.0.0.1", (Object)HOST.tryParse(pa));
        Assert.assertEquals((Object)80, (Object)PORT.tryParse(pa));
        Assert.assertEquals((Object)"80", (Object)PORT.getSimple(pa));
        Assert.assertEquals(null, (Object)ENABLE.tryParse(pa));
        Assert.assertTrue((boolean)ENABLE.hasOption(pa));
        Assert.assertFalse((boolean)ETC.hasOption(pa));
    }

    @Test
    public void testParseArgs5() {
        Map pa = CliTools.parseCliOpts((String[])new String[]{"-d", "/tmp/", "-h", "127.0.0.1", "--port", "80", "-e", "false"});
        Assert.assertEquals((Object)"/tmp/", (Object)WORK_DIR.tryParse(pa));
        Assert.assertEquals((Object)"127.0.0.1", (Object)HOST.tryParse(pa));
        Assert.assertEquals((Object)80, (Object)PORT.tryParse(pa));
        Assert.assertEquals((Object)"80", (Object)PORT.getSimple(pa));
        Assert.assertEquals((Object)false, (Object)ENABLE.tryParse(pa));
        Assert.assertTrue((boolean)ENABLE.hasOption(pa));
        Assert.assertFalse((boolean)ETC.hasOption(pa));
    }

    @Test
    public void testHelp() {
        String help = CliTools.renderListAllOption((CliEntry[])PROG_CLI_ENTRIES);
        Assert.assertTrue((boolean)help.contains("\t-d, --working-directory"));
        Assert.assertTrue((boolean)help.contains("\t-h, --host"));
        Assert.assertTrue((boolean)help.contains("\t-p, --port"));
        Assert.assertTrue((boolean)help.contains("\t-e, --enable"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBadParam() {
        Map pa = CliTools.parseCliOpts((String[])new String[]{"-h", "127.0.0.1", "-e", "-p", "x"});
        PORT.tryParse(pa);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBadParam2() {
        Map pa = CliTools.parseCliOpts((String[])new String[]{"-h", "127.0.0.1", "-p", "80", "-"});
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBadUsage() {
        Map pa = CliTools.parseCliOpts((String[])new String[]{"asdf"});
    }
}

