/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.collection.map;

import eu.javaexperience.collection.map.MapTools;
import eu.javaexperience.collection.map.SmallMap;
import eu.javaexperience.collection.map.TransactionMap;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class TransactionMapTest {
    public static TransactionMap<String, String> createTest() {
        SmallMap o = new SmallMap();
        TransactionMap ret = new TransactionMap(MapTools.inlineFill((Map)o, (Object[])new Object[]{"key", "value", "a", "A", "b", "B", "c", "C"}));
        Assert.assertEquals((Object)o, (Object)ret.getOriginalMap());
        return ret;
    }

    @Test
    public void testPassTroughtAndAccess() {
        TransactionMap<String, String> tr = TransactionMapTest.createTest();
        Assert.assertEquals((Object)"value", (Object)tr.get((Object)"key"));
        Assert.assertEquals((Object)"A", (Object)tr.get((Object)"a"));
        Assert.assertEquals((Object)"B", (Object)tr.get((Object)"b"));
        Assert.assertEquals((Object)"C", (Object)tr.get((Object)"c"));
        Assert.assertTrue((boolean)tr.getAccessMap().containsKey("key"));
        Assert.assertTrue((boolean)tr.getAccessMap().containsKey("a"));
        Assert.assertTrue((boolean)tr.getAccessMap().containsKey("b"));
        Assert.assertTrue((boolean)tr.getAccessMap().containsKey("c"));
        Assert.assertTrue((boolean)tr.getDiffMap().isEmpty());
    }

    @Test
    public void testKeysAndAccess() {
        TransactionMap<String, String> tr = TransactionMapTest.createTest();
        Set set = tr.keySet();
        Assert.assertEquals((long)4L, (long)set.size());
        Assert.assertTrue((boolean)set.contains("key"));
        Assert.assertTrue((boolean)set.contains("a"));
        Assert.assertTrue((boolean)set.contains("b"));
        Assert.assertTrue((boolean)set.contains("c"));
        Assert.assertTrue((boolean)tr.getAccessMap().containsKey("key"));
        Assert.assertTrue((boolean)tr.getAccessMap().containsKey("a"));
        Assert.assertTrue((boolean)tr.getAccessMap().containsKey("b"));
        Assert.assertTrue((boolean)tr.getAccessMap().containsKey("c"));
        Assert.assertEquals((long)4L, (long)tr.getAccessMap().size());
        Assert.assertEquals((long)4L, (long)tr.size());
    }

    @Test
    public void testPassContainsAndAccess() {
        TransactionMap<String, String> tr = TransactionMapTest.createTest();
        Assert.assertEquals((Object)"value", (Object)tr.get((Object)"key"));
        Assert.assertTrue((boolean)tr.containsKey((Object)"a"));
        Assert.assertTrue((boolean)tr.getAccessMap().containsKey("key"));
        Assert.assertTrue((boolean)tr.getAccessMap().containsKey("a"));
        Assert.assertTrue((boolean)tr.getDiffMap().isEmpty());
        Assert.assertEquals((long)4L, (long)tr.size());
    }

    @Test
    public void testPassContainsAndAccess2() {
        TransactionMap<String, String> tr = TransactionMapTest.createTest();
        Assert.assertEquals((Object)"value", (Object)tr.get((Object)"key"));
        Assert.assertTrue((boolean)tr.containsKey((Object)"a"));
        Assert.assertFalse((boolean)tr.containsKey((Object)"NONE"));
        Assert.assertTrue((boolean)tr.getAccessMap().containsKey("key"));
        Assert.assertTrue((boolean)tr.getAccessMap().containsKey("a"));
        Assert.assertTrue((boolean)tr.getAccessMap().containsKey("NONE"));
        Assert.assertTrue((boolean)tr.getDiffMap().isEmpty());
        Assert.assertEquals((long)4L, (long)tr.size());
    }

    @Test
    public void testPassTroughtAndAccessPartial() {
        TransactionMap<String, String> tr = TransactionMapTest.createTest();
        Assert.assertEquals((Object)"value", (Object)tr.get((Object)"key"));
        Assert.assertEquals((Object)"C", (Object)tr.get((Object)"c"));
        Assert.assertTrue((boolean)tr.getAccessMap().containsKey("key"));
        Assert.assertFalse((boolean)tr.getAccessMap().containsKey("a"));
        Assert.assertFalse((boolean)tr.getAccessMap().containsKey("b"));
        Assert.assertTrue((boolean)tr.getAccessMap().containsKey("c"));
        Assert.assertTrue((boolean)tr.getDiffMap().isEmpty());
        Assert.assertEquals((long)4L, (long)tr.size());
    }

    @Test
    public void testModifyAndAccess() {
        TransactionMap<String, String> tr = TransactionMapTest.createTest();
        Assert.assertEquals((Object)"value", (Object)tr.get((Object)"key"));
        Assert.assertEquals((Object)"A", (Object)tr.put((Object)"a", (Object)"a"));
        Assert.assertEquals((Object)"B", (Object)tr.put((Object)"b", (Object)"b"));
        Assert.assertEquals((Object)"C", (Object)tr.get((Object)"c"));
        Assert.assertEquals((Object)"a", (Object)tr.get((Object)"a"));
        Assert.assertEquals((Object)"b", (Object)tr.get((Object)"b"));
        Assert.assertTrue((boolean)tr.getAccessMap().containsKey("key"));
        Assert.assertTrue((boolean)tr.getAccessMap().containsKey("a"));
        Assert.assertTrue((boolean)tr.getAccessMap().containsKey("b"));
        Assert.assertTrue((boolean)tr.getAccessMap().containsKey("c"));
        Assert.assertTrue((boolean)tr.getDiffMap().containsKey("a"));
        Assert.assertTrue((boolean)tr.getDiffMap().containsKey("b"));
        Assert.assertEquals((Object)"a", tr.getDiffMap().get("a"));
        Assert.assertEquals((Object)"b", tr.getDiffMap().get("b"));
        Assert.assertEquals((long)4L, (long)tr.size());
    }

    @Test
    public void testModifyAndAccessExtra() {
        TransactionMap<String, String> tr = TransactionMapTest.createTest();
        Assert.assertEquals((Object)"value", (Object)tr.get((Object)"key"));
        Assert.assertEquals((Object)"A", (Object)tr.get((Object)"a"));
        Assert.assertEquals((Object)"B", (Object)tr.get((Object)"b"));
        Assert.assertEquals((Object)"A", (Object)tr.put((Object)"a", (Object)"x"));
        Assert.assertEquals((Object)"B", (Object)tr.put((Object)"b", (Object)"y"));
        Assert.assertEquals((Object)"C", (Object)tr.get((Object)"c"));
        Assert.assertEquals((Object)"x", (Object)tr.get((Object)"a"));
        Assert.assertEquals((Object)"y", (Object)tr.get((Object)"b"));
        Assert.assertTrue((boolean)tr.getAccessMap().containsKey("key"));
        Assert.assertTrue((boolean)tr.getAccessMap().containsKey("a"));
        Assert.assertTrue((boolean)tr.getAccessMap().containsKey("b"));
        Assert.assertTrue((boolean)tr.getAccessMap().containsKey("c"));
        Assert.assertTrue((boolean)tr.getDiffMap().containsKey("a"));
        Assert.assertTrue((boolean)tr.getDiffMap().containsKey("b"));
        Assert.assertEquals((Object)"x", tr.getDiffMap().get("a"));
        Assert.assertEquals((Object)"y", tr.getDiffMap().get("b"));
        Assert.assertEquals((long)4L, (long)tr.size());
    }

    @Test
    public void testModifyDoubleTimesAndAccess() {
        TransactionMap<String, String> tr = TransactionMapTest.createTest();
        Assert.assertEquals((Object)"value", (Object)tr.get((Object)"key"));
        Assert.assertEquals((Object)"A", (Object)tr.get((Object)"a"));
        Assert.assertEquals((Object)"B", (Object)tr.get((Object)"b"));
        Assert.assertEquals((Object)"A", (Object)tr.put((Object)"a", (Object)"a"));
        Assert.assertEquals((Object)"B", (Object)tr.put((Object)"b", (Object)"b"));
        Assert.assertEquals((Object)"a", (Object)tr.put((Object)"a", (Object)"a"));
        Assert.assertEquals((Object)"b", (Object)tr.put((Object)"b", (Object)"b"));
        Assert.assertEquals((Object)"C", (Object)tr.get((Object)"c"));
        Assert.assertEquals((Object)"a", (Object)tr.get((Object)"a"));
        Assert.assertEquals((Object)"b", (Object)tr.get((Object)"b"));
        Assert.assertTrue((boolean)tr.getAccessMap().containsKey("key"));
        Assert.assertTrue((boolean)tr.getAccessMap().containsKey("a"));
        Assert.assertTrue((boolean)tr.getAccessMap().containsKey("b"));
        Assert.assertTrue((boolean)tr.getAccessMap().containsKey("c"));
        Assert.assertTrue((boolean)tr.getDiffMap().containsKey("a"));
        Assert.assertTrue((boolean)tr.getDiffMap().containsKey("b"));
        Assert.assertEquals((Object)"a", tr.getDiffMap().get("a"));
        Assert.assertEquals((Object)"b", tr.getDiffMap().get("b"));
        Assert.assertEquals((long)4L, (long)tr.size());
    }

    @Test
    public void testModifyAndDeleteAndAccess() {
        TransactionMap<String, String> tr = TransactionMapTest.createTest();
        Assert.assertEquals((Object)"value", (Object)tr.get((Object)"key"));
        Assert.assertEquals((Object)"A", (Object)tr.get((Object)"a"));
        Assert.assertEquals((Object)"B", (Object)tr.get((Object)"b"));
        Assert.assertEquals((Object)"A", (Object)tr.put((Object)"a", (Object)"a"));
        Assert.assertEquals((Object)"B", (Object)tr.put((Object)"b", (Object)"b"));
        Assert.assertEquals((Object)"a", (Object)tr.put((Object)"a", (Object)"a"));
        Assert.assertEquals((Object)"b", (Object)tr.put((Object)"b", (Object)"b"));
        Assert.assertEquals((Object)"value", (Object)tr.remove((Object)"key"));
        Assert.assertEquals((Object)"a", (Object)tr.get((Object)"a"));
        Assert.assertEquals((Object)"b", (Object)tr.get((Object)"b"));
        Assert.assertTrue((boolean)tr.getAccessMap().containsKey("key"));
        Assert.assertTrue((boolean)tr.getAccessMap().containsKey("a"));
        Assert.assertTrue((boolean)tr.getAccessMap().containsKey("b"));
        Assert.assertTrue((boolean)tr.getDiffMap().containsKey("a"));
        Assert.assertTrue((boolean)tr.getDiffMap().containsKey("b"));
        Assert.assertEquals((Object)TransactionMap.NULL_VALUE, tr.getDiffMap().get("key"));
        Assert.assertEquals((Object)"a", tr.getDiffMap().get("a"));
        Assert.assertEquals((Object)"b", tr.getDiffMap().get("b"));
        Assert.assertEquals((long)3L, (long)tr.size());
    }

    @Test
    public void testClear() {
        TransactionMap<String, String> tr = TransactionMapTest.createTest();
        tr.clear();
        Assert.assertNull((Object)tr.get((Object)"key"));
        Assert.assertNull((Object)tr.get((Object)"a"));
        Assert.assertNull((Object)tr.get((Object)"b"));
        Assert.assertNull((Object)tr.get((Object)"c"));
        Assert.assertTrue((boolean)tr.getAccessMap().containsKey("key"));
        Assert.assertTrue((boolean)tr.getAccessMap().containsKey("a"));
        Assert.assertTrue((boolean)tr.getAccessMap().containsKey("b"));
        Assert.assertTrue((boolean)tr.getAccessMap().containsKey("c"));
        Assert.assertNull((Object)tr.get((Object)"key"));
        Assert.assertNull((Object)tr.get((Object)"a"));
        Assert.assertNull((Object)tr.get((Object)"b"));
        Assert.assertNull((Object)tr.get((Object)"c"));
        Assert.assertEquals((long)0L, (long)tr.size());
    }

    @Test
    public void testDeleteThenInsert() {
        TransactionMap<String, String> tr = TransactionMapTest.createTest();
        tr.clear();
        Assert.assertNull((Object)tr.get((Object)"key"));
        Assert.assertNull((Object)tr.get((Object)"a"));
        Assert.assertNull((Object)tr.get((Object)"b"));
        Assert.assertNull((Object)tr.get((Object)"c"));
        Assert.assertNull((Object)tr.put((Object)"key", (Object)"new"));
        Assert.assertNull((Object)tr.put((Object)"a", (Object)"X"));
        Assert.assertNull((Object)tr.put((Object)"b", (Object)"Y"));
        Assert.assertNull((Object)tr.put((Object)"c", (Object)"Z"));
        Assert.assertTrue((boolean)tr.getAccessMap().containsKey("key"));
        Assert.assertTrue((boolean)tr.getAccessMap().containsKey("a"));
        Assert.assertTrue((boolean)tr.getAccessMap().containsKey("b"));
        Assert.assertTrue((boolean)tr.getAccessMap().containsKey("c"));
        Assert.assertEquals((Object)"value", tr.getAccessMap().get("key"));
        Assert.assertEquals((Object)"A", tr.getAccessMap().get("a"));
        Assert.assertEquals((Object)"B", tr.getAccessMap().get("b"));
        Assert.assertEquals((Object)"C", tr.getAccessMap().get("c"));
        Assert.assertEquals((Object)"new", (Object)tr.get((Object)"key"));
        Assert.assertEquals((Object)"X", (Object)tr.get((Object)"a"));
        Assert.assertEquals((Object)"Y", (Object)tr.get((Object)"b"));
        Assert.assertEquals((Object)"Z", (Object)tr.get((Object)"c"));
        Assert.assertEquals((long)4L, (long)tr.size());
    }

    @Test
    public void addNewValue() {
        TransactionMap<String, String> tr = TransactionMapTest.createTest();
        tr.put((Object)"x", (Object)"X");
        tr.put((Object)"y", (Object)"Y");
        tr.put((Object)"z", (Object)"Z");
        Assert.assertFalse((String)"value", (boolean)tr.getAccessMap().containsKey("key"));
        Assert.assertFalse((String)"A", (boolean)tr.getAccessMap().containsKey("a"));
        Assert.assertFalse((String)"B", (boolean)tr.getAccessMap().containsKey("b"));
        Assert.assertFalse((String)"C", (boolean)tr.getAccessMap().containsKey("c"));
        Assert.assertTrue((boolean)tr.getAccessMap().containsKey("x"));
        Assert.assertTrue((boolean)tr.getAccessMap().containsKey("y"));
        Assert.assertTrue((boolean)tr.getAccessMap().containsKey("z"));
        Assert.assertEquals((Object)"value", (Object)tr.get((Object)"key"));
        Assert.assertEquals((Object)"X", (Object)tr.get((Object)"x"));
        Assert.assertEquals((Object)"Y", (Object)tr.get((Object)"y"));
        Assert.assertEquals((Object)"Z", (Object)tr.get((Object)"z"));
        Assert.assertEquals((long)7L, (long)tr.size());
    }

    @Test
    public void addThenDeleteValue() {
        TransactionMap<String, String> tr = TransactionMapTest.createTest();
        Assert.assertNull((Object)tr.put((Object)"new", (Object)"asd"));
        Assert.assertEquals((long)5L, (long)tr.size());
        Assert.assertEquals((Object)"asd", (Object)tr.remove((Object)"new"));
        Assert.assertEquals((long)4L, (long)tr.size());
        Assert.assertTrue((boolean)tr.getDiffMap().containsKey("new"));
        Assert.assertEquals((long)1L, (long)tr.getDiffMap().size());
        Assert.assertNull((Object)tr.getAccessTimeValue((Object)"new"));
        Assert.assertNull((Object)tr.get((Object)"new"));
    }

    public void modifyAndRevert() {
        TransactionMap<String, String> tr = TransactionMapTest.createTest();
        Assert.assertEquals((Object)"value", (Object)tr.get((Object)"key"));
        Assert.assertEquals((Object)"A", (Object)tr.put((Object)"a", (Object)"a"));
        Assert.assertEquals((Object)"B", (Object)tr.put((Object)"b", (Object)"b"));
        Assert.assertEquals((long)4L, (long)tr.size());
        Assert.assertEquals((Object)"value", (Object)tr.remove((Object)"key"));
        Assert.assertEquals((Object)"a", (Object)tr.put((Object)"a", (Object)"A"));
        Assert.assertEquals((Object)"b", (Object)tr.put((Object)"b", (Object)"B"));
        Assert.assertNull((Object)tr.put((Object)"key", (Object)"value"));
        Assert.assertEquals((long)3L, (long)tr.getDiffMap().size());
        Assert.assertEquals((Object)"value", (Object)tr.getAccessTimeValue((Object)"key"));
        Assert.assertEquals((Object)"value", (Object)tr.get((Object)"key"));
        Assert.assertEquals((Object)"A", (Object)tr.getAccessTimeValue((Object)"a"));
        Assert.assertEquals((Object)"A", (Object)tr.get((Object)"a"));
        Assert.assertEquals((Object)"B", (Object)tr.getAccessTimeValue((Object)"b"));
        Assert.assertEquals((Object)"B", (Object)tr.get((Object)"b"));
    }

    @Test
    public void lazyAccessValue() {
        TransactionMap<String, String> tr = TransactionMapTest.createTest();
        tr.get((Object)"a");
        Assert.assertNull((Object)tr.getAccessTimeValue((Object)"key"));
        Assert.assertEquals((Object)"A", (Object)tr.getAccessTimeValue((Object)"a"));
    }

    @Test
    public void note_SizeTouchesAccess() {
        TransactionMap<String, String> tr = TransactionMapTest.createTest();
        Assert.assertEquals((long)4L, (long)tr.size());
        Assert.assertEquals((long)0L, (long)tr.getDiffMap().size());
        Assert.assertEquals((long)4L, (long)tr.getAccessMap().size());
    }
}

