/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.database.impl;

import eu.javaexperience.collection.CollectionTools;
import eu.javaexperience.database.annotations.Length;
import eu.javaexperience.database.annotations.Unique;
import eu.javaexperience.database.impl.UsualDbModel;
import eu.javaexperience.database.jdbc.Id;
import eu.javaexperience.database.pojodb.Model;
import eu.javaexperience.database.pojodb.SqlDatabase;
import eu.javaexperience.time.TimeCalc;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public abstract class UsualDbModelTest {
    public abstract SqlDatabase createConnection(boolean var1) throws Exception;

    @Test
    public void testCreateInsertDeleteFromTable() throws Exception {
        SqlDatabase db = this.createConnection(true);
        db.ensureTable(User.class);
        Date now = TimeCalc.setToDate((Date)new Date(), (int)-1, (int)-1, (int)-1, (int)-1, (int)-1, (int)-1, (int)0);
        User u = new User();
        u.visible_name = "Dank\u00f3 D\u00e1vid";
        u.email = "info@dankodavid.hu";
        u.extra_data = "{\"born_time\":708306900000}";
        u.disabled = false;
        u.created_at = now;
        db.insert((Model)u);
        Assert.assertEquals((long)1L, (long)u.id);
        List us = db.getWhere(User.class, "", new Object[0]);
        Assert.assertEquals((long)1L, (long)us.size());
        Assert.assertEquals((long)1L, (long)((User)((Object)us.get((int)0))).id);
        Assert.assertEquals((Object)"Dank\u00f3 D\u00e1vid", (Object)((User)((Object)us.get((int)0))).visible_name);
        Assert.assertEquals((Object)"info@dankodavid.hu", (Object)((User)((Object)us.get((int)0))).email);
        Assert.assertFalse((boolean)((User)((Object)us.get((int)0))).disabled);
        Assert.assertEquals((Object)"{\"born_time\":708306900000}", (Object)((User)((Object)us.get((int)0))).extra_data);
        Assert.assertEquals((long)now.getTime(), (long)((User)((Object)us.get((int)0))).created_at.getTime());
        db.delete((Model)us.get(0));
        Assert.assertTrue((boolean)db.getWhere(User.class, "", new Object[0]).isEmpty());
    }

    @Test
    public void testInsertId() throws Exception {
        SqlDatabase db = this.createConnection(true);
        db.ensureTable(User.class);
        Date now = TimeCalc.setToDate((Date)new Date(), (int)-1, (int)-1, (int)-1, (int)-1, (int)-1, (int)-1, (int)0);
        User u = new User();
        u.id = 12;
        u.visible_name = "Dank\u00f3 D\u00e1vid";
        u.email = "info@dankodavid.hu";
        u.extra_data = "{\"born_time\":708306900000}";
        u.disabled = false;
        u.created_at = now;
        db.insert((Model)u);
        Assert.assertEquals((long)12L, (long)u.id);
        List us = db.getWhere(User.class, null);
        Assert.assertEquals((long)1L, (long)us.size());
        Assert.assertEquals((long)12L, (long)((User)((Object)us.get((int)0))).id);
        Assert.assertEquals((Object)"Dank\u00f3 D\u00e1vid", (Object)((User)((Object)us.get((int)0))).visible_name);
        Assert.assertEquals((Object)"info@dankodavid.hu", (Object)((User)((Object)us.get((int)0))).email);
        Assert.assertFalse((boolean)((User)((Object)us.get((int)0))).disabled);
        Assert.assertEquals((Object)"{\"born_time\":708306900000}", (Object)((User)((Object)us.get((int)0))).extra_data);
        Assert.assertEquals((long)now.getTime(), (long)((User)((Object)us.get((int)0))).created_at.getTime());
    }

    @Test
    public void testSaveSwitchTable() throws Exception {
        SqlDatabase db = this.createConnection(true);
        db.ensureTable(UserUserGroup.class);
        UserUserGroup uug2 = new UserUserGroup();
        uug2.user = 1;
        uug2.group = 10;
        db.insert((Model)uug2);
        uug2 = new UserUserGroup();
        uug2.user = 1;
        uug2.group = 1024;
        db.insert((Model)uug2);
        List uugs = db.getWhere(UserUserGroup.class, "", new Object[0]);
        HashSet grps = new HashSet();
        CollectionTools.convert(grps, (Collection)uugs, uug -> uug.group);
        Assert.assertTrue((boolean)grps.contains(10));
        Assert.assertTrue((boolean)grps.contains(1024));
    }

    @Test
    public void testAlterTableAndUpdate() throws Exception {
        SqlDatabase db = this.createConnection(true);
        db.ensureTable(User.class);
        Date now = TimeCalc.setToDate((Date)new Date(), (int)-1, (int)-1, (int)-1, (int)-1, (int)-1, (int)-1, (int)0);
        User u = new User();
        u.visible_name = "Dank\u00f3 D\u00e1vid";
        u.email = "info@dankodavid.hu";
        u.extra_data = "{\"born_time\":708306900000}";
        u.disabled = false;
        u.created_at = now;
        db.insert((Model)u);
        Assert.assertEquals((long)1L, (long)u.id);
        Date login = TimeCalc.setToDate((Date)new Date(), (int)2015, (int)-1, (int)-1, (int)-1, (int)-1, (int)-1, (int)0);
        db.ensureTable(ExtendUser.class);
        List us = db.getWhere(ExtendUser.class, "", new Object[0]);
        Assert.assertEquals((long)1L, (long)us.size());
        ExtendUser eu = (ExtendUser)((Object)us.get(0));
        Assert.assertEquals((long)1L, (long)eu.id);
        Assert.assertEquals((Object)"Dank\u00f3 D\u00e1vid", (Object)eu.visible_name);
        Assert.assertEquals((Object)"info@dankodavid.hu", (Object)eu.email);
        Assert.assertFalse((boolean)eu.disabled);
        Assert.assertEquals((Object)"{\"born_time\":708306900000}", (Object)eu.extra_data);
        Assert.assertEquals((long)now.getTime(), (long)((ExtendUser)((Object)us.get((int)0))).created_at.getTime());
        eu.last_login = login;
        db.updateById((Model)eu);
        us = db.getWhere(ExtendUser.class, "", new Object[0]);
        Assert.assertEquals((long)1L, (long)us.size());
        eu = (ExtendUser)((Object)us.get(0));
        Assert.assertEquals((long)1L, (long)eu.id);
        Assert.assertEquals((Object)"Dank\u00f3 D\u00e1vid", (Object)eu.visible_name);
        Assert.assertEquals((Object)"info@dankodavid.hu", (Object)eu.email);
        Assert.assertFalse((boolean)eu.disabled);
        Assert.assertEquals((Object)"{\"born_time\":708306900000}", (Object)eu.extra_data);
        Assert.assertEquals((long)now.getTime(), (long)((ExtendUser)((Object)us.get((int)0))).created_at.getTime());
        Assert.assertEquals((long)login.getTime(), (long)((ExtendUser)((Object)us.get((int)0))).last_login.getTime());
    }

    public static class ExtendUser
    extends User {
        public Date last_login;
    }

    public static class UserUserGroup
    extends UsualDbModel {
        public int user;
        public int group;

        public String getTable() {
            return "user__user_group";
        }
    }

    public static class User
    extends UsualDbModel {
        @Id
        public int id;
        @Length(length=64)
        public String visible_name;
        @Unique
        @Length(length=64)
        public String email;
        public boolean disabled;
        public String extra_data;
        public Date created_at;

        public String getTable() {
            return "user";
        }
    }
}

