/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.query;

import eu.javaexperience.collection.CollectionTools;
import eu.javaexperience.query.F;
import eu.javaexperience.query.L;
import eu.javaexperience.query.LogicalGroup;
import eu.javaexperience.query.QueryEvaluator;
import eu.javaexperience.query.QueryEvaluatorBuilder;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.time.TimeCalc;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class TestQueryEvaluator {
    public static List<EvalTestObject> createTestCollection() {
        ArrayList<EvalTestObject> ret = new ArrayList<EvalTestObject>();
        ret.add(new EvalTestObject(1, "Test", "ACTIVE", "PENDING"));
        ret.add(new EvalTestObject(2, "test", "ACTIVE"));
        ret.add(new EvalTestObject(3, "Hello World", "CLOSED"));
        ret.add(new EvalTestObject(4, "asdg", "COLSED"));
        ret.add(new EvalTestObject(5, "Hello_World", "CLOSED", "IRRELEVANT"));
        return ret;
    }

    public static <T> QueryEvaluator<T> createEvaluator() {
        return new QueryEvaluator(new QueryEvaluatorBuilder().build());
    }

    @Test
    public void testEq() {
        List<EvalTestObject> from = TestQueryEvaluator.createTestCollection();
        QueryEvaluator qe = TestQueryEvaluator.createEvaluator();
        ArrayList to = new ArrayList();
        qe.select(to, from, F.eq.is("str", (Object)"Test"));
        Assert.assertEquals((long)1L, (long)to.size());
        Assert.assertEquals((Object)"Test", (Object)((EvalTestObject)to.get((int)0)).str);
        Assert.assertEquals((Object)1, (Object)((EvalTestObject)to.get((int)0)).id);
    }

    @Test
    public void testCmp() {
        List<EvalTestObject> from = TestQueryEvaluator.createTestCollection();
        QueryEvaluator qe = TestQueryEvaluator.createEvaluator();
        ArrayList to = new ArrayList();
        qe.select(to, from, F.lte.is("id", (Object)3));
        Assert.assertEquals((long)3L, (long)to.size());
        Assert.assertEquals((Object)"Test", (Object)((EvalTestObject)to.get((int)0)).str);
        Assert.assertEquals((Object)1, (Object)((EvalTestObject)to.get((int)0)).id);
        Assert.assertEquals((Object)"test", (Object)((EvalTestObject)to.get((int)1)).str);
        Assert.assertEquals((Object)2, (Object)((EvalTestObject)to.get((int)1)).id);
        Assert.assertEquals((Object)"Hello World", (Object)((EvalTestObject)to.get((int)2)).str);
        Assert.assertEquals((Object)3, (Object)((EvalTestObject)to.get((int)2)).id);
        to.clear();
        qe.select(to, from, F.gte.is("id", (Object)3));
        Assert.assertEquals((long)3L, (long)to.size());
        Assert.assertEquals((Object)"Hello World", (Object)((EvalTestObject)to.get((int)0)).str);
        Assert.assertEquals((Object)3, (Object)((EvalTestObject)to.get((int)0)).id);
        Assert.assertEquals((Object)"asdg", (Object)((EvalTestObject)to.get((int)1)).str);
        Assert.assertEquals((Object)4, (Object)((EvalTestObject)to.get((int)1)).id);
        Assert.assertEquals((Object)"Hello_World", (Object)((EvalTestObject)to.get((int)2)).str);
        Assert.assertEquals((Object)5, (Object)((EvalTestObject)to.get((int)2)).id);
        to.clear();
        qe.select(to, from, F.eq.is("id", (Object)3));
        Assert.assertEquals((long)1L, (long)to.size());
        Assert.assertEquals((Object)"Hello World", (Object)((EvalTestObject)to.get((int)0)).str);
        Assert.assertEquals((Object)3, (Object)((EvalTestObject)to.get((int)0)).id);
    }

    @Test
    public void testIn1() {
        List<EvalTestObject> from = TestQueryEvaluator.createTestCollection();
        QueryEvaluator qe = TestQueryEvaluator.createEvaluator();
        ArrayList to = new ArrayList();
        qe.select(to, from, F.in.is("id", (Object)CollectionTools.inlineAdd(new ArrayList(), (Object[])new Integer[]{2, 3, 5, 10})));
        Assert.assertEquals((long)3L, (long)to.size());
        Assert.assertEquals((Object)"test", (Object)((EvalTestObject)to.get((int)0)).str);
        Assert.assertEquals((Object)2, (Object)((EvalTestObject)to.get((int)0)).id);
        Assert.assertEquals((Object)"Hello World", (Object)((EvalTestObject)to.get((int)1)).str);
        Assert.assertEquals((Object)3, (Object)((EvalTestObject)to.get((int)1)).id);
        Assert.assertEquals((Object)"Hello_World", (Object)((EvalTestObject)to.get((int)2)).str);
        Assert.assertEquals((Object)5, (Object)((EvalTestObject)to.get((int)2)).id);
        to.clear();
        qe.select(to, from, F.in.is("id", new ArrayList()));
        Assert.assertEquals((long)0L, (long)to.size());
    }

    @Test
    public void testIn2() {
        List<EvalTestObject> from = TestQueryEvaluator.createTestCollection();
        QueryEvaluator qe = TestQueryEvaluator.createEvaluator();
        ArrayList to = new ArrayList();
        qe.select(to, from, F.in.is("str", (Object)CollectionTools.inlineAdd(new ArrayList(), (Object[])new String[]{"test", "asdg", "Hello World", "random"})));
        Assert.assertEquals((long)3L, (long)to.size());
        Assert.assertEquals((Object)"test", (Object)((EvalTestObject)to.get((int)0)).str);
        Assert.assertEquals((Object)2, (Object)((EvalTestObject)to.get((int)0)).id);
        Assert.assertEquals((Object)"Hello World", (Object)((EvalTestObject)to.get((int)1)).str);
        Assert.assertEquals((Object)3, (Object)((EvalTestObject)to.get((int)1)).id);
        Assert.assertEquals((Object)"asdg", (Object)((EvalTestObject)to.get((int)2)).str);
        Assert.assertEquals((Object)4, (Object)((EvalTestObject)to.get((int)2)).id);
        to.clear();
        qe.select(to, from, F.in.is("id", new ArrayList()));
        Assert.assertEquals((long)0L, (long)to.size());
    }

    @Test
    public void testMatches() {
        List<EvalTestObject> from = TestQueryEvaluator.createTestCollection();
        QueryEvaluator qe = TestQueryEvaluator.createEvaluator();
        ArrayList to = new ArrayList();
        qe.select(to, from, F.match.is("str", (Object)"^H.*_.*$"));
        Assert.assertEquals((long)1L, (long)to.size());
        Assert.assertEquals((Object)"Hello_World", (Object)((EvalTestObject)to.get((int)0)).str);
        Assert.assertEquals((Object)5, (Object)((EvalTestObject)to.get((int)0)).id);
        to.clear();
        qe.select(to, from, F.match.is("str", (Object)"^H.*"));
        Assert.assertEquals((long)2L, (long)to.size());
        Assert.assertEquals((Object)"Hello World", (Object)((EvalTestObject)to.get((int)0)).str);
        Assert.assertEquals((Object)3, (Object)((EvalTestObject)to.get((int)0)).id);
        Assert.assertEquals((Object)"Hello_World", (Object)((EvalTestObject)to.get((int)1)).str);
        Assert.assertEquals((Object)5, (Object)((EvalTestObject)to.get((int)1)).id);
    }

    @Test
    public void testNullNoResult() {
        List<EvalTestObject> from = TestQueryEvaluator.createTestCollection();
        QueryEvaluator qe = TestQueryEvaluator.createEvaluator();
        ArrayList to = new ArrayList();
        qe.select(to, from, F.contains.is("str", null));
        Assert.assertEquals((long)0L, (long)to.size());
        qe.select(to, from, F.eq.is("str", null));
        Assert.assertEquals((long)0L, (long)to.size());
        qe.select(to, from, F.gt.is("str", null));
        Assert.assertEquals((long)0L, (long)to.size());
        qe.select(to, from, F.gte.is("str", null));
        Assert.assertEquals((long)0L, (long)to.size());
        qe.select(to, from, F.in.is("str", null));
        Assert.assertEquals((long)0L, (long)to.size());
        qe.select(to, from, F.lt.is("str", null));
        Assert.assertEquals((long)0L, (long)to.size());
        qe.select(to, from, F.lte.is("str", null));
        Assert.assertEquals((long)0L, (long)to.size());
        qe.select(to, from, F.match.is("str", null));
        Assert.assertEquals((long)0L, (long)to.size());
    }

    @Test
    public void testMatchCollection() {
        List<EvalTestObject> from = TestQueryEvaluator.createTestCollection();
        QueryEvaluator qe = TestQueryEvaluator.createEvaluator();
        ArrayList to = new ArrayList();
        qe.select(to, from, F.match.is("str", (Object)CollectionTools.inlineArrayList((Object[])new String[]{"^H.*", ".*rld$"})));
        Assert.assertEquals((long)2L, (long)to.size());
        Assert.assertEquals((Object)"Hello World", (Object)((EvalTestObject)to.get((int)0)).str);
        Assert.assertEquals((Object)3, (Object)((EvalTestObject)to.get((int)0)).id);
        Assert.assertEquals((Object)"Hello_World", (Object)((EvalTestObject)to.get((int)1)).str);
        Assert.assertEquals((Object)5, (Object)((EvalTestObject)to.get((int)1)).id);
    }

    @Test
    public void testInCollection() {
        List<EvalTestObject> from = TestQueryEvaluator.createTestCollection();
        QueryEvaluator qe = TestQueryEvaluator.createEvaluator();
        ArrayList to = new ArrayList();
        qe.select(to, from, F.in.is("state", (Object)CollectionTools.inlineArrayList((Object[])new String[]{"ACTIVE"})));
        Assert.assertEquals((long)2L, (long)to.size());
        Assert.assertEquals((Object)"Test", (Object)((EvalTestObject)to.get((int)0)).str);
        Assert.assertEquals((Object)1, (Object)((EvalTestObject)to.get((int)0)).id);
        Assert.assertEquals((Object)"test", (Object)((EvalTestObject)to.get((int)1)).str);
        Assert.assertEquals((Object)2, (Object)((EvalTestObject)to.get((int)1)).id);
        to.clear();
        qe.select(to, from, F.in.is("state", (Object)CollectionTools.inlineArrayList((Object[])new String[]{"ACTIVE", "IRRELEVANT"})));
        Assert.assertEquals((long)3L, (long)to.size());
        Assert.assertEquals((Object)"Test", (Object)((EvalTestObject)to.get((int)0)).str);
        Assert.assertEquals((Object)1, (Object)((EvalTestObject)to.get((int)0)).id);
        Assert.assertEquals((Object)"test", (Object)((EvalTestObject)to.get((int)1)).str);
        Assert.assertEquals((Object)2, (Object)((EvalTestObject)to.get((int)1)).id);
        Assert.assertEquals((Object)"Hello_World", (Object)((EvalTestObject)to.get((int)2)).str);
        Assert.assertEquals((Object)5, (Object)((EvalTestObject)to.get((int)2)).id);
    }

    @Test
    public void testInCollectionNonArray() {
        List<EvalTestObject> from = TestQueryEvaluator.createTestCollection();
        QueryEvaluator qe = TestQueryEvaluator.createEvaluator();
        ArrayList to = new ArrayList();
        qe.select(to, from, F.in.is("state", (Object)"ACTIVE"));
        Assert.assertEquals((long)2L, (long)to.size());
        Assert.assertEquals((Object)"Test", (Object)((EvalTestObject)to.get((int)0)).str);
        Assert.assertEquals((Object)1, (Object)((EvalTestObject)to.get((int)0)).id);
        Assert.assertEquals((Object)"test", (Object)((EvalTestObject)to.get((int)1)).str);
        Assert.assertEquals((Object)2, (Object)((EvalTestObject)to.get((int)1)).id);
    }

    @Test
    public void testInCollectionNoParamNoMatch() {
        List<EvalTestObject> from = TestQueryEvaluator.createTestCollection();
        QueryEvaluator qe = TestQueryEvaluator.createEvaluator();
        ArrayList to = new ArrayList();
        qe.select(to, from, F.in.is("state", (Object)CollectionTools.inlineArrayList((Object[])new Object[0])));
        Assert.assertEquals((long)0L, (long)to.size());
    }

    @Test
    public void testIndirectContainsAll() {
        List<EvalTestObject> from = TestQueryEvaluator.createTestCollection();
        QueryEvaluator qe = TestQueryEvaluator.createEvaluator();
        ArrayList to = new ArrayList();
        qe.select(to, from, F.eq.is("state", (Object)CollectionTools.inlineArrayList((Object[])new String[]{"ACTIVE", "PENDING"})));
        Assert.assertEquals((long)1L, (long)to.size());
        Assert.assertEquals((Object)"Test", (Object)((EvalTestObject)to.get((int)0)).str);
        Assert.assertEquals((Object)1, (Object)((EvalTestObject)to.get((int)0)).id);
    }

    @Test
    public void testAnd() {
        List<EvalTestObject> from = TestQueryEvaluator.createTestCollection();
        QueryEvaluator qe = TestQueryEvaluator.createEvaluator();
        ArrayList to = new ArrayList();
        qe.select(to, from, L.and((LogicalGroup[])new LogicalGroup[]{F.in.is("state", (Object)"ACTIVE"), F.gt.is("id", (Object)1)}));
        Assert.assertEquals((long)1L, (long)to.size());
        Assert.assertEquals((Object)"test", (Object)((EvalTestObject)to.get((int)0)).str);
        Assert.assertEquals((Object)2, (Object)((EvalTestObject)to.get((int)0)).id);
    }

    @Test
    public void testOr() {
        List<EvalTestObject> from = TestQueryEvaluator.createTestCollection();
        QueryEvaluator qe = TestQueryEvaluator.createEvaluator();
        ArrayList to = new ArrayList();
        qe.select(to, from, L.or((LogicalGroup[])new LogicalGroup[]{F.in.is("state", (Object)"IRRELEVANT"), F.lt.is("id", (Object)2)}));
        Assert.assertEquals((long)2L, (long)to.size());
        Assert.assertEquals((Object)"Test", (Object)((EvalTestObject)to.get((int)0)).str);
        Assert.assertEquals((Object)1, (Object)((EvalTestObject)to.get((int)0)).id);
        Assert.assertEquals((Object)"Hello_World", (Object)((EvalTestObject)to.get((int)1)).str);
        Assert.assertEquals((Object)5, (Object)((EvalTestObject)to.get((int)1)).id);
    }

    @Test
    public void testFindDinamic() {
        ArrayList<Object> from = new ArrayList<Object>();
        from.add(new Object(){
            public String field1 = "value";
        });
        from.add(new Object(){
            public Date createDate = TimeCalc.dateUtc((int)2019, (int)5, (int)10, (int)10, (int)23, (int)0, (int)0);
        });
        from.add(new Object(){
            public Date createDate = TimeCalc.dateUtc((int)2018, (int)10, (int)10, (int)10, (int)23, (int)0, (int)0);
        });
        from.add(new Object(){
            public Integer id = 10;
        });
        QueryEvaluator qe = TestQueryEvaluator.createEvaluator();
        ArrayList to = new ArrayList();
        qe.select(to, from, F.gt.is("createDate", (Object)TimeCalc.dateUtc((int)2019, (int)0, (int)0, (int)0, (int)0, (int)0, (int)0)));
        Assert.assertEquals((long)1L, (long)to.size());
        to.clear();
        qe.select(to, from, F.lt.is("createDate", (Object)TimeCalc.dateUtc((int)2020, (int)0, (int)0, (int)0, (int)0, (int)0, (int)0)));
        Assert.assertEquals((long)2L, (long)to.size());
        to.clear();
        qe.select(to, from, F.eq.is("id", (Object)10));
        Assert.assertEquals((long)1L, (long)to.size());
        to.clear();
        qe.select(to, from, F.eq.not("createDate", null));
        Assert.assertEquals((long)2L, (long)to.size());
        to.clear();
    }

    public static class EvalTestObject {
        public Integer id;
        public String str;
        protected List<String> state = new ArrayList<String>();

        public EvalTestObject(Integer id, String str, String ... states) {
            this.id = id;
            this.str = str;
            CollectionTools.inlineAdd(this.state, (Object[])states);
        }

        public String toString() {
            return Mirror.usualToString((Object)this);
        }
    }
}

