/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.reflect;

import eu.javaexperience.collection.map.MapTools;
import eu.javaexperience.reflect.FieldSelectTools;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.time.TimeCalc;
import java.lang.reflect.Field;
import java.util.Date;
import org.junit.Assert;
import org.junit.Test;

public class MirrorTest {
    @Test
    public void testClassData() {
        Mirror.ClassData cd = Mirror.getClassData(TestDiscoverMe.class);
        Assert.assertNotNull((Object)cd.getFieldByName("privData"));
        Field[] fds = cd.selectFields(FieldSelectTools.SELECT_ALL_PUBLIC_INSTANCE_FIELD);
        Assert.assertEquals((long)3L, (long)cd.selectFields(FieldSelectTools.SELECT_ALL_INSTANCE_FIELD).length);
        Assert.assertEquals((long)1L, (long)fds.length);
        Assert.assertEquals((Object)cd.getFieldByName("id"), (Object)fds[0]);
    }

    @Test
    public void testUsualToString() {
        TestPrintMe tdm = new TestPrintMe();
        tdm.id = 10;
        tdm.date = TimeCalc.dateUtc((int)2017, (int)3, (int)12, (int)10, (int)13, (int)14, (int)123);
        Assert.assertEquals((Object)"TestPrintMe: {secret: null, id: 10, date: 2017-03-12 10:13:14.123U}", (Object)Mirror.usualToString((Object)tdm));
    }

    @Test
    public void testUsualToString2() {
        TestPrintMe tdm = new TestPrintMe();
        tdm.secret = MapTools.inlineSmallMap((Object[])new Object[]{"a", 2, "b", 4});
        tdm.id = 10;
        tdm.date = TimeCalc.dateUtc((int)2017, (int)3, (int)12, (int)10, (int)13, (int)14, (int)123);
        Assert.assertEquals((Object)"TestPrintMe: {secret: {\"a\":\"2\", \"b\":\"4\"}, id: 10, date: 2017-03-12 10:13:14.123U}", (Object)Mirror.usualToString((Object)tdm));
    }

    public static class TestPrintMe {
        private Object secret;
        protected int id;
        public Date date;
    }

    public static class TestDiscoverMe {
        public static int props;
        private String privData;
        protected Date date;
        public int id;

        private TestDiscoverMe() {
        }
    }
}

