/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.reflection.property;

import eu.javaexperience.collection.CollectionTools;
import eu.javaexperience.interfaces.simple.publish.SimplePublish1;
import eu.javaexperience.reflect.property.PropertyAccessTools;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class TestAccessProperites {
    public static List<Service> createServices() {
        ArrayList<Service> ret = new ArrayList<Service>();
        ret.add(new WebServerConfig("http", 8080, new PathHandler("/", null), new PathHandler("/site", null), new PathHandler("/about", null), new PathHandler("/blog", null)));
        return ret;
    }

    @Test
    public void testAccessConfig() {
        List<Service> cfg = TestAccessProperites.createServices();
        Map acc = PropertyAccessTools.dotAccessWrap((Map)PropertyAccessTools.wrap(cfg));
        Assert.assertEquals((Object)1, acc.get("length"));
        Assert.assertEquals((Object)"http", acc.get("0.protocol"));
        Assert.assertEquals((Object)8080, acc.get("0.port"));
        Assert.assertEquals((Object)"/", acc.get("0.handlers.0.path"));
        Assert.assertEquals((Object)"/site", acc.get("0.handlers.1.path"));
        Assert.assertEquals((Object)"/about", acc.get("0.handlers.2.path"));
        Assert.assertEquals((Object)"/blog", acc.get("0.handlers.3.path"));
    }

    public static class WebServerConfig
    implements Service {
        public String protocol;
        public int port;
        public List<ServletHandler> handlers;

        public WebServerConfig(String protocol, int port, ServletHandler ... handlers) {
            this.protocol = protocol;
            this.port = port;
            this.handlers = CollectionTools.inlineArrayList((Object[])handlers);
        }
    }

    public static interface Service {
    }

    public static class PathHandler
    implements ServletHandler {
        public String path;
        public SimplePublish1<Object> handler;

        public PathHandler(String path, SimplePublish1<Object> handler) {
            this.path = path;
            this.handler = handler;
        }
    }

    public static interface ServletHandler {
    }
}

