/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.text;

import eu.javaexperience.math.MathTools;
import eu.javaexperience.text.Format;
import eu.javaexperience.time.TimeCalc;
import java.text.ParseException;
import java.util.Date;
import java.util.MissingFormatArgumentException;
import org.junit.Assert;
import org.junit.Test;

public class FormatTest {
    protected static void testStrToTime(String str, int year, int month, int day, int hour, int min, int sec, int ms) {
        Date d = Format.strToTime((String)str);
        Date cmp = TimeCalc.setToDate((Date)new Date(), (int)year, (int)(month - 1), (int)day, (int)hour, (int)min, (int)sec, (int)ms);
        boolean success = TimeCalc.dateEqualsByUnits((Date)d, (Date)cmp, (year > -1 ? 1 : 0) != 0, (month > -1 ? 1 : 0) != 0, (day > -1 ? 1 : 0) != 0, (hour > -1 ? 1 : 0) != 0, (min > -1 ? 1 : 0) != 0, (sec > -1 ? 1 : 0) != 0, (ms > -1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)success);
    }

    protected static void testStrToTimeUTC(String str, int year, int month, int day, int hour, int min, int sec, int ms) {
        Date d = Format.strToTime((String)str);
        Date cmp = TimeCalc.dateUtc((int)(year > 0 ? year : 0), (int)(month > 0 ? month : 0), (int)(day > 0 ? day : 0), (int)(hour > 0 ? hour : 0), (int)(min > 0 ? min : 0), (int)(sec > 0 ? sec : 0), (int)(ms > 0 ? ms : 0));
        boolean success = TimeCalc.dateEqualsByUnits((Date)d, (Date)cmp, (year > -1 ? 1 : 0) != 0, (month > -1 ? 1 : 0) != 0, (day > -1 ? 1 : 0) != 0, (hour > -1 ? 1 : 0) != 0, (min > -1 ? 1 : 0) != 0, (sec > -1 ? 1 : 0) != 0, (ms > -1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)success);
    }

    @Test
    public void testStrToTime() {
        FormatTest.testStrToTime("2015-02-15 12:20:59.352", 2015, 2, 15, 12, 20, 59, 352);
        FormatTest.testStrToTime("7/17/2016", 2016, 7, 17, -1, -1, -1, -1);
        FormatTest.testStrToTime("7/17/2016 10:02:03 AM", 2016, 7, 17, 10, 2, 3, -1);
        FormatTest.testStrToTime("8/1/2016 5:00:41 PM", 2016, 8, 1, 17, 0, 41, -1);
        FormatTest.testStrToTime("2016. 06. 27.", 2016, 6, 27, -1, -1, -1, -1);
        FormatTest.testStrToTime("2017. 03. 14. 7:21:58", 2017, 3, 14, 7, 21, 58, -1);
        FormatTest.testStrToTime("2018-06-12T19:30", 2018, 6, 12, 19, 30, -1, -1);
        FormatTest.testStrToTime("2018/06/12 19:30", 2018, 6, 12, 19, 30, -1, -1);
        FormatTest.testStrToTime("2018.06.02 03:22", 2018, 6, 2, 3, 22, -1, -1);
        FormatTest.testStrToTime("2018/10/02 12:06:01", 2018, 10, 2, 12, 6, 1, -1);
        FormatTest.testStrToTime("2018.11.08 12:05", 2018, 11, 8, 12, 5, -1, -1);
        FormatTest.testStrToTime("2019-05-17 02:22", 2019, 5, 17, 2, 22, -1, -1);
        Assert.assertTrue((boolean)MathTools.inRange((long)TimeCalc.addToDate((Date)new Date(), (int)0, (int)0, (int)1, (int)0, (int)0, (int)0, (int)0).getTime(), (long)Format.strToTime((String)"tomorrow").getTime(), (long)500L));
    }

    @Test
    public void testStrToTime2() {
        FormatTest.testStrToTime("", -1, -1, -1, -1, -1, -1, -1);
    }

    @Test
    public void testStrToTime3() {
        Assert.assertTrue((boolean)MathTools.inRange((long)Format.strToTime((String)"now").getTime(), (long)System.currentTimeMillis(), (long)500L));
    }

    @Test
    public void testCookieDate() {
        FormatTest.testStrToTimeUTC("Wed, 30-Oct-2019 12:11:25 GMT", 2019, 10, 30, 12, 11, 25, -1);
    }

    @Test
    public void testStrToTime4() {
        FormatTest.testStrToTime("Tuesday 30, April 2019", 2019, 4, 30, -1, -1, -1, -1);
    }

    @Test
    public void testSqlTimestampMilisec() {
        Assert.assertEquals((Object)"2018-11-03 10:20:12.345", (Object)Format.sqlTimestampMilisec((Date)TimeCalc.date((int)2018, (int)11, (int)3, (int)10, (int)20, (int)12, (int)345)));
    }

    @Test
    public void testSqlTimestamp() {
        Assert.assertEquals((Object)"2018-11-03 10:20:12", (Object)Format.sqlTimestamp((Date)TimeCalc.date((int)2018, (int)11, (int)3, (int)10, (int)20, (int)12, (int)345)));
    }

    @Test
    public void testParseSqlTimestamp() throws ParseException {
        Assert.assertEquals((Object)TimeCalc.date((int)2018, (int)11, (int)3, (int)10, (int)20, (int)12, (int)0), (Object)Format.parseSqlTimestamp((String)"2018-11-03 10:20:12"));
        Assert.assertEquals(null, (Object)Format.tryParseSqlTimestamp((String)"2018-11-03-10:20:12"));
        Assert.assertEquals((Object)TimeCalc.date((int)2018, (int)11, (int)3, (int)10, (int)20, (int)12, (int)0), (Object)Format.tryParseSqlTimestamp((String)"2018-11-03 10:20:12"));
    }

    @Test
    public void testFormatSqlDate() {
        Assert.assertEquals((Object)"2018-11-03", (Object)Format.formatSqlDate((Date)TimeCalc.date((int)2018, (int)11, (int)3, (int)10, (int)20, (int)12, (int)345)));
    }

    @Test
    public void testUTC_FILE_SQL_TIMESTAMP() throws ParseException {
        Assert.assertEquals((Object)"yyyy-MM-dd_HH-mm-ss_SSS'U'", (Object)Format.UTC_FILE_SQL_TIMESTAMP.getFormat());
        Assert.assertEquals((long)1541240412345L, (long)Format.UTC_FILE_SQL_TIMESTAMP.parse("2018-11-03_10-20-12_345U").getTime());
        Assert.assertEquals((Object)"2018-11-03_10-20-12_345U", (Object)Format.UTC_FILE_SQL_TIMESTAMP.format(new Date(1541240412345L)));
    }

    @Test
    public void testBase64EncodeDecode() {
        String b64 = Format.base64Encode((byte[])"this is a beginning of a beautiful friendship".getBytes());
        Assert.assertEquals((Object)"dGhpcyBpcyBhIGJlZ2lubmluZyBvZiBhIGJlYXV0aWZ1bCBmcmllbmRzaGlw", (Object)b64);
        Assert.assertEquals((Object)"this is a beginning of a beautiful friendship", (Object)new String(Format.base64Decode((String)b64)));
    }

    @Test
    public void testBase64EncodeDecode2() {
        int i;
        String b64 = null;
        byte[] data = new byte[256];
        for (i = 0; i < 256; ++i) {
            data[i] = (byte)(i - 128);
        }
        b64 = Format.base64Encode((byte[])data);
        Assert.assertEquals((Object)"gIGCg4SFhoeIiYqLjI2Oj5CRkpOUlZaXmJmam5ydnp+goaKjpKWmp6ipqqusra6vsLGys7S1tre4ubq7vL2+v8DBwsPExcbHyMnKy8zNzs/Q0dLT1NXW19jZ2tvc3d7f4OHi4+Tl5ufo6err7O3u7/Dx8vP09fb3+Pn6+/z9/v8AAQIDBAUGBwgJCgsMDQ4PEBESExQVFhcYGRobHB0eHyAhIiMkJSYnKCkqKywtLi8wMTIzNDU2Nzg5Ojs8PT4/QEFCQ0RFRkdISUpLTE1OT1BRUlNUVVZXWFlaW1xdXl9gYWJjZGVmZ2hpamtsbW5vcHFyc3R1dnd4eXp7fH1+fw==", (Object)b64);
        byte[] dec = Format.base64Decode((String)b64);
        for (i = 0; i < 256; ++i) {
            Assert.assertEquals((long)((byte)(i - 128)), (long)dec[i]);
        }
    }

    @Test
    public void testBase64Decode_2() {
        Assert.assertEquals((Object)"__", (Object)new String(Format.base64Decode((String)"X18=")));
        Assert.assertEquals((Object)"__", (Object)new String(Format.base64Decode((String)",X18=")));
        Assert.assertEquals((Object)"__", (Object)new String(Format.base64Decode((String)"X18,=")));
        Assert.assertEquals((Object)"__", (Object)new String(Format.base64Decode((String)"X18=,")));
        Assert.assertEquals((Object)"__", (Object)new String(Format.base64Decode((String)",X18=,")));
    }

    @Test
    public void testShortenString() {
        Assert.assertEquals((Object)"this...", (Object)Format.shortenStringIfLongerThan((String)"this is a beginning of a", (int)4));
        Assert.assertEquals((Object)"this ...", (Object)Format.shortenStringIfLongerThan((String)"this is a beginning of a", (int)5));
        Assert.assertEquals((Object)"this is a beginning of ...", (Object)Format.shortenStringIfLongerThan((String)"this is a beginning of a", (int)23));
        Assert.assertEquals((Object)"this is a beginning of a", (Object)Format.shortenStringIfLongerThan((String)"this is a beginning of a", (int)24));
    }

    @Test
    public void testFormat1() {
        Assert.assertEquals((Object)"plain text", (Object)Format.format((String)"plain text", (Object[])new Object[0]));
        Assert.assertEquals((Object)"I'm nullproof", (Object)Format.format((String)"I'm %sproof", null));
        Assert.assertEquals((Object)"99 bottles of beer on the wall, 99 bottles of beer.", (Object)Format.format((String)"%d bottles of %s on the wall, %d bottles of %s.", (Object[])new Object[]{99, "beer", 99, "beer"}));
        Assert.assertEquals((Object)"98 bottles of wine on the wall, 98 bottles of wine.", (Object)Format.format((String)"%d bottles of %s on the wall, %d bottles of %s.", (Object[])new Object[]{98, "wine", 98, "wine"}));
    }

    @Test(expected=MissingFormatArgumentException.class)
    public void testFormat2() {
        Format.format((String)"I'm %sproof", (Object[])new Object[0]);
    }

    @Test
    public void testCutFloatDecimals() {
        Assert.assertEquals((Object)"100", (Object)Format.cutFloatDecimals((String)"100.002", (int)1));
        Assert.assertEquals((Object)"100", (Object)Format.cutFloatDecimals((String)"100.002", (int)2));
        Assert.assertEquals((Object)"100.002", (Object)Format.cutFloatDecimals((String)"100.002", (int)3));
        Assert.assertEquals((Object)"0123", (Object)Format.cutFloatDecimals((String)"0123.2345", (int)0));
        Assert.assertEquals((Object)"0123.2", (Object)Format.cutFloatDecimals((String)"0123.2345", (int)1));
        Assert.assertEquals((Object)"0123.23", (Object)Format.cutFloatDecimals((String)"0123.2345", (int)2));
        Assert.assertEquals((Object)"0123.234", (Object)Format.cutFloatDecimals((String)"0123.2345", (int)3));
        Assert.assertEquals((Object)"0123.2345", (Object)Format.cutFloatDecimals((String)"0123.2345", (int)4));
        Assert.assertEquals((Object)"0123.2345", (Object)Format.cutFloatDecimals((String)"0123.2345", (int)5));
        Assert.assertEquals((Object)"0123.2345", (Object)Format.cutFloatDecimals((String)"0123.2345", (int)6));
        Assert.assertEquals((Object)"100", (Object)Format.cutFloatDecimals((String)"100", (int)1));
        Assert.assertEquals((Object)"100", (Object)Format.cutFloatDecimals((String)"100", (int)2));
        Assert.assertEquals((Object)"100", (Object)Format.cutFloatDecimals((String)"100", (int)3));
        Assert.assertEquals((Object)"0", (Object)Format.cutFloatDecimals((String)"0.0", (int)1));
        Assert.assertEquals((Object)"0", (Object)Format.cutFloatDecimals((String)"0.0", (int)2));
        Assert.assertEquals((Object)"0", (Object)Format.cutFloatDecimals((String)"0.0", (int)3));
        Assert.assertEquals((Object)"100", (Object)Format.cutFloatDecimals((String)"100.", (int)1));
        Assert.assertEquals((Object)"100", (Object)Format.cutFloatDecimals((String)"100.", (int)2));
        Assert.assertEquals((Object)"100", (Object)Format.cutFloatDecimals((String)"100.", (int)3));
    }

    @Test
    public void testFormatDouble() {
        Assert.assertEquals((Object)"100.94", (Object)Format.formatDouble((double)100.944432));
        Assert.assertEquals((Object)"100.95", (Object)Format.formatDouble((double)100.94765));
        Assert.assertEquals((Object)"100", (Object)Format.formatDouble((double)100.0));
    }

    @Test
    public void testFromToHex() {
        int i;
        String hex = null;
        byte[] data = new byte[256];
        for (i = 0; i < 256; ++i) {
            data[i] = (byte)(i - 128);
        }
        hex = Format.toHex((byte[])data);
        Assert.assertEquals((Object)"808182838485868788898a8b8c8d8e8f909192939495969798999a9b9c9d9e9fa0a1a2a3a4a5a6a7a8a9aaabacadaeafb0b1b2b3b4b5b6b7b8b9babbbcbdbebfc0c1c2c3c4c5c6c7c8c9cacbcccdcecfd0d1d2d3d4d5d6d7d8d9dadbdcdddedfe0e1e2e3e4e5e6e7e8e9eaebecedeeeff0f1f2f3f4f5f6f7f8f9fafbfcfdfeff000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f404142434445464748494a4b4c4d4e4f505152535455565758595a5b5c5d5e5f606162636465666768696a6b6c6d6e6f707172737475767778797a7b7c7d7e7f", (Object)hex);
        byte[] dec = Format.fromHex((String)hex);
        for (i = 0; i < 256; ++i) {
            Assert.assertEquals((long)((byte)(i - 128)), (long)dec[i]);
        }
    }

    @Test
    public void testFromHex() {
        Assert.assertEquals((Object)"Danko David", (Object)new String(Format.fromHex((String)"44616e6b6f204461766964")));
    }

    @Test
    public void testFromHexUpperCase() {
        Assert.assertEquals((Object)"Danko David", (Object)new String(Format.fromHex((String)"44616E6B6F204461766964")));
    }

    @Test
    public void testFromHexMixedCase() {
        Assert.assertEquals((Object)"Danko David", (Object)new String(Format.fromHex((String)"44616E6b6F204461766964")));
    }
}

