/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.text;

import eu.javaexperience.collection.CollectionTools;
import eu.javaexperience.collection.map.MapTools;
import eu.javaexperience.text.StringTools;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Pattern;
import org.junit.Assert;
import org.junit.Test;

public class StringToolsTest {
    @Test
    public void testRandomString() {
        Assert.assertEquals((long)0L, (long)StringTools.randomString((int)0).length());
        Assert.assertEquals((long)1L, (long)StringTools.randomString((int)1).length());
        Assert.assertEquals((long)20L, (long)StringTools.randomString((int)20).length());
        Assert.assertEquals((long)1024L, (long)StringTools.randomString((int)1024).length());
    }

    @Test
    public void testRandomStringCustom() {
        Assert.assertEquals((Object)"aaaa", (Object)StringTools.randomStringFrom((String)"a", (int)4));
        Assert.assertEquals((Object)"ZZZ", (Object)StringTools.randomStringFrom((String)"Z", (int)3));
        String rnd = StringTools.randomStringFrom((String)"ab", (int)1024);
        Assert.assertTrue((boolean)rnd.contains("a"));
        Assert.assertTrue((boolean)rnd.contains("b"));
    }

    @Test
    public void testPassOnlyNumbers() {
        Assert.assertEquals((Object)"314", (Object)StringTools.passOnlyNumbers((String)"pi: 3.14"));
        Assert.assertEquals((Object)"314", (Object)StringTools.passOnlyNumbers((String)"pi: 3,14"));
    }

    @Test
    public void testClampLength() {
        Assert.assertEquals(null, (Object)StringTools.clampLength(null, (int)0));
        Assert.assertEquals((Object)"", (Object)StringTools.clampLength((String)"sko", (int)0));
        Assert.assertEquals((Object)"s", (Object)StringTools.clampLength((String)"sko", (int)1));
        Assert.assertEquals((Object)"sk", (Object)StringTools.clampLength((String)"sko", (int)2));
        Assert.assertEquals((Object)"sko", (Object)StringTools.clampLength((String)"sko", (int)3));
        Assert.assertEquals((Object)"sko", (Object)StringTools.clampLength((String)"sko", (int)5));
    }

    @Test
    public void testFirstBetween() {
        String subject = "http://subpage.mysite.eu/category-4892c";
        Assert.assertEquals((Object)"subpage", (Object)StringTools.getFirstBetween((String)"http://subpage.mysite.eu/category-4892c", (String)"http://", (String)".mysite.eu"));
        Assert.assertEquals((Object)"4892", (Object)StringTools.getFirstBetween((String)"http://subpage.mysite.eu/category-4892c", (String)"category-", (String)"c"));
        Assert.assertEquals((Object)"http://subpage.mysite.eu/category-4892c", (Object)StringTools.getFirstBetween((String)"http://subpage.mysite.eu/category-4892c", (String)"\\", (String)"\\"));
        Assert.assertEquals((Object)"subpage.mysite.eu", (Object)StringTools.getFirstBetween((String)"http://subpage.mysite.eu/category-4892c", (String)"//", (String)"/"));
        Assert.assertEquals((Object)"home", (Object)StringTools.getFirstBetween((String)"/home/user/git/linux/.git", (String)"/", (String)"/"));
        Assert.assertEquals((Object)"", (Object)StringTools.getFirstBetween((String)"http://subpage.mysite.eu/category-4892c", (String)"/", (String)"/"));
        Assert.assertEquals((Object)"default_value", (Object)StringTools.getFirstBetween((String)"http://subpage.mysite.eu/category-4892c", (String)"\\", (String)"\\", (String)"default_value"));
        Assert.assertEquals((Object)"home", (Object)StringTools.getFirstBetween((String)"/home/user/git/linux/.git", (String)"/", (String)"/"));
        Assert.assertEquals(null, (Object)StringTools.getFirstBetween((String)"/home", (String)"/", (String)" /", null));
    }

    @Test
    public void testLastBetween() {
        Assert.assertEquals((Object)"subpage", (Object)StringTools.getLastBetween((String)"http://subpage.mysite.eu/category-4892c", (String)"http://", (String)".mysite.eu"));
        Assert.assertEquals((Object)"funnyPic", (Object)StringTools.getLastBetween((String)"/home/user/Images/funnyPic.jpg", (String)"/", (String)"."));
        Assert.assertEquals((Object)"", (Object)StringTools.getLastBetween((String)"/home/user/git/linux/.git", (String)"/", (String)".git"));
        Assert.assertEquals((Object)"linux", (Object)StringTools.getLastBetween((String)"/home/user/git/linux/.git", (String)"/", (String)"/"));
        Assert.assertEquals((Object)"/home/user/git/linux/.git", (Object)StringTools.getLastBetween((String)"/home/user/git/linux/.git", (String)"\\", (String)" \\"));
        Assert.assertEquals(null, (Object)StringTools.getLastBetween((String)"/home", (String)"/", (String)"/", null));
        Assert.assertEquals(null, (Object)StringTools.getLastBetween((String)"home", (String)"/", (String)"/", null));
        Assert.assertEquals(null, (Object)StringTools.getLastBetween((String)"home/", (String)"/", (String)"/", null));
        Assert.assertEquals(null, (Object)StringTools.getLastBetween((String)"/home", (String)"/", (String)".", null));
    }

    @Test
    public void testSubstringAfterLastString() {
        Assert.assertEquals((Object)"4892c", (Object)StringTools.getSubstringAfterLastString((String)"http://subpage.mysite.eu/category-4892c", (String)"/category-"));
        Assert.assertEquals((Object)"file.jpg", (Object)StringTools.getSubstringAfterLastString((String)"/home/user/Document/file.jpg", (String)"/"));
        Assert.assertEquals((Object)"file.jpg", (Object)StringTools.getSubstringAfterLastString((String)"file.jpg", (String)"/"));
        Assert.assertEquals((Object)"jpg", (Object)StringTools.getSubstringAfterLastString((String)"/home/user/Document/file.jpg", (String)"."));
        Assert.assertEquals((Object)"/home/user/Document/file", (Object)StringTools.getSubstringAfterLastString((String)"/home/user/Document/file", (String)"."));
        Assert.assertEquals((Object)"file", (Object)StringTools.getSubstringAfterLastString((String)"/home/user/Document/file", (String)"/"));
    }

    @Test
    public void testSubstringBeforeLastString() {
        Assert.assertEquals((Object)"myfile", (Object)StringTools.getSubstringBeforeLastString((String)"myfile.ext", (String)"."));
        Assert.assertEquals((Object)"myfile", (Object)StringTools.getSubstringBeforeLastString((String)"myfile", (String)"."));
        Assert.assertEquals((Object)"_main", (Object)StringTools.getSubstringBeforeLastString((String)"_main_", (String)"_"));
        Assert.assertEquals((Object)"archive.tar", (Object)StringTools.getSubstringBeforeLastString((String)"archive.tar.gz", (String)"."));
        Assert.assertEquals((Object)"/home/user/Document", (Object)StringTools.getSubstringBeforeLastString((String)"/home/user/Document/file", (String)"/"));
        Assert.assertEquals(null, (Object)StringTools.getSubstringBeforeLastString((String)"myfile", (String)".", null));
    }

    @Test
    public void testSubstringAfterFirstString() {
        Assert.assertEquals((Object)"jpg", (Object)StringTools.getSubstringAfterFirstString((String)"image.jpg", (String)"."));
        Assert.assertEquals((Object)"image", (Object)StringTools.getSubstringAfterFirstString((String)"image", (String)"."));
        Assert.assertEquals((Object)"main_", (Object)StringTools.getSubstringAfterFirstString((String)"_main_", (String)"_"));
        Assert.assertEquals((Object)"tar.gz", (Object)StringTools.getSubstringAfterFirstString((String)"archive.tar.gz", (String)"."));
        Assert.assertEquals((Object)"home/user/Document/file", (Object)StringTools.getSubstringAfterFirstString((String)"/home/user/Document/file", (String)"/"));
        Assert.assertEquals((Object)"user/Document/file", (Object)StringTools.getSubstringAfterFirstString((String)"home/user/Document/file", (String)"/"));
        Assert.assertEquals(null, (Object)StringTools.getSubstringAfterFirstString((String)"image", (String)".", null));
    }

    @Test
    public void testSubstringBeforeFirstString() {
        Assert.assertEquals((Object)"image", (Object)StringTools.getSubstringBeforeFirstString((String)"image.jpg", (String)"."));
        Assert.assertEquals((Object)"image", (Object)StringTools.getSubstringBeforeFirstString((String)"image", (String)"."));
        Assert.assertEquals((Object)"", (Object)StringTools.getSubstringBeforeFirstString((String)"_main_", (String)"_"));
        Assert.assertEquals((Object)"archive", (Object)StringTools.getSubstringBeforeFirstString((String)"archive.tar.gz", (String)"."));
        Assert.assertEquals((Object)"", (Object)StringTools.getSubstringBeforeFirstString((String)"/home/user/Document/file", (String)"/"));
        Assert.assertEquals((Object)"home", (Object)StringTools.getSubstringBeforeFirstString((String)"home/user/Document/file", (String)"/"));
        Assert.assertEquals(null, (Object)StringTools.getSubstringBeforeFirstString((String)"image", (String)".", null));
    }

    @Test
    public void testUntilTerminator() {
        Assert.assertEquals((Object)"archive", (Object)StringTools.untilTerminator((String)"archive.tar.gz", (char)'.'));
        Assert.assertEquals((Object)"user", (Object)StringTools.untilTerminator((String)"user/archive.tar.gz", (char)'/'));
        Assert.assertEquals((Object)"/home/user/archive.tar.gz", (Object)StringTools.untilTerminator((String)"/home/user/archive.tar.gz", (char)'_'));
        Assert.assertEquals(null, (Object)StringTools.untilTerminator(null, (char)'_'));
    }

    @Test
    public void testRepeatChar() {
        Assert.assertEquals((Object)"", (Object)StringTools.repeatChar((char)'a', (int)-25));
        Assert.assertEquals((Object)"", (Object)StringTools.repeatChar((char)'a', (int)0));
        Assert.assertEquals((Object)"aaaaa", (Object)StringTools.repeatChar((char)'a', (int)5));
        Assert.assertEquals((Object)"\t\t\t", (Object)StringTools.repeatChar((char)'\t', (int)3));
        Assert.assertEquals((Object)"\n\n", (Object)StringTools.repeatChar((char)'\n', (int)2));
    }

    @Test
    public void testRepeatString() {
        Assert.assertEquals((Object)"", (Object)StringTools.repeatString((String)"a", (int)-25));
        Assert.assertEquals((Object)"", (Object)StringTools.repeatString((String)"a", (int)0));
        Assert.assertEquals((Object)"aaaaa", (Object)StringTools.repeatString((String)"a", (int)5));
        Assert.assertEquals((Object)"\t\t\t", (Object)StringTools.repeatString((String)"\t", (int)3));
        Assert.assertEquals((Object)"\n\n", (Object)StringTools.repeatString((String)"\n", (int)2));
        Assert.assertEquals((Object)"asd asd asd ", (Object)StringTools.repeatString((String)"asd ", (int)3));
        Assert.assertEquals((Object)"asd \n\tasd \n\tasd \n\t", (Object)StringTools.repeatString((String)"asd \n\t", (int)3));
    }

    @Test
    public void testWhitoutNullAndEmptyString() {
        Assert.assertArrayEquals((Object[])new String[]{"a", "b"}, (Object[])StringTools.whitoutNullAndEmptyString((String[])new String[]{"a", "b"}));
        Assert.assertArrayEquals((Object[])new String[]{"a", "b"}, (Object[])StringTools.whitoutNullAndEmptyString((String[])new String[]{"a", null, "", "b"}));
        Assert.assertArrayEquals((Object[])new String[]{"a", "b"}, (Object[])StringTools.whitoutNullAndEmptyString((String[])new String[]{null, "a", null, "", "b"}));
        Assert.assertArrayEquals((Object[])new String[0], (Object[])StringTools.whitoutNullAndEmptyString((String[])new String[]{"", null, "", null, null}));
    }

    @Test
    public void testReplaceAllStrings() {
        Assert.assertEquals((Object)"bbb", (Object)StringTools.replaceAllStrings((String)"aaa", (String)"a", (String)"b"));
        Assert.assertEquals((Object)"bbb", (Object)StringTools.replaceAllStrings((String)"bbb", (String)"a", (String)"b"));
        Assert.assertEquals((Object)"bbb", (Object)StringTools.replaceAllStrings((String)"   ", (String)" ", (String)"b"));
        Assert.assertEquals((Object)"cbc", (Object)StringTools.replaceAllStrings((String)"cac", (String)"a", (String)"b"));
        Assert.assertEquals((Object)"", (Object)StringTools.replaceAllStrings((String)"", (String)"a", (String)"b"));
        Assert.assertEquals((Object)"LazyFoxbcd", (Object)StringTools.replaceAllStrings((String)"abcd", (String)"a", (String)"LazyFox"));
        Assert.assertEquals((Object)"LazyFoxbcLazyFox", (Object)StringTools.replaceAllStrings((String)"abca", (String)"a", (String)"LazyFox"));
        Assert.assertEquals((Object)"For Richard, at $DAY ", (Object)StringTools.replaceAllStrings((String)"For $NAME, at $DAY ", (String)"$NAME", (String)"Richard"));
    }

    @Test
    public void testReplaceAllStringsCaseInsensitive() {
        Assert.assertEquals((Object)"bbb", (Object)StringTools.replaceAllStringsCaseInsensitive((String)"aAa", (String)"a", (String)"b"));
        Assert.assertEquals((Object)"bbb", (Object)StringTools.replaceAllStringsCaseInsensitive((String)"aAa", (String)"A", (String)"b"));
        Assert.assertEquals((Object)"bbb", (Object)StringTools.replaceAllStringsCaseInsensitive((String)"aaa", (String)"A", (String)"b"));
        Assert.assertEquals((Object)"bbb", (Object)StringTools.replaceAllStringsCaseInsensitive((String)"bbb", (String)"a", (String)"b"));
        Assert.assertEquals((Object)"bbb", (Object)StringTools.replaceAllStringsCaseInsensitive((String)"   ", (String)" ", (String)"b"));
        Assert.assertEquals((Object)"cbc", (Object)StringTools.replaceAllStringsCaseInsensitive((String)"cAc", (String)"a", (String)"b"));
        Assert.assertEquals((Object)"cbc", (Object)StringTools.replaceAllStringsCaseInsensitive((String)"cac", (String)"A", (String)"b"));
        Assert.assertEquals((Object)"", (Object)StringTools.replaceAllStringsCaseInsensitive((String)"", (String)"a", (String)"b"));
        Assert.assertEquals((Object)"LazyFoxbcd", (Object)StringTools.replaceAllStringsCaseInsensitive((String)"abcd", (String)"A", (String)"LazyFox"));
        Assert.assertEquals((Object)"LazyFoxbcLazyFox", (Object)StringTools.replaceAllStringsCaseInsensitive((String)"abcA", (String)"a", (String)"LazyFox"));
        Assert.assertEquals((Object)"For Richard, at $DAY ", (Object)StringTools.replaceAllStringsCaseInsensitive((String)"For $name, at $DAY ", (String)"$NAME", (String)"Richard"));
    }

    @Test
    public void testToString() {
        Assert.assertEquals((Object)"null", (Object)StringTools.toString(null));
        Assert.assertEquals((Object)"null", (Object)StringTools.toString((Object)"null"));
        Assert.assertEquals((Object)"hello", (Object)StringTools.toString((Object)"hello"));
        Assert.assertEquals((Object)"12", (Object)StringTools.toString((Object)12));
    }

    @Test
    public void testDeAccent() {
        Assert.assertEquals((Object)"usual text", (Object)StringTools.deAccent((String)"usual text"));
        Assert.assertEquals((Object)"Arvizturo tukorfurogep", (Object)StringTools.deAccent((String)"\u00c1rv\u00edzt\u0171r\u0151 t\u00fck\u00f6rf\u00far\u00f3g\u00e9p"));
        Assert.assertEquals((Object)"Otagu utomubenito", (Object)StringTools.deAccent((String)"\u00d6t\u00e1g\u00fa \u00fct\u0151m\u0171b\u00e9n\u00edt\u0151"));
        Assert.assertEquals((Object)"Egy hutlen vejet fuloncsipo, duhos mexikoi ur Wesselenyinel mazol Quitoban.", (Object)StringTools.deAccent((String)"Egy h\u0171tlen vej\u00e9t f\u00fcl\u00f6ncs\u00edp\u0151, d\u00fch\u00f6s mexik\u00f3i \u00far Wessel\u00e9nyin\u00e9l m\u00e1zol Quit\u00f3ban."));
    }

    @Test
    public void testPlainSplit() {
        Assert.assertArrayEquals((Object[])new String[]{"as_ds_fd"}, (Object[])StringTools.plainSplit((String)"as_ds_fd", (String)" "));
        Assert.assertArrayEquals((Object[])new String[]{"as", "ds", "fd"}, (Object[])StringTools.plainSplit((String)"as_ds_fd", (String)"_"));
        Assert.assertArrayEquals((Object[])new String[]{"^", "$"}, (Object[])StringTools.plainSplit((String)"^.*$", (String)".*"));
        Assert.assertArrayEquals((Object[])new String[]{"a", "b", "c"}, (Object[])StringTools.plainSplit((String)"a*b*c", (String)"*"));
    }

    @Test
    public void testCutToBytes() {
        Assert.assertEquals((Object)"", (Object)StringTools.cutToBytes((String)"", (int)100));
        Assert.assertEquals((Object)"aaa", (Object)StringTools.cutToBytes((String)"aaaaa", (int)3));
        Assert.assertEquals((Object)"\u00e1", (Object)StringTools.cutToBytes((String)"\u00e1\u00e1\u00e1", (int)3));
        Assert.assertEquals((Object)"\u00e1\u00e1", (Object)StringTools.cutToBytes((String)"\u00e1\u00e1\u00e1", (int)4));
        Assert.assertEquals((Object)"\u00c1rv\u00edzt\u0171", (Object)StringTools.cutToBytes((String)"\u00c1rv\u00edzt\u0171r\u0151 t\u00fck\u00f6rf\u00far\u00f3g\u00e9p", (int)10));
        Assert.assertEquals((Object)"\u00c1rv\u00edzt\u0171r", (Object)StringTools.cutToBytes((String)"\u00c1rv\u00edzt\u0171r\u0151 t\u00fck\u00f6rf\u00far\u00f3g\u00e9p", (int)11));
        Assert.assertEquals((Object)"\u00c1rv\u00edzt\u0171r", (Object)StringTools.cutToBytes((String)"\u00c1rv\u00edzt\u0171r\u0151 t\u00fck\u00f6rf\u00far\u00f3g\u00e9p", (int)12));
    }

    @Test
    public void testEscapeToJavaString() {
        Assert.assertEquals((Object)"usual", (Object)StringTools.escapeToJavaString((String)"usual"));
        Assert.assertEquals((Object)"usual\\\\n", (Object)StringTools.escapeToJavaString((String)"usual\n"));
        Assert.assertEquals((Object)"\\\\tpublic void test()\\\\n", (Object)StringTools.escapeToJavaString((String)"\tpublic void test()\n"));
        Assert.assertEquals((Object)"10\\\\2", (Object)StringTools.escapeToJavaString((String)"10\\2"));
    }

    @Test
    public void testOrEmptyString() {
        Assert.assertEquals((Object)"", (Object)StringTools.orEmptyString(null));
        Assert.assertEquals((Object)"", (Object)StringTools.orEmptyString((String)""));
        Assert.assertEquals((Object)"asd", (Object)StringTools.orEmptyString((String)"asd"));
    }

    @Test
    public void testIsNullOrEmpty() {
        Assert.assertTrue((boolean)StringTools.isNullOrEmpty(null));
        Assert.assertTrue((boolean)StringTools.isNullOrEmpty((String)""));
        Assert.assertFalse((boolean)StringTools.isNullOrEmpty((String)" "));
        Assert.assertFalse((boolean)StringTools.isNullOrEmpty((String)"\n"));
        Assert.assertFalse((boolean)StringTools.isNullOrEmpty((String)"\b"));
        Assert.assertFalse((boolean)StringTools.isNullOrEmpty((String)"asdsf"));
    }

    @Test
    public void testIsNullOrTrimEmpty() {
        Assert.assertTrue((boolean)StringTools.isNullOrTrimEmpty(null));
        Assert.assertTrue((boolean)StringTools.isNullOrTrimEmpty((String)""));
        Assert.assertTrue((boolean)StringTools.isNullOrTrimEmpty((String)" "));
        Assert.assertTrue((boolean)StringTools.isNullOrTrimEmpty((String)"\n"));
        Assert.assertTrue((boolean)StringTools.isNullOrTrimEmpty((String)"\b"));
        Assert.assertFalse((boolean)StringTools.isNullOrTrimEmpty((String)"asdsf"));
        Assert.assertFalse((boolean)StringTools.isNullOrTrimEmpty((String)" _ "));
    }

    @Test
    public void testEnsureStartsWith() {
        Assert.assertEquals((Object)".git", (Object)StringTools.ensureStartsWith((String)"git", (String)"."));
        Assert.assertEquals((Object)"git", (Object)StringTools.ensureStartsWith((String)"git", (String)""));
        Assert.assertEquals((Object)"/home/user/myfile", (Object)StringTools.ensureStartsWith((String)"myfile", (String)"/home/user/"));
        Assert.assertEquals((Object)"/home/user/myfile", (Object)StringTools.ensureStartsWith((String)"/home/user/myfile", (String)"/home/user/"));
    }

    @Test
    public void testMultiReplaceAllString() {
        Assert.assertEquals((Object)"Dear Robert, yesterday you missed ...", (Object)StringTools.multiReplaceAllString((String)"Dear $NAME, $REL_DAY you $ACTION ...", (Map)MapTools.inlineSmallMap((Object[])new Object[]{"$NAME", "Robert", "$REL_DAY", "yesterday", "$ACTION", "missed"})));
        Assert.assertEquals((Object)"Dear Robert, yesterday you missed ...", (Object)StringTools.multiReplaceAllString((String)"$MSG", (Map)MapTools.inlineSmallMap((Object[])new Object[]{"$MSG", "Dear $NAME, $REL_DAY you $ACTION ...", "$NAME", "Robert", "$REL_DAY", "yesterday", "$ACTION", "missed"})));
    }

    @Test
    public void testEnsureEndsWith() {
        Assert.assertEquals((Object)"image.jpg", (Object)StringTools.ensureEndsWith((String)"image", (String)".jpg"));
        Assert.assertEquals((Object)"image.jpg", (Object)StringTools.ensureEndsWith((String)"image.jpg", (String)".jpg"));
    }

    @Test
    public void testIsIn() {
        Assert.assertTrue((boolean)StringTools.isIn((String)"a", (String[])new String[]{"a", "b", "c"}));
        Assert.assertTrue((boolean)StringTools.isIn((String)"a", (String[])new String[]{null, "a", "b"}));
        Assert.assertFalse((boolean)StringTools.isIn((String)"a", (String[])new String[0]));
        Assert.assertFalse((boolean)StringTools.isIn((String)"a", (String[])new String[]{"b", "c"}));
        Assert.assertFalse((boolean)StringTools.isIn((String)"a", (String[])new String[]{null, "b", "c"}));
        Assert.assertTrue((boolean)StringTools.isIn((String)"", (String[])new String[]{""}));
        Assert.assertFalse((boolean)StringTools.isIn((String)"", (String[])new String[0]));
    }

    @Test
    public void testConcat() {
        Assert.assertEquals((Object)"abc", (Object)StringTools.concat((String[])new String[]{"a", "b", "c"}));
        Assert.assertEquals((Object)"anullc", (Object)StringTools.concat((String[])new String[]{"a", null, "c"}));
    }

    @Test
    public void testConcatNotNull() {
        Assert.assertEquals((Object)"abc", (Object)StringTools.concatNotNull((String[])new String[]{"a", "b", "c"}));
        Assert.assertEquals((Object)"ac", (Object)StringTools.concatNotNull((String[])new String[]{"a", null, "c"}));
    }

    @Test
    public void testToStringOrNull() {
        Assert.assertEquals(null, (Object)StringTools.toStringOrNull(null));
        Assert.assertEquals((Object)"12", (Object)StringTools.toStringOrNull((Object)12));
        Assert.assertEquals((Object)"asd", (Object)StringTools.toStringOrNull((Object)"asd"));
    }

    @Test
    public void testoccurrenceIn() {
        Assert.assertEquals((long)0L, (long)StringTools.occurrenceIn((String)"asdff", (String)"g"));
        Assert.assertEquals((long)1L, (long)StringTools.occurrenceIn((String)"asdff", (String)"a"));
        Assert.assertEquals((long)2L, (long)StringTools.occurrenceIn((String)"asdff", (String)"f"));
        Assert.assertEquals((long)7L, (long)StringTools.occurrenceIn((String)"this is a begining of a beatiful friendship", (String)" "));
        Assert.assertEquals((long)2L, (long)StringTools.occurrenceIn((String)"this is a begining of a beatiful friendship", (String)" a "));
        Assert.assertEquals((long)3L, (long)StringTools.occurrenceIn((String)"this is a begining of a beatiful friendship", (String)"a"));
        Assert.assertEquals((long)-1L, (long)StringTools.occurrenceIn((String)"this is a begining of a beatiful friendship", (String)""));
    }

    @Test
    public void testJoin() {
        Assert.assertEquals((Object)"a b c d", (Object)StringTools.join((String)" ", (String[])new String[]{"a", "b", "c", "d"}));
        Assert.assertEquals((Object)"a_b_c_d", (Object)StringTools.join((String)"_", (String[])new String[]{"a", "b", "c", "d"}));
        Assert.assertEquals((Object)"a b c d", (Object)StringTools.join((String)" ", (Collection)CollectionTools.inlineArrayList((Object[])new String[]{"a", "b", "c", "d"})));
        Assert.assertEquals((Object)"a_b_c_d", (Object)StringTools.join((String)"_", (Collection)CollectionTools.inlineArrayList((Object[])new String[]{"a", "b", "c", "d"})));
    }

    @Test
    public void testReplaceAll() {
        Assert.assertArrayEquals((Object[])new String[]{"b", "bb", "bbb", "bcb"}, (Object[])StringTools.replaceAll((String[])new String[]{"a", "aa", "aaa", "aca"}, (String)"a", (String)"b"));
    }

    @Test
    public void testSplitModifyJoin() {
        Assert.assertEquals((Object)"300;5321;-300000", (Object)StringTools.splitModifyJoin((String)"3e2;5321;-3e5", (Pattern)Pattern.compile(";"), e -> String.valueOf(Double.valueOf(Double.parseDouble(e)).intValue()), (String)";"));
    }

    @Test
    public void testTryTrim() {
        Assert.assertEquals(null, (Object)StringTools.tryTrim(null));
        Assert.assertEquals((Object)"", (Object)StringTools.tryTrim((String)""));
        Assert.assertEquals((Object)"", (Object)StringTools.tryTrim((String)"\n"));
        Assert.assertEquals((Object)"", (Object)StringTools.tryTrim((String)"\b"));
        Assert.assertEquals((Object)"", (Object)StringTools.tryTrim((String)" "));
        Assert.assertEquals((Object)"asdf", (Object)StringTools.tryTrim((String)" \n asdf "));
    }

    @Test
    public void testPassOnlyNumbersAndSmallAscii() {
        Assert.assertEquals((Object)"012345avfreda", (Object)StringTools.passOnlyNumbersAndSmallAscii((String)"012345avfreda"));
        Assert.assertEquals((Object)"012345avfreda", (Object)StringTools.passOnlyNumbersAndSmallAscii((String)"012345-av fr!eda"));
        Assert.assertEquals((Object)"", (Object)StringTools.passOnlyNumbersAndSmallAscii((String)"@&!"));
    }
}

