/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.datareprez.abstractImpl;

import eu.javaexperience.datareprez.DataArray;
import eu.javaexperience.datareprez.DataObject;
import eu.javaexperience.datareprez.DataSender;
import eu.javaexperience.datareprez.abstractImpl.DataProtocol;
import eu.javaexperience.datareprez.abstractImpl.DataProtocolAbstractImpl;
import java.io.IOException;
import java.io.OutputStream;

public class GenericDataSender
extends DataProtocolAbstractImpl
implements DataSender {
    protected DataProtocol protocol;
    protected OutputStream os;

    public GenericDataSender(DataProtocol protocol, OutputStream os) {
        this.protocol = protocol;
        this.os = os;
    }

    @Override
    protected DataProtocol getProtocolHandler() {
        return this.protocol;
    }

    @Override
    public void close() throws IOException {
        this.os.close();
    }

    @Override
    public void send(DataObject o) throws IOException {
        this.protocol.sendPacket(o.toBlob(), this.os);
    }

    @Override
    public void send(DataArray a) throws IOException {
        this.protocol.sendPacket(a.toBlob(), this.os);
    }

    @Override
    public Object getImpl() {
        return null;
    }

    @Override
    public Class getCommonsClass() {
        return this.protocol.getCommonsClass();
    }
}

