/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.datareprez.xmlImpl;

import eu.javaexperience.collection.PublisherCollection;
import eu.javaexperience.datareprez.DataArray;
import eu.javaexperience.datareprez.DataCommonAbstractImpl;
import eu.javaexperience.datareprez.DataObject;
import eu.javaexperience.datareprez.DataReceiver;
import eu.javaexperience.datareprez.DataReprezTools;
import eu.javaexperience.datareprez.DataSender;
import eu.javaexperience.datareprez.xmlImpl.DataArrayXmlImpl;
import eu.javaexperience.datareprez.xmlImpl.DataObjectXmlImpl;
import eu.javaexperience.datareprez.xmlImpl.XmlDataReceiver;
import eu.javaexperience.datareprez.xmlImpl.XmlDataSender;
import eu.javaexperience.document.DocumentTools;
import eu.javaexperience.interfaces.ObjectWithProperty;
import eu.javaexperience.reflect.CastTo;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.text.Format;
import eu.javaexperience.text.StringTools;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.xml.transform.TransformerException;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class DataOperatorXmlCommon
extends DataCommonAbstractImpl {
    static DataObjectXmlImpl objPrototype = new DataObjectXmlImpl();
    static DataArrayXmlImpl arrPrototype = new DataArrayXmlImpl();
    public static final String NODE_NAME_MARK_NEED_ADOPT = "DataObjectXml_DataReprezentationObject_withoutRootNode_that_need_to_be_adopted";
    protected final Node node;

    public DataOperatorXmlCommon(Node n) {
        this.node = n;
    }

    @Override
    public DataObject newObjectInstance() {
        return new DataObjectXmlImpl();
    }

    @Override
    public DataArray newArrayInstance() {
        return new DataArrayXmlImpl();
    }

    @Override
    public void sendDataObject(DataObject dat, OutputStream os) throws IOException {
        DataOperatorXmlCommon.sendObject(dat, os);
    }

    public static DataObject receiveObject(InputStream is) throws IOException {
        byte[] b = new byte[1000];
        int ep = 0;
        int i = 0;
        i = is.read();
        if (i == -1) {
            throw new IOException("Socket closed");
        }
        b[ep] = (byte)i;
        ++ep;
        while ((i = is.read()) != -1 && i != 10) {
            b[ep] = (byte)i;
            if (++ep != b.length) continue;
            b = Arrays.copyOf(b, ep * 2);
        }
        return DataOperatorXmlCommon.xmlObjectFromBlob(Arrays.copyOf(b, ep));
    }

    public static void sendObject(DataObject dat, OutputStream os) throws IOException {
        os.write(DataOperatorXmlCommon.xmlToString(((DataOperatorXmlCommon)((Object)dat)).node).getBytes());
        os.write(10);
        os.flush();
    }

    public static void sendArray(DataArray dat, OutputStream os) throws IOException {
        os.write(((DataArrayXmlImpl)dat).toString().getBytes());
        os.write(10);
        os.flush();
    }

    public static DataArray receiveArray(InputStream is) throws IOException {
        byte[] b = new byte[1000];
        int ep = 0;
        int i = 0;
        i = is.read();
        if (i == -1) {
            throw new IOException("A socket bez\u00e1rult");
        }
        b[ep] = (byte)i;
        ++ep;
        while ((i = is.read()) != -1 && i != 10) {
            b[ep] = (byte)i;
            if (++ep != b.length) continue;
            b = Arrays.copyOf(b, ep * 2);
        }
        String ki = new String(Arrays.copyOf(b, ep));
        return ki.length() == 0 ? null : new DataArrayXmlImpl();
    }

    @Override
    public DataObject receiveDataObject(InputStream is) throws IOException {
        return DataOperatorXmlCommon.receiveObject(is);
    }

    @Override
    public void sendDataArray(DataArray dat, OutputStream os) throws IOException {
        DataOperatorXmlCommon.sendArray(dat, os);
    }

    @Override
    public DataArray receiveDataArray(InputStream is) throws IOException {
        return DataOperatorXmlCommon.receiveArray(is);
    }

    @Override
    public DataSender newDataSender(OutputStream os) {
        return new XmlDataSender(os);
    }

    @Override
    public DataReceiver newDataReceiver(InputStream is) {
        return new XmlDataReceiver(is);
    }

    @Override
    public boolean isNull(Object o) {
        return null == o || o == JSONObject.NULL;
    }

    public static DataArray xmlArrayFromBlob(byte[] data) {
        try {
            Document doc = DocumentTools.parseDocument((String)new String(data));
            return new DataArrayXmlImpl(doc.getFirstChild());
        }
        catch (Exception e) {
            Mirror.propagateAnyway((Throwable)e);
            return null;
        }
    }

    public static DataObject xmlObjectFromBlob(byte[] data) {
        try {
            Document doc = DocumentTools.parseDocument((String)new String(data));
            return new DataObjectXmlImpl(doc);
        }
        catch (Exception e) {
            Mirror.propagateAnyway((Throwable)e);
            return null;
        }
    }

    @Override
    public DataArray arrayFromBlob(byte[] data) {
        return DataOperatorXmlCommon.xmlArrayFromBlob(data);
    }

    @Override
    public DataObject objectFromBlob(byte[] data) {
        return DataOperatorXmlCommon.xmlObjectFromBlob(data);
    }

    protected abstract Node getOrCreateSubjectValue(Object var1, boolean var2);

    protected static void adoptSubNodesTo(Node dst, Node srcRoot) {
        Document doc = DocumentTools.getOwnerDocument((Node)dst);
        NodeList nl = srcRoot.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            dst.appendChild(doc.adoptNode(nl.item(i)));
        }
    }

    protected static void adoptNodeTo(Node dst, boolean childs, String name, Node src) {
        Document doc = DocumentTools.getOwnerDocument((Node)dst);
        if (childs) {
            DocumentTools.adoptAttributes((Document)doc, (Node)dst, (Node)src);
            NodeList nl = src.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                dst.appendChild(DataOperatorXmlCommon.adoptOrCopy(doc, name, nl.item(i)));
            }
        } else {
            dst.appendChild(DataOperatorXmlCommon.adoptOrCopy(doc, name, src));
        }
    }

    protected static Node adoptOrCopy(Document doc, String name, Node src) {
        if (null == name) {
            return DocumentTools.copyAttrAndAdopChilds((Document)doc, (Node)DataOperatorXmlCommon.createTag(doc, src.getNodeName()), (Node)src);
        }
        return DocumentTools.copyAttrAndAdopChilds((Document)doc, (Node)DataOperatorXmlCommon.createTag(doc, name), (Node)src);
    }

    protected boolean needAdopt() {
        return NODE_NAME_MARK_NEED_ADOPT.equals(this.node.getNodeName());
    }

    public static void applyNodeValue(final DataOperatorXmlCommon subject, final Node n, final String name, Object value) {
        if (null == value) {
            n.setTextContent("");
            return;
        }
        if (value instanceof DataArrayXmlImpl) {
            DataArrayXmlImpl arr = (DataArrayXmlImpl)value;
            arr.fillNodes((Collection<Node>)new PublisherCollection<Node>(){

                public boolean add(Node obj) {
                    DataOperatorXmlCommon.adoptNodeTo(n, false, subject.getKeyOrName(name), obj);
                    return false;
                }
            });
        } else if (value instanceof DataObjectXmlImpl) {
            if (subject instanceof DataArray) {
                DataObjectXmlImpl s = (DataObjectXmlImpl)value;
                DocumentTools.copyAttrAndAdopChilds((Document)DocumentTools.getOwnerDocument((Node)subject.node), (Node)n, (Node)s.node);
            } else {
                DataObjectXmlImpl s = (DataObjectXmlImpl)value;
                DataOperatorXmlCommon.adoptNodeTo(n, s.needAdopt(), null, s.node);
            }
        } else if (value instanceof DataObject) {
            DataObjectXmlImpl dst = new DataObjectXmlImpl(n);
            DataReprezTools.copyInto(dst, (ObjectWithProperty)((DataObject)value));
            DataOperatorXmlCommon.applyNodeValue(subject, n, name, dst);
        } else if (value instanceof DataArray) {
            DataArrayXmlImpl dst = new DataArrayXmlImpl(n.getNodeName(), n);
            DataReprezTools.copyInto(dst, (DataArray)value);
            DataOperatorXmlCommon.applyNodeValue(subject, n, name, dst);
        } else {
            n.setTextContent(String.valueOf(value));
        }
    }

    protected void setSubjectValue(Object key, Object value) {
        String name = null;
        name = key instanceof String ? (String)key : ((DataArrayXmlImpl)this).name;
        if (this instanceof DataObject && value instanceof DataArray) {
            DataArray src = (DataArray)value;
            DataArrayXmlImpl arr = new DataArrayXmlImpl(name, this.node);
            for (int i = 0; i < src.size(); ++i) {
                arr.setSubjectValue(i, src.get(i));
            }
        } else {
            DataOperatorXmlCommon.applyNodeValue(this, this.getOrCreateSubjectValue(key, true), name, value);
        }
    }

    protected <C> C getValueOpt(Object key, Class<C> cls, C obj) {
        C ret = this.getValueAs(key, cls, true);
        if (null != ret) {
            return obj;
        }
        return obj;
    }

    protected <C> C getValueAs(Object _key, Class<C> cls, boolean mayNull) {
        Node n = this.getOrCreateSubjectValue(_key, false);
        if (null == n) {
            if (!mayNull) {
                throw new RuntimeException("Value not preset under key: " + _key);
            }
            return null;
        }
        if (null == cls) {
            if (null != n && (n.hasChildNodes() || n.hasAttributes())) {
                return (C)n;
            }
            return null;
        }
        if (String.class == cls) {
            return (C)CastTo.String.cast((Object)n.getTextContent());
        }
        if (byte[].class == cls) {
            return (C)Format.base64Decode((String)((String)CastTo.String.cast((Object)n.getTextContent())));
        }
        if (Integer.TYPE == cls || Integer.class == cls) {
            return (C)CastTo.Int.cast((Object)n.getTextContent());
        }
        if (Long.TYPE == cls || Long.class == cls) {
            return (C)CastTo.Long.cast((Object)n.getTextContent());
        }
        if (Double.TYPE == cls || Double.class == cls) {
            return (C)CastTo.Double.cast((Object)n.getTextContent());
        }
        if (Boolean.TYPE == cls || Boolean.class == cls) {
            return (C)CastTo.Boolean.cast((Object)n.getTextContent());
        }
        if (Node.class == cls) {
            return (C)n;
        }
        if (Node[].class == cls && _key instanceof String) {
            String key = (String)_key;
            boolean attr = key.startsWith("-");
            if (attr) {
                NamedNodeMap nm = this.node.getAttributes();
                Node ret = nm.getNamedItem(key = StringTools.getSubstringAfterFirstString((String)key, (String)"-"));
                if (null != ret) {
                    return (C)new Node[]{ret};
                }
                return null;
            }
            ArrayList<Node> toArr = new ArrayList<Node>();
            NodeList nl = this.node.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                Node item = nl.item(i);
                if (!item.getNodeName().equals(key)) continue;
                toArr.add(item);
            }
            return (C)toArr.toArray(DocumentTools.emptyNodeArrayInstance);
        }
        return null;
    }

    @Override
    public byte[] toBlob() {
        StringBuilder sb = new StringBuilder();
        try {
            NodeList nl = this.node.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                DocumentTools.toString((Node)nl.item(i), (Appendable)sb);
            }
            return sb.toString().getBytes();
        }
        catch (TransformerException e) {
            Mirror.propagateAnyway((Throwable)e);
            return null;
        }
    }

    public static Node createTag(Document doc, String name) {
        if (name.equals("#text")) {
            return doc.createTextNode("");
        }
        if (name.equals("#comment")) {
            return doc.createComment("");
        }
        return doc.createElement(name);
    }

    protected String getKeyOrName(String key) {
        if (null == key || this instanceof DataArray) {
            return ((DataArrayXmlImpl)this).name;
        }
        return key;
    }

    public static String xmlToString(Node node) {
        try {
            if (node.getChildNodes().getLength() == 1) {
                return DocumentTools.toString((Node)node.getFirstChild());
            }
            return DocumentTools.toString((Node)node);
        }
        catch (TransformerException e) {
            Mirror.propagateAnyway((Throwable)e);
            return null;
        }
    }

    protected static Object tryExamineOrWrapObject(Node n) {
        NodeList ch = n.getChildNodes();
        switch (ch.getLength()) {
            case 0: {
                return n;
            }
            case 1: {
                if (!DocumentTools.isTextNode((Node)ch.item(0))) break;
                return n.getTextContent();
            }
        }
        return new DataObjectXmlImpl(n);
    }

    public Object get(String key) {
        Object o = this.getValueAs(key, null, true);
        if (o instanceof Node) {
            return DataOperatorXmlCommon.tryExamineOrWrapObject((Node)o);
        }
        return o;
    }

    public Object opt(String key) {
        Object o = this.getValueAs(key, null, true);
        if (o instanceof Node) {
            return new DataObjectXmlImpl((Node)o);
        }
        if (o instanceof Node[]) {
            return new DataArrayXmlImpl(key, this.node);
        }
        return o;
    }

    public Object opt(String key, Object obj) {
        Object o = this.getValueAs(key, null, true);
        if (o == null) {
            return obj;
        }
        if (o instanceof Node) {
            return new DataObjectXmlImpl((Node)o);
        }
        if (o instanceof Node[]) {
            return new DataArrayXmlImpl(key, this.node);
        }
        return o;
    }

    public String toString() {
        return DataOperatorXmlCommon.xmlToString(this.node);
    }

    @Override
    public Class getCommonsClass() {
        return DataOperatorXmlCommon.class;
    }
}

