/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.datareprez.xmlImpl;

import eu.javaexperience.datareprez.DataArray;
import eu.javaexperience.datareprez.DataObject;
import eu.javaexperience.datareprez.DataReceiver;
import eu.javaexperience.datareprez.jsonImpl.DataOperatorJsonCommon;
import eu.javaexperience.datareprez.xmlImpl.DataArrayXmlImpl;
import eu.javaexperience.datareprez.xmlImpl.DataObjectXmlImpl;
import eu.javaexperience.document.DocumentTools;
import eu.javaexperience.reflect.Mirror;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class XmlDataReceiver
extends DataOperatorJsonCommon
implements DataReceiver {
    private final BufferedReader br;

    public XmlDataReceiver(InputStream is) {
        this.br = new BufferedReader(new InputStreamReader(is));
    }

    @Override
    public DataObject receiveDataObject() throws IOException {
        String dat = this.br.readLine();
        if (dat == null) {
            return null;
        }
        try {
            return new DataObjectXmlImpl(DocumentTools.parseDocument((String)dat));
        }
        catch (Exception e) {
            Mirror.propagateAnyway((Throwable)e);
            return null;
        }
    }

    @Override
    public DataArray readDataArray() throws IOException {
        String dat = this.br.readLine();
        if (dat == null) {
            return null;
        }
        try {
            return new DataArrayXmlImpl(DocumentTools.parseDocument((String)dat));
        }
        catch (Exception e) {
            Mirror.propagateAnyway((Throwable)e);
            return null;
        }
    }

    @Override
    public void close() throws IOException {
        this.br.close();
    }
}

