/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.datareprez;

import eu.javaexperience.collection.map.BulkTransitMap;
import eu.javaexperience.collection.map.SmallMap;
import eu.javaexperience.datareprez.DataArray;
import eu.javaexperience.datareprez.DataCommon;
import eu.javaexperience.datareprez.DataObject;
import eu.javaexperience.datareprez.convertFrom.ArrayLike;
import eu.javaexperience.datareprez.convertFrom.ClassObjectLike;
import eu.javaexperience.datareprez.convertFrom.DataLike;
import eu.javaexperience.datareprez.convertFrom.DataWrapper;
import eu.javaexperience.datareprez.convertFrom.ModifiableObject;
import eu.javaexperience.exceptions.UnimplementedCaseException;
import eu.javaexperience.interfaces.ObjectWithProperty;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.reflect.NotatedCaster;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Date;
import java.util.Map;

public class DataReprezTools {
    public static final String[] emptyStringArray = new String[0];
    public static final DataWrapper WRAP_ARRAY_COLLECTION_MAP = new DataWrapper(){

        @Override
        public DataCommon wrap(DataWrapper topWrapper, DataCommon transferDatatype, Object in) {
            if (in.getClass().isArray()) {
                int len = Array.getLength(in);
                DataArray arr = transferDatatype.newArrayInstance();
                for (int i = 0; i < len; ++i) {
                    Object add = Array.get(in, i);
                    if (null != DataReprezTools.put(topWrapper, arr, i, add)) continue;
                    DataReprezTools.put(topWrapper, arr, i, (Object)topWrapper.wrap(topWrapper, transferDatatype, add));
                }
                return arr;
            }
            if (in instanceof Collection) {
                Collection src = (Collection)in;
                DataArray arr = transferDatatype.newArrayInstance();
                int i = 0;
                for (Object o : src) {
                    if (null != DataReprezTools.put(topWrapper, arr, i++, o)) continue;
                    DataReprezTools.put(topWrapper, arr, i++, (Object)topWrapper.wrap(topWrapper, transferDatatype, o));
                }
                return arr;
            }
            if (in instanceof Map) {
                Map m = (Map)in;
                DataObject ret = transferDatatype.newObjectInstance();
                for (Map.Entry kv : m.entrySet()) {
                    if (null != DataReprezTools.put(topWrapper, ret, String.valueOf(kv.getKey()), kv.getValue())) continue;
                    DataCommon value = topWrapper.wrap(topWrapper, transferDatatype, kv.getValue());
                    DataReprezTools.put(topWrapper, ret, String.valueOf(kv.getKey()), (Object)value);
                }
                return ret;
            }
            return null;
        }
    };
    public static final DataWrapper WRAP_DATA_LIKE = new DataWrapper(){

        @Override
        public DataCommon wrap(DataWrapper dw, DataCommon prototype, Object o) {
            if (o instanceof DataLike) {
                DataLike in = (DataLike)o;
                switch (in.getDataReprezType()) {
                    case ARRAY: {
                        ArrayLike arr = (ArrayLike)in;
                        DataArray ret = prototype.newArrayInstance();
                        for (int i = 0; i < arr.size(); ++i) {
                            Object add = arr.get(i);
                            if (null != DataReprezTools.put(ret, i, add)) continue;
                            DataReprezTools.put(ret, i, (Object)dw.wrap(dw, prototype, add));
                        }
                        return ret;
                    }
                    case OBJECT: 
                    case CLASS_OBJECT: 
                    case RESOURCE: {
                        ObjectWithProperty obj = (ObjectWithProperty)in;
                        DataObject ret = prototype.newObjectInstance();
                        for (String key : obj.keys()) {
                            Object w = obj.get(key);
                            if (null != DataReprezTools.put(ret, key, w)) continue;
                            DataReprezTools.put(ret, key, (Object)dw.wrap(dw, prototype, w));
                        }
                        if (obj instanceof ClassObjectLike) {
                            ret.putString("class", ((ClassObjectLike)obj).getClassIdentifier());
                        }
                        return ret;
                    }
                    case NULL: 
                    case PRIMITIVE: {
                        return null;
                    }
                }
                throw new UnimplementedCaseException((Enum)in.getDataReprezType());
            }
            return null;
        }
    };
    public static final DataWrapper WRAP_OBJECT_WITH_PROPERTIES = new DataWrapper(){

        @Override
        public DataCommon wrap(DataWrapper dw, DataCommon prototype, Object o) {
            if (o instanceof ObjectWithProperty) {
                ObjectWithProperty obj = (ObjectWithProperty)o;
                DataObject ret = prototype.newObjectInstance();
                for (String key : obj.keys()) {
                    Object w = obj.get(key);
                    if (null != DataReprezTools.put(ret, key, w)) continue;
                    DataReprezTools.put(ret, key, (Object)dw.wrap(dw, prototype, w));
                }
            }
            return null;
        }
    };
    public static final DataWrapper WRAP_ENUM = new DataWrapper(){

        @Override
        public DataCommon wrap(DataWrapper topWrapper, DataCommon prototype, Object o) {
            if (null != o && o.getClass().isEnum()) {
                DataObject ret = prototype.newObjectInstance();
                ret.putString("name", ((Enum)o).name());
                ret.putInt("ordinal", ((Enum)o).ordinal());
                ret.putString("class", o.getClass().getName());
                return ret;
            }
            return null;
        }
    };
    public static final DataWrapper WRAP_CLASS__OBJECT_WITH_PROPERTY = new DataWrapper(){

        @Override
        public DataCommon wrap(DataWrapper topWrapper, DataCommon prototype, Object o) {
            if (o instanceof ObjectWithProperty) {
                ObjectWithProperty owp = (ObjectWithProperty)o;
                DataObject ret = prototype.newObjectInstance();
                for (String s : owp.keys()) {
                    DataReprezTools.put(topWrapper, ret, s, owp.get(s));
                }
                return ret;
            }
            return null;
        }
    };

    public static Class<?> put(DataArray arr, Object o) {
        return DataReprezTools.put(arr, arr.size(), o);
    }

    public static Class<?> put(DataArray arr, int i, Object o) {
        return DataReprezTools.put(null, arr, i, o);
    }

    public static Class<?> put(DataWrapper dw, DataArray arr, int i, Object o) {
        DataCommon wrap;
        if (o == null || arr.isNull(o)) {
            arr.putNull(i);
            return Void.class;
        }
        if (o instanceof String) {
            arr.putString(i, (String)o);
            return String.class;
        }
        if (o instanceof Long) {
            arr.putLong(i, (Long)o);
            return Long.class;
        }
        if (o instanceof Integer) {
            arr.putInt(i, (Integer)o);
            return Integer.class;
        }
        if (o instanceof Double) {
            arr.putDouble(i, (Double)o);
            return Double.class;
        }
        if (o instanceof byte[]) {
            arr.putBlob(i, (byte[])o);
            return byte[].class;
        }
        if (o instanceof Boolean) {
            arr.putBoolean(i, (Boolean)o);
            return Boolean.class;
        }
        if (o instanceof DataObject) {
            if (arr.getCommonsClass().isAssignableFrom(((DataObject)o).getCommonsClass())) {
                arr.putObject(i, (DataObject)o);
            } else {
                DataObject dobj = ((DataObject)o).newObjectInstance();
                DataReprezTools.copyInto(dobj, (ObjectWithProperty)((DataObject)o));
                arr.putObject(i, dobj);
            }
            return DataObject.class;
        }
        if (o instanceof DataArray) {
            if (arr.getCommonsClass().isAssignableFrom(((DataArray)o).getCommonsClass())) {
                arr.putArray(i, (DataArray)o);
            } else {
                DataArray darr = ((DataArray)o).newArrayInstance();
                DataReprezTools.copyInto(darr, (DataArray)o);
                arr.putArray(i, darr);
            }
            return DataArray.class;
        }
        if (o instanceof Float) {
            arr.putDouble(i, ((Float)o).doubleValue());
            return Float.class;
        }
        if (o instanceof Character) {
            arr.putString(i, new String(new char[]{((Character)o).charValue()}));
            return Character.class;
        }
        if (o instanceof Short) {
            arr.putInt(i, ((Short)o).intValue());
            return Short.class;
        }
        if (o instanceof Byte) {
            arr.putInt(i, ((Byte)o).intValue());
            return Byte.class;
        }
        if (null != dw && null != (wrap = dw.wrap(dw, arr, o))) {
            return DataReprezTools.put(dw, arr, i, (Object)wrap);
        }
        return null;
    }

    public static Class<?> put(DataObject obj, String key, Object o) {
        return DataReprezTools.put(null, obj, key, o);
    }

    public static Class<?> put(DataWrapper dw, DataObject obj, String key, Object o) {
        DataCommon wrap;
        if (o == null || obj.isNull(o)) {
            obj.putNull(key);
            return Void.class;
        }
        if (o instanceof String) {
            obj.putString(key, (String)o);
            return String.class;
        }
        if (o instanceof Long) {
            obj.putLong(key, (Long)o);
            return Long.class;
        }
        if (o instanceof Integer) {
            obj.putInt(key, (Integer)o);
            return Integer.class;
        }
        if (o instanceof Double) {
            obj.putDouble(key, (Double)o);
            return Double.class;
        }
        if (o instanceof byte[]) {
            obj.putBlob(key, (byte[])o);
            return byte[].class;
        }
        if (o instanceof Boolean) {
            obj.putBoolean(key, (Boolean)o);
            return Boolean.class;
        }
        if (o instanceof DataObject) {
            if (obj.getClass().isAssignableFrom(o.getClass())) {
                obj.putObject(key, (DataObject)o);
            } else {
                DataObject dobj = ((DataObject)o).newObjectInstance();
                DataReprezTools.copyInto(dobj, (ObjectWithProperty)((DataObject)o));
                obj.putObject(key, dobj);
            }
            return DataObject.class;
        }
        if (o instanceof DataArray) {
            if (obj.getClass().isAssignableFrom(o.getClass())) {
                obj.putArray(key, (DataArray)o);
            } else {
                DataArray darr = ((DataArray)o).newArrayInstance();
                DataReprezTools.copyInto(darr, (DataArray)o);
                obj.putArray(key, darr);
            }
            return DataArray.class;
        }
        if (o instanceof Float) {
            obj.putDouble(key, ((Float)o).doubleValue());
            return Float.class;
        }
        if (o instanceof Character) {
            obj.putString(key, new String(new char[]{((Character)o).charValue()}));
            return Character.class;
        }
        if (o instanceof Short) {
            obj.putInt(key, ((Short)o).intValue());
            return Short.class;
        }
        if (o instanceof Byte) {
            obj.putInt(key, ((Byte)o).intValue());
            return Byte.class;
        }
        if (o instanceof Date) {
            obj.putLong(key, ((Date)o).getTime());
            return Long.class;
        }
        if (o.getClass().isArray()) {
            DataArray arr = obj.newArrayInstance();
            for (int i = 0; i < Array.getLength(o); ++i) {
                DataReprezTools.put(dw, arr, i, Array.get(o, i));
            }
            obj.putArray(key, arr);
            return DataArray.class;
        }
        if (o instanceof Collection) {
            Collection c = (Collection)o;
            DataArray arr = obj.newArrayInstance();
            int i = 0;
            for (Object add : c) {
                DataReprezTools.put(dw, arr, i++, add);
            }
            obj.putArray(key, arr);
            return DataArray.class;
        }
        if (null != dw && null != (wrap = dw.wrap(dw, obj, o))) {
            return DataReprezTools.put(dw, obj, key, (Object)wrap);
        }
        return null;
    }

    public static Class<?> isStorable(Object o) {
        if (o == null) {
            return Void.class;
        }
        if (o instanceof String) {
            return String.class;
        }
        if (o instanceof Long) {
            return Long.class;
        }
        if (o instanceof Integer) {
            return Integer.class;
        }
        if (o instanceof Double) {
            return Double.class;
        }
        if (o instanceof byte[]) {
            return byte[].class;
        }
        if (o instanceof Boolean) {
            return Boolean.class;
        }
        if (o instanceof DataObject) {
            return DataObject.class;
        }
        if (o instanceof DataArray) {
            return DataArray.class;
        }
        if (o instanceof Float) {
            return Float.class;
        }
        if (o instanceof Character) {
            return Character.class;
        }
        if (o instanceof Short) {
            return Short.class;
        }
        if (o instanceof Byte) {
            return Byte.class;
        }
        if (o instanceof Date) {
            return Long.class;
        }
        return null;
    }

    public static Object extractToJavaPrimitiveTypes(Object any) {
        if (any instanceof ArrayLike) {
            DataArray arr = (DataArray)any;
            Object[] ret = new Object[arr.size()];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = DataReprezTools.extractToJavaPrimitiveTypes(arr.get(i));
            }
            return ret;
        }
        if (any instanceof ObjectWithProperty) {
            ObjectWithProperty obj = (ObjectWithProperty)any;
            SmallMap ret = new SmallMap();
            for (String k : obj.keys()) {
                ret.put(k, DataReprezTools.extractToJavaPrimitiveTypes(obj.get(k)));
            }
            return ret;
        }
        return any;
    }

    public static Object wrapRecursively(DataWrapper wrapper, DataCommon carrierPrototype, Object toWrap) {
        return wrapper.wrap(wrapper, carrierPrototype, toWrap);
    }

    public static DataWrapper combineWrappers(final DataWrapper ... wrappers) {
        return new DataWrapper(){

            @Override
            public DataCommon wrap(DataWrapper topWrapper, DataCommon prototype, Object o) {
                DataCommon ret = null;
                for (DataWrapper w : wrappers) {
                    ret = w.wrap(this, prototype, o);
                    if (null == ret) continue;
                    return ret;
                }
                return null;
            }
        };
    }

    public static DataWrapper createClassInstanceWrapper(Mirror.FieldSelector select) {
        return DataReprezTools.createClassInstanceWrapper(select, null);
    }

    public static DataWrapper createClassInstanceWrapper(final Mirror.FieldSelector select, final String classFieldName) {
        return new DataWrapper(){

            @Override
            public DataCommon wrap(DataWrapper topWrapper, DataCommon prototype, Object o) {
                try {
                    BulkTransitMap values = new BulkTransitMap();
                    Mirror.extractFieldsToMap((Object)o, (Map)values, (Mirror.FieldSelector)select);
                    DataObject ret = prototype.newObjectInstance();
                    for (Map.Entry kv : values.entrySet()) {
                        Object val;
                        String key = (String)kv.getKey();
                        if (null != DataReprezTools.put(topWrapper, ret, key, val = kv.getValue())) continue;
                        DataReprezTools.put(topWrapper, ret, key, (Object)topWrapper.wrap(topWrapper, prototype, val));
                    }
                    if (null != classFieldName) {
                        ret.putString(classFieldName, o.getClass().getSimpleName());
                    }
                    return ret;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
        };
    }

    public static void copyInto(DataObject dst, ObjectWithProperty src) {
        for (String s : src.keys()) {
            DataReprezTools.put(dst, s, src.get(s));
        }
    }

    public static void copyInto(ModifiableObject dst, ObjectWithProperty src) {
        for (String s : src.keys()) {
            dst.set(s, src.get(s));
        }
    }

    public static void copyInto(DataArray dst, ArrayLike src) {
        int s = src.size();
        for (int i = 0; i < s; ++i) {
            DataReprezTools.put(dst, i, src.get(i));
        }
    }

    public static <T> T getAsOrThrow(DataObject obj, String key, NotatedCaster c) {
        Object ret = obj.get(key);
        if (null == ret) {
            throw new RuntimeException("`" + key + "` key not found");
        }
        if (null == (ret = c.cast(ret))) {
            throw new RuntimeException("Can't cast `" + ret + "` to " + c.getTypeFullQualifiedName());
        }
        return (T)ret;
    }

    public static <T> T getAsOrThrow(DataArray arr, int index, NotatedCaster c) {
        Object ret = arr.get(index);
        if (null == ret) {
            throw new RuntimeException(index + " index not fount");
        }
        if (null == (ret = c.cast(ret))) {
            throw new RuntimeException("Can't cast `" + ret + "` to " + c.getTypeFullQualifiedName());
        }
        return (T)ret;
    }
}

