/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.datareprez.jsonImpl;

import eu.javaexperience.datareprez.DataArray;
import eu.javaexperience.datareprez.DataCommonAbstractImpl;
import eu.javaexperience.datareprez.DataObject;
import eu.javaexperience.datareprez.DataReceiver;
import eu.javaexperience.datareprez.DataSender;
import eu.javaexperience.datareprez.jsonImpl.DataArrayJsonImpl;
import eu.javaexperience.datareprez.jsonImpl.DataObjectJsonImpl;
import eu.javaexperience.datareprez.jsonImpl.JsonDataReceiver;
import eu.javaexperience.datareprez.jsonImpl.JsonDataSender;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class DataOperatorJsonCommon
extends DataCommonAbstractImpl {
    static DataObjectJsonImpl objPrototype = new DataObjectJsonImpl();
    static DataArrayJsonImpl arrPrototype = new DataArrayJsonImpl();

    @Override
    public DataObject newObjectInstance() {
        return new DataObjectJsonImpl();
    }

    @Override
    public DataArray newArrayInstance() {
        return new DataArrayJsonImpl();
    }

    @Override
    public void sendDataObject(DataObject dat, OutputStream os) throws IOException {
        DataOperatorJsonCommon.sendObject(dat, os);
    }

    public static DataObject receiveObject(InputStream is) throws IOException {
        byte[] b = new byte[1000];
        int ep = 0;
        int i = 0;
        i = is.read();
        if (i == -1) {
            throw new IOException("A socket bez\u00e1rult");
        }
        b[ep] = (byte)i;
        ++ep;
        while ((i = is.read()) != -1 && i != 10) {
            b[ep] = (byte)i;
            if (++ep != b.length) continue;
            b = Arrays.copyOf(b, ep * 2);
        }
        String ki = new String(Arrays.copyOf(b, ep));
        return ki.length() == 0 ? null : new DataObjectJsonImpl(new JSONObject(ki));
    }

    public static void sendObject(DataObject dat, OutputStream os) throws IOException {
        os.write(((DataObjectJsonImpl)dat).obj.toString().getBytes());
        os.write(10);
        os.flush();
    }

    public static void sendArray(DataArray dat, OutputStream os) throws IOException {
        os.write(((DataArrayJsonImpl)dat).arr.toString().getBytes());
        os.write(10);
        os.flush();
    }

    public static DataArray receiveArray(InputStream is) throws IOException {
        byte[] b = new byte[1000];
        int ep = 0;
        int i = 0;
        i = is.read();
        if (i == -1) {
            throw new IOException("A socket bez\u00e1rult");
        }
        b[ep] = (byte)i;
        ++ep;
        while ((i = is.read()) != -1 && i != 10) {
            b[ep] = (byte)i;
            if (++ep != b.length) continue;
            b = Arrays.copyOf(b, ep * 2);
        }
        String ki = new String(Arrays.copyOf(b, ep));
        return ki.length() == 0 ? null : new DataArrayJsonImpl(new JSONArray(ki));
    }

    @Override
    public DataObject receiveDataObject(InputStream is) throws IOException {
        return DataOperatorJsonCommon.receiveObject(is);
    }

    @Override
    public void sendDataArray(DataArray dat, OutputStream os) throws IOException {
        DataOperatorJsonCommon.sendArray(dat, os);
    }

    @Override
    public DataArray receiveDataArray(InputStream is) throws IOException {
        return DataOperatorJsonCommon.receiveArray(is);
    }

    @Override
    public DataSender newDataSender(OutputStream os) {
        return new JsonDataSender(os);
    }

    @Override
    public DataReceiver newDataReceiver(InputStream is) {
        return new JsonDataReceiver(is);
    }

    @Override
    public boolean isNull(Object o) {
        return null == o || o == JSONObject.NULL;
    }

    @Override
    public DataArray arrayFromBlob(byte[] data) {
        return new DataArrayJsonImpl(new JSONArray(new String(data)));
    }

    @Override
    public DataObject objectFromBlob(byte[] data) {
        return new DataObjectJsonImpl(new JSONObject(new String(data)));
    }

    @Override
    public Class getCommonsClass() {
        return JSONObject.class;
    }

    @Override
    public Object getImpl() {
        return null;
    }

    @Override
    public byte[] toBlob() {
        return null;
    }
}

