/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.datareprez;

import eu.javaexperience.collection.map.BulkTransitMap;
import eu.javaexperience.datareprez.DataArray;
import eu.javaexperience.datareprez.DataCommon;
import eu.javaexperience.datareprez.DataObject;
import eu.javaexperience.reflect.Mirror;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public abstract class DataObjectTest {
    protected final DataCommon prototye;

    public DataObjectTest(DataCommon prototype) {
        this.prototye = prototype;
    }

    public static Map<String, Object> createFullFeaturedNative() {
        BulkTransitMap ret = new BulkTransitMap();
        ret.put("string", "string");
        ret.put("array", Mirror.emptyObjectArray);
        ret.put("blob", "blob".getBytes());
        ret.put("boolean", true);
        ret.put("double", Math.PI);
        ret.put("int", Integer.MIN_VALUE);
        ret.put("long", Long.MAX_VALUE);
        ret.put("null", null);
        ret.put("object", new BulkTransitMap());
        return ret;
    }

    public DataObject createNewObject() {
        return this.prototye.newObjectInstance();
    }

    public DataArray createNewArray() {
        return this.prototye.newArrayInstance();
    }

    public DataObject createFullFeature() {
        DataObject obj = this.createNewObject();
        obj.putString("string", "string");
        obj.putArray("array", this.prototye.newArrayInstance());
        obj.putBlob("blob", "blob".getBytes());
        obj.putBoolean("boolean", true);
        obj.putDouble("double", Math.PI);
        obj.putInt("int", Integer.MIN_VALUE);
        obj.putLong("long", Long.MAX_VALUE);
        obj.putNull("null");
        obj.putObject("object", this.prototye.newObjectInstance());
        return obj;
    }

    public void assertFullFeaturedBounded(DataObject obj) {
        Assert.assertEquals((Object)"string", (Object)obj.getString("string"));
        Assert.assertTrue((boolean)(obj.getArray("array") instanceof DataArray));
        Assert.assertArrayEquals((byte[])"blob".getBytes(), (byte[])obj.getBlob("blob"));
        Assert.assertTrue((boolean)obj.getBoolean("boolean"));
        Assert.assertEquals((double)Math.PI, (double)obj.getDouble("double"), (double)1.0E-8);
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)obj.getInt("int"));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)obj.getLong("long"));
        Assert.assertTrue((boolean)obj.isNull("null"));
        Assert.assertTrue((boolean)(obj.getObject("object") instanceof DataObject));
    }

    public void assertFullFeaturedUnbounded(DataObject obj) {
        Assert.assertEquals((Object)"string", (Object)obj.get("string"));
        Assert.assertTrue((boolean)(obj.get("array") instanceof DataArray));
        Assert.assertArrayEquals((byte[])"blob".getBytes(), (byte[])((byte[])obj.get("blob")));
        Assert.assertTrue((boolean)obj.isNull("null"));
        Assert.assertTrue((boolean)(obj.get("object") instanceof DataObject));
    }

    @Test
    public void test_types_comes_back() {
        DataObject full = this.createFullFeature();
        System.out.println(new String(full.toBlob()));
        this.assertFullFeaturedBounded(full);
    }

    @Test
    public void testOptReturnsNull() {
        DataObject obj = this.createNewObject();
        Assert.assertNull((Object)obj.opt("unknown"));
        Assert.assertNull((Object)obj.optString("unknown"));
        Assert.assertNull((Object)obj.optBlob("unknown"));
        Assert.assertNull((Object)obj.optObject("unknown"));
        Assert.assertNull((Object)obj.optArray("unknown"));
    }
}

