/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.datareprez.jsonImpl;

import eu.javaexperience.datareprez.DataArray;
import eu.javaexperience.datareprez.DataObject;
import eu.javaexperience.datareprez.convertFrom.DataReprezType;
import eu.javaexperience.datareprez.jsonImpl.DataObjectJsonImpl;
import eu.javaexperience.datareprez.jsonImpl.DataOperatorJsonCommon;
import eu.javaexperience.text.Format;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONObject;

public class DataArrayJsonImpl
extends DataOperatorJsonCommon
implements DataArray {
    final JSONArray arr;

    public DataArrayJsonImpl(JSONArray arr) {
        this.arr = arr;
    }

    public DataArrayJsonImpl() {
        this.arr = new JSONArray();
    }

    @Override
    public void putString(int i, String val) {
        this.arr.put(i, (Object)val);
    }

    @Override
    public void putLong(int i, long val) {
        this.arr.put(i, val);
    }

    @Override
    public void putDouble(int i, double val) {
        this.arr.put(i, val);
    }

    @Override
    public void putInt(int i, int val) {
        this.arr.put(i, val);
    }

    @Override
    public void putBoolean(int i, boolean val) {
        this.arr.put(i, val);
    }

    @Override
    public void putObject(int i, DataObject val) {
        this.arr.put(i, (Object)((DataObjectJsonImpl)val).obj);
    }

    @Override
    public void putArray(int i, DataArray val) {
        this.arr.put(i, (Object)((DataArrayJsonImpl)val).arr);
    }

    @Override
    public void putNull(int i) {
        this.arr.put(i, JSONObject.NULL);
    }

    @Override
    public String getString(int i) {
        return this.arr.getString(i);
    }

    @Override
    public long getLong(int i) {
        return this.arr.getLong(i);
    }

    @Override
    public double getDouble(int i) {
        return this.arr.getDouble(i);
    }

    @Override
    public int getInt(int i) {
        return this.arr.getInt(i);
    }

    @Override
    public boolean getBoolean(int i) {
        return this.arr.getBoolean(i);
    }

    @Override
    public DataObject getObject(int i) {
        JSONObject obj = this.arr.getJSONObject(i);
        if (obj == null) {
            return null;
        }
        return new DataObjectJsonImpl(obj);
    }

    @Override
    public DataArray getArray(int i) {
        JSONArray a = this.arr.getJSONArray(i);
        if (a == null) {
            return null;
        }
        return new DataArrayJsonImpl(a);
    }

    @Override
    public String optString(int i) {
        return this.arr.optString(i);
    }

    @Override
    public long optLong(int i) {
        return this.arr.optLong(i);
    }

    @Override
    public double optDouble(int i) {
        return this.arr.getDouble(i);
    }

    @Override
    public int optInt(int i) {
        return this.arr.getInt(i);
    }

    @Override
    public boolean optBoolean(int i) {
        return this.arr.getBoolean(i);
    }

    @Override
    public DataObject optObject(int i) {
        JSONObject o = this.arr.optJSONObject(i);
        if (o == null) {
            return null;
        }
        return new DataObjectJsonImpl(o);
    }

    @Override
    public DataArray optArray(int i) {
        JSONArray o = this.arr.optJSONArray(i);
        if (o == null) {
            return null;
        }
        return new DataArrayJsonImpl(o);
    }

    @Override
    public String optString(int i, String def) {
        return this.arr.optString(i, def);
    }

    @Override
    public long optLong(int i, long def) {
        return this.arr.optLong(i, def);
    }

    @Override
    public double optDouble(int i, double val) {
        return this.arr.optDouble(i, val);
    }

    @Override
    public int optInt(int i, int def) {
        return this.arr.optInt(i, def);
    }

    @Override
    public boolean optBoolean(int i, boolean def) {
        return this.arr.optBoolean(i, def);
    }

    @Override
    public DataObject optObject(int i, DataObject def) {
        JSONObject o = this.arr.optJSONObject(i);
        if (o == null) {
            return def;
        }
        return new DataObjectJsonImpl(o);
    }

    @Override
    public DataArray optArray(int i, DataArray def) {
        JSONArray o = this.arr.optJSONArray(i);
        if (o == null) {
            return def;
        }
        return new DataArrayJsonImpl(o);
    }

    @Override
    public void unset(int i) {
        this.arr.remove(i);
    }

    @Override
    public int size() {
        return this.arr.length();
    }

    @Override
    public boolean isString(int i) {
        return this.arr.get(i) instanceof String;
    }

    @Override
    public boolean isLong(int i) {
        return this.arr.get(i) instanceof Long;
    }

    @Override
    public boolean isDouble(int i) {
        return this.arr.get(i) instanceof Double;
    }

    @Override
    public boolean isInt(int i) {
        return this.arr.get(i) instanceof Integer;
    }

    @Override
    public boolean isBoolean(int i) {
        return this.arr.get(i) instanceof Boolean;
    }

    @Override
    public boolean isObject(int i) {
        return this.arr.get(i) instanceof JSONObject;
    }

    @Override
    public boolean isArray(int i) {
        return this.arr.get(i) instanceof JSONArray;
    }

    @Override
    public boolean isNull(int i) {
        return this.arr.isNull(i);
    }

    @Override
    public void putString(String val) {
        this.arr.put((Object)val);
    }

    @Override
    public void putLong(long val) {
        this.arr.put(val);
    }

    @Override
    public void putDouble(double val) {
        this.arr.put(val);
    }

    @Override
    public void putInt(int val) {
        this.arr.put(val);
    }

    @Override
    public void putBoolean(boolean val) {
        this.arr.put(val);
    }

    @Override
    public void putObject(DataObject val) {
        this.arr.put((Object)((DataObjectJsonImpl)val).obj);
    }

    @Override
    public void putArray(DataArray val) {
        this.arr.put((Object)((DataArrayJsonImpl)val).arr);
    }

    @Override
    public void putNull() {
        this.arr.put(JSONObject.NULL);
    }

    @Override
    public Object get(int key) {
        Object o = this.arr.get(key);
        if (o instanceof JSONObject) {
            return new DataObjectJsonImpl((JSONObject)o);
        }
        if (o instanceof JSONArray) {
            return new DataArrayJsonImpl((JSONArray)o);
        }
        return o;
    }

    @Override
    public Object opt(int key) {
        Object o = this.arr.opt(key);
        if (o instanceof JSONObject) {
            return new DataObjectJsonImpl((JSONObject)o);
        }
        if (o instanceof JSONArray) {
            return new DataArrayJsonImpl((JSONArray)o);
        }
        return o;
    }

    @Override
    public Object opt(int key, Object obj) {
        Object o = this.arr.opt(key);
        if (o == null) {
            return obj;
        }
        if (o instanceof JSONObject) {
            return new DataObjectJsonImpl((JSONObject)o);
        }
        if (o instanceof JSONArray) {
            return new DataArrayJsonImpl((JSONArray)o);
        }
        return o;
    }

    @Override
    public Object[] asJavaArray() {
        Object[] ret = new Object[this.arr.length()];
        for (int i = 0; i < ret.length; ++i) {
            Object curr = this.arr.get(i);
            ret[i] = this.isNull(curr) ? null : (curr instanceof JSONArray ? new DataArrayJsonImpl((JSONArray)curr).asJavaArray() : (curr instanceof JSONObject ? new DataObjectJsonImpl((JSONObject)curr).asJavaMap() : (curr instanceof DataArray ? ((DataArray)curr).asJavaArray() : (curr instanceof DataObject ? ((DataObject)curr).asJavaMap() : curr))));
        }
        return ret;
    }

    @Override
    public void putBlob(byte[] blob) {
        this.arr.put((Object)Format.base64Encode((byte[])blob));
    }

    @Override
    public void putBlob(int i, byte[] blob) {
        this.arr.put(i, (Object)Format.base64Encode((byte[])blob));
    }

    @Override
    public byte[] getBlob(int i) {
        return Format.base64Decode((String)this.arr.getString(i));
    }

    @Override
    public byte[] optBlob(int i) {
        try {
            return Format.base64Decode((String)this.arr.getString(i));
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public byte[] optBlob(int i, byte[] blob) {
        try {
            return Format.base64Decode((String)this.arr.getString(i));
        }
        catch (Exception e) {
            return blob;
        }
    }

    @Override
    public boolean isBlob(int i) {
        try {
            Format.base64Decode((String)this.arr.getString(i));
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public Object getImpl() {
        return this.arr;
    }

    @Override
    public Iterator<Object> iterator() {
        return this.arr.iterator();
    }

    @Override
    public DataReprezType getDataReprezType() {
        return DataReprezType.ARRAY;
    }

    @Override
    public byte[] toBlob() {
        return this.arr.toString().getBytes();
    }

    public String toString() {
        return "DataArrayJsonImpl: " + this.arr;
    }
}

