/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.datareprez;

import eu.javaexperience.collection.CollectionTools;
import eu.javaexperience.collection.map.MapTools;
import eu.javaexperience.datareprez.DataArray;
import eu.javaexperience.datareprez.DataCommon;
import eu.javaexperience.datareprez.DataObject;
import eu.javaexperience.datareprez.DataReceiver;
import eu.javaexperience.datareprez.DataReprezTools;
import eu.javaexperience.datareprez.DataSender;
import eu.javaexperience.datareprez.example.DataSerialisationTestObject;
import eu.javaexperience.reflect.CastTo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public abstract class DataReprezTest {
    protected final DataCommon prototye;

    public DataReprezTest(DataCommon prototype) {
        this.prototye = prototype;
    }

    public DataObject createNewObject() {
        return this.prototye.newObjectInstance();
    }

    public DataArray createNewArray() {
        return this.prototye.newArrayInstance();
    }

    public DataObject createFullFeature() {
        DataObject obj = this.createNewObject();
        obj.putString("string", "string");
        DataArray arr = this.createNewArray();
        arr.putString("array string");
        arr.putString("array string");
        obj.putArray("array", arr);
        obj.putBlob("blob", "blob".getBytes());
        obj.putBoolean("boolean", true);
        obj.putDouble("double", Math.PI);
        obj.putInt("int", Integer.MIN_VALUE);
        obj.putLong("long", Long.MAX_VALUE);
        obj.putNull("null");
        DataObject so = this.prototye.newObjectInstance();
        so.putString("string", "obj string");
        obj.putObject("object", so);
        return obj;
    }

    public void assertFullFeaturedBounded(DataObject obj) {
        Assert.assertTrue((boolean)obj.isString("string"));
        Assert.assertTrue((boolean)obj.has("string"));
        Assert.assertEquals((Object)"string", (Object)obj.getString("string"));
        Assert.assertEquals((Object)"string", (Object)obj.optString("string"));
        Assert.assertEquals((Object)"string", (Object)obj.optString("string", "hello"));
        Assert.assertNull((Object)obj.optString("none"));
        Assert.assertTrue((boolean)obj.isArray("array"));
        Assert.assertTrue((boolean)obj.has("array"));
        Assert.assertTrue((boolean)(obj.getArray("array") instanceof DataArray));
        Assert.assertTrue((boolean)(obj.optArray("array") instanceof DataArray));
        Assert.assertTrue((boolean)(obj.optArray("array", this.createNewArray()) instanceof DataArray));
        Assert.assertNull((Object)obj.optArray("none"));
        Assert.assertTrue((boolean)obj.isBlob("blob"));
        Assert.assertTrue((boolean)obj.has("blob"));
        Assert.assertArrayEquals((byte[])"blob".getBytes(), (byte[])obj.getBlob("blob"));
        Assert.assertArrayEquals((byte[])"blob".getBytes(), (byte[])obj.optBlob("blob"));
        Assert.assertArrayEquals((byte[])"blob".getBytes(), (byte[])obj.optBlob("blob", new byte[]{10}));
        Assert.assertNull((Object)obj.optBlob("none"));
        Assert.assertTrue((boolean)obj.isBoolean("boolean"));
        Assert.assertTrue((boolean)obj.has("blob"));
        Assert.assertTrue((boolean)obj.getBoolean("boolean"));
        Assert.assertTrue((boolean)obj.optBoolean("boolean"));
        Assert.assertTrue((boolean)obj.optBoolean("boolean", false));
        Assert.assertNull((Object)obj.optBoolean("none"));
        Assert.assertTrue((boolean)obj.isDouble("double"));
        Assert.assertTrue((boolean)obj.has("double"));
        Assert.assertEquals((double)Math.PI, (double)obj.getDouble("double"), (double)1.0E-8);
        Assert.assertEquals((double)Math.PI, (double)obj.optDouble("double"), (double)1.0E-8);
        Assert.assertEquals((double)Math.PI, (double)obj.optDouble("double", -1.0), (double)1.0E-8);
        Assert.assertNull((Object)obj.optDouble("none"));
        Assert.assertTrue((boolean)obj.isInt("int"));
        Assert.assertTrue((boolean)obj.has("int"));
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)obj.getInt("int"));
        Assert.assertEquals((Object)Integer.MIN_VALUE, (Object)obj.optInt("int"));
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)obj.optInt("int", 10));
        Assert.assertNull((Object)obj.optInt("none"));
        Assert.assertTrue((boolean)obj.isLong("long"));
        Assert.assertTrue((boolean)obj.has("long"));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)obj.getLong("long"));
        Assert.assertEquals((Object)Long.MAX_VALUE, (Object)obj.optLong("long"));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)obj.optLong("long", 10L));
        Assert.assertNull((Object)obj.optLong("none"));
        Assert.assertTrue((boolean)obj.isNull("null"));
        Assert.assertTrue((boolean)obj.isObject("object"));
        Assert.assertTrue((boolean)(obj.getObject("object") instanceof DataObject));
        Assert.assertTrue((boolean)(obj.optObject("object") instanceof DataObject));
        Assert.assertTrue((boolean)(obj.optObject("object", null) instanceof DataObject));
        DataObject o = obj.getObject("object");
        Assert.assertTrue((boolean)o.isString("string"));
        Assert.assertTrue((boolean)o.has("string"));
        Assert.assertEquals((Object)"obj string", (Object)o.getString("string"));
        Assert.assertEquals((Object)"obj string", (Object)o.optString("string"));
        Assert.assertEquals((Object)"obj string", (Object)o.optString("string", "hello"));
        Assert.assertNull((Object)o.optString("none"));
        DataArray arr = obj.getArray("array");
        Assert.assertEquals((Object)"array string", (Object)arr.getString(0));
        HashSet keys = new HashSet();
        CollectionTools.inlineAdd(keys, (Object[])new String[]{"boolean", "blob", "int", "long", "double", "string", "object", "array", "null"});
        Assert.assertEquals(keys, (Object)CollectionTools.inlineAdd(new HashSet(), (Object[])obj.keys()));
        Assert.assertEquals((long)9L, (long)obj.size());
    }

    public void assertFullFeaturedUnbounded(DataObject obj) {
        Assert.assertEquals((Object)"string", (Object)obj.get("string"));
        Object blob = obj.get("blob");
        if (blob instanceof String) {
            Assert.assertEquals((Object)"YmxvYg==", (Object)blob);
        } else {
            Assert.assertArrayEquals((byte[])"blob".getBytes(), (byte[])((byte[])blob));
        }
        Assert.assertEquals((Object)Boolean.TRUE, (Object)CastTo.Boolean.cast(obj.get("boolean")));
        Assert.assertEquals((double)Math.PI, (double)((Double)CastTo.Double.cast(obj.get("double"))), (double)1.0E-8);
        Assert.assertEquals((Object)Integer.MIN_VALUE, (Object)CastTo.Int.cast((Object)obj.getInt("int")));
        Assert.assertEquals((Object)Long.MAX_VALUE, (Object)CastTo.Long.cast((Object)obj.getLong("long")));
        Assert.assertTrue((boolean)obj.isNull("null"));
        Assert.assertTrue((boolean)(obj.get("object") instanceof DataObject));
        Assert.assertTrue((boolean)(obj.opt("object") instanceof DataObject));
        Assert.assertTrue((boolean)(obj.optObject("object") instanceof DataObject));
        DataObject o = (DataObject)obj.get("object");
        Assert.assertTrue((boolean)o.isString("string"));
        Assert.assertTrue((boolean)o.has("string"));
        Assert.assertEquals((Object)"obj string", (Object)o.get("string"));
        Assert.assertEquals((Object)"obj string", (Object)o.opt("string"));
        Assert.assertEquals((Object)"obj string", (Object)o.opt("string", (Object)"hello"));
        Assert.assertNull((Object)o.optString("none"));
        Assert.assertTrue((boolean)(obj.get("array") instanceof DataArray));
        Assert.assertTrue((boolean)(obj.opt("array") instanceof DataArray));
        DataArray arr = (DataArray)obj.get("array");
        Assert.assertEquals((Object)"array string", (Object)arr.get(0));
    }

    public void assertAsJavaObject(DataObject obj) {
        Map java = obj.asJavaMap();
        Assert.assertEquals((Object)"string", java.get("string"));
        Assert.assertEquals((Object)CollectionTools.inlineArrayList((Object[])new String[]{"array string", "array string"}), (Object)((List)java.get("array")));
        Object blob = java.get("blob");
        if (blob instanceof byte[]) {
            Assert.assertArrayEquals((byte[])"blob".getBytes(), (byte[])((byte[])blob));
        } else {
            Assert.assertEquals((Object)"YmxvYg==", blob);
        }
        Assert.assertEquals((Object)Boolean.TRUE, (Object)CastTo.Boolean.cast(java.get("boolean")));
        Assert.assertEquals((Object)Math.PI, (Object)CastTo.Double.cast(java.get("double")));
        Assert.assertEquals((Object)Integer.MIN_VALUE, (Object)CastTo.Int.cast(java.get("int")));
        Assert.assertEquals((Object)Long.MAX_VALUE, (Object)CastTo.Long.cast(java.get("long")));
        Assert.assertEquals((Object)MapTools.inlineHashMap((Object[])new Object[]{"string", "obj string"}), java.get("object"));
    }

    @Test
    public void test_types_comes_back() {
        DataObject full = this.createFullFeature();
        this.assertFullFeaturedBounded(full);
        this.assertAsJavaObject(full);
    }

    @Test
    public void testOptReturnsNull() {
        DataObject obj = this.createNewObject();
        Assert.assertNull((Object)obj.opt("unknown"));
        Assert.assertNull((Object)obj.optString("unknown"));
        Assert.assertNull((Object)obj.optBlob("unknown"));
        Assert.assertNull((Object)obj.optObject("unknown"));
        Assert.assertNull((Object)obj.optArray("unknown"));
    }

    @Test
    public void test_types_comes_unbound_back() {
        DataObject full = this.createFullFeature();
        this.assertFullFeaturedUnbounded(full);
        this.assertAsJavaObject(full);
    }

    @Test
    public void test_empty_nulls() {
        DataObject obj = this.createNewObject();
        Assert.assertNull((Object)obj.opt("any"));
        Assert.assertNull((Object)obj.optString("string"));
        Assert.assertNull((Object)obj.optObject("object"));
        Assert.assertNull((Object)obj.optArray("array"));
        Assert.assertNull((Object)obj.optBlob("blob"));
        Assert.assertNull((Object)obj.opt("any"));
    }

    @Test
    public void test_set_remove_nulls() {
        DataObject obj = this.createFullFeature();
        this.assertFullFeaturedBounded(obj);
        obj.remove("object");
        obj.remove("string");
        obj.remove("array");
        obj.remove("blob");
        obj.remove("boolean");
        obj.remove("double");
        obj.remove("int");
        obj.remove("long");
        Assert.assertNull((Object)obj.opt("any"));
        Assert.assertNull((Object)obj.optString("string"));
        Assert.assertNull((Object)obj.optObject("object"));
        Assert.assertNull((Object)obj.optArray("array"));
        Assert.assertNull((Object)obj.optBlob("blob"));
    }

    public static DataObject virtualTransfer1(DataObject obj) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        obj.sendDataObject(obj, (OutputStream)baos);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        return obj.receiveDataObject((InputStream)bais);
    }

    public static DataObject virtualTransfer2(DataCommon comm, DataObject obj) throws IOException {
        byte[] data = obj.toBlob();
        return comm.objectFromBlob(data);
    }

    public static DataObject virtualTransfer3(DataCommon comm, DataObject obj) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataSender sender = comm.newDataSender((OutputStream)baos);
        sender.send(obj);
        baos.flush();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        DataReceiver rec = comm.newDataReceiver((InputStream)bais);
        return rec.receiveDataObject();
    }

    @Test
    public void test_send_receive_basic_bound_1() throws IOException {
        DataObject ret = DataReprezTest.virtualTransfer1(this.createFullFeature());
        this.assertFullFeaturedBounded(ret);
        this.assertAsJavaObject(ret);
    }

    @Test
    public void test_send_receive_basic_unbound_1() throws IOException {
        DataObject ret = DataReprezTest.virtualTransfer1(this.createFullFeature());
        this.assertFullFeaturedUnbounded(ret);
        this.assertAsJavaObject(ret);
    }

    @Test
    public void test_send_receive_basic_bound_2() throws IOException {
        DataObject ret = DataReprezTest.virtualTransfer2(this.prototye, this.createFullFeature());
        this.assertFullFeaturedBounded(ret);
        this.assertAsJavaObject(ret);
    }

    @Test
    public void test_send_receive_basic_unbound_2() throws IOException {
        DataObject ret = DataReprezTest.virtualTransfer2(this.prototye, this.createFullFeature());
        this.assertFullFeaturedUnbounded(ret);
        this.assertAsJavaObject(ret);
    }

    @Test
    public void test_send_receive_basic_bound_3() throws IOException {
        DataObject ret = DataReprezTest.virtualTransfer3(this.prototye, this.createFullFeature());
        this.assertFullFeaturedBounded(ret);
        this.assertAsJavaObject(ret);
    }

    @Test
    public void test_send_receive_basic_unbound_3() throws IOException {
        DataObject ret = DataReprezTest.virtualTransfer3(this.prototye, this.createFullFeature());
        this.assertFullFeaturedUnbounded(ret);
        this.assertAsJavaObject(ret);
    }

    @Test
    public void test_get_values() {
        DataObject obj = this.createFullFeature();
        Assert.assertEquals((Object)true, (Object)obj.getBoolean("boolean"));
        Assert.assertEquals((Object)"string", (Object)obj.getString("string"));
        Assert.assertEquals((Object)"blob", (Object)new String(obj.getBlob("blob")));
        Assert.assertEquals((double)Math.PI, (double)obj.getDouble("double"), (double)0.001);
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)obj.getInt("int"));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)obj.getLong("long"));
        Assert.assertTrue((boolean)obj.isNull("null"));
        Assert.assertTrue((boolean)(obj.getArray("array") instanceof DataArray));
        Assert.assertTrue((boolean)(obj.getObject("object") instanceof DataObject));
        obj.putObject("object", this.prototye.newObjectInstance());
        DataArray arr = this.createNewArray();
        arr.putString("array string");
        obj.putArray("array", arr);
    }

    @Test
    public void test_override_keys() {
        DataObject obj = this.createFullFeature();
        obj.putString("boolean", "string");
        obj.putString("blob", "string");
        obj.putString("double", "string");
        obj.putString("int", "string");
        obj.putString("long", "string");
        obj.putString("null", "string");
        obj.putString("array", "string");
        obj.putString("object", "string");
        Assert.assertEquals((Object)"string", (Object)obj.get("string"));
        Assert.assertEquals((Object)"string", (Object)obj.get("boolean"));
        Assert.assertEquals((Object)"string", (Object)obj.get("blob"));
        Assert.assertEquals((Object)"string", (Object)obj.get("double"));
        Assert.assertEquals((Object)"string", (Object)obj.get("int"));
        Assert.assertEquals((Object)"string", (Object)obj.get("long"));
        Assert.assertEquals((Object)"string", (Object)obj.get("null"));
        Assert.assertEquals((Object)"string", (Object)obj.get("array"));
        Assert.assertEquals((Object)"string", (Object)obj.get("object"));
    }

    protected DataArray createDeepArray() {
        DataArray root;
        DataArray next = root = this.createNewArray();
        for (int i = 0; i < 5; ++i) {
            DataArray now = this.createNewArray();
            next.putArray(now);
            next = now;
        }
        next.putString("string");
        return root;
    }

    @Test
    public void test_deep_arrays() {
        DataArray deep = this.createDeepArray();
        Assert.assertNotNull((Object)deep.getArray(0));
        Assert.assertNotNull((Object)deep.getArray(0).getArray(0));
        Assert.assertNotNull((Object)deep.getArray(0).getArray(0).getArray(0));
        Assert.assertNotNull((Object)deep.getArray(0).getArray(0).getArray(0).getArray(0));
        Assert.assertNotNull((Object)deep.getArray(0).getArray(0).getArray(0).getArray(0).getArray(0));
        Assert.assertEquals((Object)"string", (Object)deep.getArray(0).getArray(0).getArray(0).getArray(0).getArray(0).getString(0));
    }

    public DataArray createSampleArray() {
        DataArray arr = this.createNewArray();
        arr.putBoolean(true);
        arr.putInt(Integer.MIN_VALUE);
        arr.putLong(Long.MAX_VALUE);
        arr.putDouble(Math.PI);
        arr.putString("string");
        arr.putBlob("blob".getBytes());
        DataArray a = this.createNewArray();
        a.putString("array string");
        a.putString("array string");
        arr.putArray(a);
        DataObject obj = this.createNewObject();
        obj.putString("string", "obj string");
        arr.putObject(obj);
        arr.putNull();
        return arr;
    }

    public void assertFullFeaturedBounded(DataArray obj) {
        Assert.assertTrue((boolean)obj.isString(4));
        Assert.assertEquals((Object)"string", (Object)obj.getString(4));
        Assert.assertEquals((Object)"string", (Object)obj.optString(4));
        Assert.assertEquals((Object)"string", (Object)obj.optString(4, "hello"));
        Assert.assertNull((Object)obj.optString(24));
        Assert.assertTrue((boolean)obj.isBlob(5));
        Assert.assertArrayEquals((byte[])"blob".getBytes(), (byte[])obj.getBlob(5));
        Assert.assertArrayEquals((byte[])"blob".getBytes(), (byte[])obj.optBlob(5));
        Assert.assertArrayEquals((byte[])"blob".getBytes(), (byte[])obj.optBlob(5, new byte[]{10}));
        Assert.assertTrue((boolean)obj.isBoolean(0));
        Assert.assertTrue((boolean)obj.getBoolean(0));
        Assert.assertTrue((boolean)obj.optBoolean(0));
        Assert.assertTrue((boolean)obj.optBoolean(0, false));
        Assert.assertNull((Object)obj.optBoolean(20));
        Assert.assertTrue((boolean)obj.isDouble(3));
        Assert.assertEquals((double)Math.PI, (double)obj.getDouble(3), (double)1.0E-8);
        Assert.assertEquals((double)Math.PI, (double)obj.optDouble(3), (double)1.0E-8);
        Assert.assertEquals((double)Math.PI, (double)obj.optDouble(3, -1.0), (double)1.0E-8);
        Assert.assertNull((Object)obj.optDouble(32));
        Assert.assertTrue((boolean)obj.isInt(1));
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)obj.getInt(1));
        Assert.assertEquals((Object)Integer.MIN_VALUE, (Object)obj.optInt(1));
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)obj.optInt(1, 10));
        Assert.assertNull((Object)obj.optInt(21));
        Assert.assertTrue((boolean)obj.isLong(2));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)obj.getLong(2));
        Assert.assertEquals((Object)Long.MAX_VALUE, (Object)obj.optLong(2));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)obj.optLong(2, 10L));
        Assert.assertNull((Object)obj.optLong(22));
        Assert.assertTrue((boolean)obj.isNull(8));
        Assert.assertTrue((boolean)obj.isObject(7));
        Assert.assertTrue((boolean)(obj.getObject(7) instanceof DataObject));
        Assert.assertTrue((boolean)(obj.optObject(7) instanceof DataObject));
        Assert.assertTrue((boolean)(obj.optObject(7, null) instanceof DataObject));
        DataObject o = obj.getObject(7);
        Assert.assertTrue((boolean)o.isString("string"));
        Assert.assertTrue((boolean)o.has("string"));
        Assert.assertEquals((Object)"obj string", (Object)o.getString("string"));
        Assert.assertNull((Object)o.optString("none"));
        Assert.assertTrue((boolean)obj.isArray(6));
        Assert.assertTrue((boolean)(obj.getArray(6) instanceof DataArray));
        Assert.assertTrue((boolean)(obj.optArray(6) instanceof DataArray));
        Assert.assertTrue((boolean)(obj.optArray(6, this.createNewArray()) instanceof DataArray));
        Assert.assertNull((Object)obj.optArray(26));
        DataArray arr = obj.getArray(6);
        Assert.assertEquals((Object)"array string", (Object)arr.getString(0));
        Assert.assertEquals((Object)"array string", (Object)arr.getString(1));
        Assert.assertEquals((long)9L, (long)obj.size());
    }

    public void assertFullFeaturedUnbounded(DataArray obj) {
        Assert.assertEquals((Object)"string", (Object)obj.get(4));
        Object blob = obj.get(5);
        if (blob instanceof String) {
            Assert.assertEquals((Object)"YmxvYg==", (Object)blob);
        } else {
            Assert.assertArrayEquals((byte[])"blob".getBytes(), (byte[])((byte[])blob));
        }
        Assert.assertEquals((Object)Boolean.TRUE, (Object)CastTo.Boolean.cast(obj.get(0)));
        Assert.assertEquals((double)Math.PI, (double)((Double)CastTo.Double.cast(obj.get(3))), (double)1.0E-8);
        Assert.assertEquals((Object)Integer.MIN_VALUE, (Object)CastTo.Int.cast((Object)obj.getInt(1)));
        Assert.assertEquals((Object)Long.MAX_VALUE, (Object)CastTo.Long.cast((Object)obj.getLong(2)));
        Assert.assertTrue((boolean)obj.isNull(8));
        Assert.assertTrue((boolean)(obj.get(7) instanceof DataObject));
        Assert.assertTrue((boolean)(obj.opt(7) instanceof DataObject));
        Assert.assertTrue((boolean)(obj.optObject(7) instanceof DataObject));
        DataObject o = (DataObject)obj.get(7);
        Assert.assertTrue((boolean)o.isString("string"));
        Assert.assertTrue((boolean)o.has("string"));
        Assert.assertEquals((Object)"obj string", (Object)o.get("string"));
        Assert.assertEquals((Object)"obj string", (Object)o.opt("string"));
        Assert.assertEquals((Object)"obj string", (Object)o.opt("string", (Object)"hello"));
        Assert.assertNull((Object)o.optString("none"));
        Assert.assertTrue((boolean)(obj.get(6) instanceof DataArray));
        Assert.assertTrue((boolean)(obj.opt(6) instanceof DataArray));
        DataArray arr = (DataArray)obj.get(6);
        Assert.assertEquals((Object)"array string", (Object)arr.get(0));
    }

    public void assertAsJavaArray(DataArray obj) {
        List java = obj.asJavaList();
        Assert.assertEquals((Object)"string", java.get(4));
        Assert.assertEquals((Object)CollectionTools.inlineArrayList((Object[])new String[]{"array string", "array string"}), java.get(6));
        Object blob = java.get(5);
        if (blob instanceof byte[]) {
            Assert.assertArrayEquals((byte[])"blob".getBytes(), (byte[])((byte[])blob));
        } else {
            Assert.assertEquals((Object)"YmxvYg==", blob);
        }
        Assert.assertEquals((Object)Boolean.TRUE, (Object)CastTo.Boolean.cast(java.get(0)));
        Assert.assertEquals((Object)Math.PI, (Object)CastTo.Double.cast(java.get(3)));
        Assert.assertEquals((Object)Integer.MIN_VALUE, (Object)CastTo.Int.cast(java.get(1)));
        Assert.assertEquals((Object)Long.MAX_VALUE, (Object)CastTo.Long.cast(java.get(2)));
        Assert.assertEquals((Object)"obj string", ((Map)java.get(7)).get("string"));
        Assert.assertNull(java.get(8));
    }

    @Test
    public void test_array_types_comes_back() {
        DataArray full = this.createSampleArray();
        this.assertFullFeaturedBounded(full);
        this.assertAsJavaArray(full);
    }

    public static DataArray virtualTransfer1(DataArray obj) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        obj.sendDataArray(obj, (OutputStream)baos);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        return obj.receiveDataArray((InputStream)bais);
    }

    public static DataArray virtualTransfer2(DataCommon comm, DataArray arr) throws IOException {
        byte[] data = arr.toBlob();
        return comm.arrayFromBlob(data);
    }

    public static DataArray virtualTransfer3(DataCommon comm, DataArray arr) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataSender sender = comm.newDataSender((OutputStream)baos);
        sender.send(arr);
        baos.flush();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        DataReceiver rec = comm.newDataReceiver((InputStream)bais);
        return rec.receiveDataArray((InputStream)bais);
    }

    @Test
    public void test_array_send_receive_basic_bound_1() throws IOException {
        DataArray ret = DataReprezTest.virtualTransfer1(this.createSampleArray());
        this.assertFullFeaturedBounded(ret);
        this.assertAsJavaArray(ret);
    }

    @Test
    public void test_array_send_receive_basic_unbound_1() throws IOException {
        DataArray ret = DataReprezTest.virtualTransfer1(this.createSampleArray());
        this.assertFullFeaturedUnbounded(ret);
        this.assertAsJavaArray(ret);
    }

    @Test
    public void test_array_send_receive_basic_bound_2() throws IOException {
        DataArray ret = DataReprezTest.virtualTransfer2(this.prototye, this.createSampleArray());
        this.assertFullFeaturedBounded(ret);
        this.assertAsJavaArray(ret);
    }

    @Test
    public void test_array_send_receive_basic_unbound_2() throws IOException {
        DataArray ret = DataReprezTest.virtualTransfer2(this.prototye, this.createSampleArray());
        this.assertFullFeaturedUnbounded(ret);
        this.assertAsJavaArray(ret);
    }

    @Test
    public void test_array_send_receive_basic_bound_3() throws IOException {
        DataArray ret = DataReprezTest.virtualTransfer3(this.prototye, this.createSampleArray());
        this.assertFullFeaturedBounded(ret);
        this.assertAsJavaArray(ret);
    }

    @Test
    public void test_array_send_receive_basic_unbound_3() throws IOException {
        DataArray ret = DataReprezTest.virtualTransfer3(this.prototye, this.createSampleArray());
        this.assertFullFeaturedUnbounded(ret);
        this.assertAsJavaArray(ret);
    }

    @Test
    public void test_array_remove_nulls() {
        DataArray arr = this.createSampleArray();
        this.assertFullFeaturedBounded(arr);
        for (int i = 0; i < 9; ++i) {
            arr.unset(0);
        }
        Assert.assertEquals((long)0L, (long)arr.size());
    }

    @Test
    public void testArrayOptReturnsNull() {
        DataArray obj = this.createSampleArray();
        Assert.assertNull((Object)obj.opt(20));
        Assert.assertNull((Object)obj.optString(20));
        Assert.assertNull((Object)obj.optBlob(20));
        Assert.assertNull((Object)obj.optObject(20));
        Assert.assertNull((Object)obj.optArray(20));
    }

    @Test
    public void test_override_indexes() {
        DataArray arr = this.createSampleArray();
        arr.putString(0, "string");
        arr.putString(1, "string");
        arr.putString(2, "string");
        arr.putString(3, "string");
        arr.putString(4, "string");
        arr.putString(5, "string");
        arr.putString(6, "string");
        arr.putString(7, "string");
        Assert.assertEquals((Object)"string", (Object)arr.get(0));
        Assert.assertEquals((Object)"string", (Object)arr.get(1));
        Assert.assertEquals((Object)"string", (Object)arr.get(2));
        Assert.assertEquals((Object)"string", (Object)arr.get(3));
        Assert.assertEquals((Object)"string", (Object)arr.get(4));
        Assert.assertEquals((Object)"string", (Object)arr.get(5));
        Assert.assertEquals((Object)"string", (Object)arr.get(6));
        Assert.assertEquals((Object)"string", (Object)arr.get(7));
    }

    @Test
    public void test_add_deep_array() {
        DataObject root = this.prototye.newObjectInstance();
        DataArray arr = this.prototye.newArrayInstance();
        DataObject inner = this.prototye.newObjectInstance();
        inner.putString("name", "test");
        arr.putObject(inner);
        root.putArray("array", arr);
        Assert.assertEquals((Object)"test", (Object)root.getArray("array").getObject(0).get("name"));
    }

    @Test
    public void test_add_deep_array_transferred() throws IOException {
        DataObject root = this.prototye.newObjectInstance();
        DataArray arr = root.newArrayInstance();
        for (int i = 0; i < 3; ++i) {
            DataObject inner = arr.newObjectInstance();
            inner.putString("name", "test");
            arr.putObject(inner);
        }
        root.putArray("array.tag", arr);
        DataObject rec = DataReprezTest.virtualTransfer1(root);
        System.out.println(rec);
        Assert.assertEquals((Object)"test", (Object)rec.getArray("array.tag").getObject(0).get("name"));
    }

    @Test
    public void test_tool_put_values() {
        DataObject obj = this.createNewObject();
        Assert.assertEquals(String.class, (Object)DataReprezTools.put((DataObject)obj, (String)"string", (Object)"string"));
        DataArray arr = this.createNewArray();
        arr.putString("array string");
        arr.putString("array string");
        Assert.assertEquals(DataArray.class, (Object)DataReprezTools.put((DataObject)obj, (String)"array", (Object)arr));
        Assert.assertEquals(byte[].class, (Object)DataReprezTools.put((DataObject)obj, (String)"blob", (Object)"blob".getBytes()));
        Assert.assertEquals(Boolean.class, (Object)DataReprezTools.put((DataObject)obj, (String)"boolean", (Object)true));
        Assert.assertEquals(Double.class, (Object)DataReprezTools.put((DataObject)obj, (String)"double", (Object)Math.PI));
        Assert.assertEquals(Integer.class, (Object)DataReprezTools.put((DataObject)obj, (String)"int", (Object)Integer.MIN_VALUE));
        Assert.assertEquals(Long.class, (Object)DataReprezTools.put((DataObject)obj, (String)"long", (Object)Long.MAX_VALUE));
        Assert.assertEquals(Void.class, (Object)DataReprezTools.put((DataObject)obj, (String)"null", null));
        DataObject so = this.prototye.newObjectInstance();
        so.putString("string", "obj string");
        Assert.assertEquals(DataObject.class, (Object)DataReprezTools.put((DataObject)obj, (String)"object", (Object)so));
        this.assertFullFeaturedBounded(obj);
    }

    @Test
    public void test_serialization() {
        DataSerialisationTestObject sample = DataSerialisationTestObject.createSampleObject();
        DataObject ser = sample.serialize(this.prototye);
        Assert.assertEquals((Object)"Person name", (Object)ser.getString("name"));
        Assert.assertEquals((long)20L, (long)ser.getInt("age"));
        Assert.assertEquals((double)20.0, (double)ser.getDouble("lat"), (double)0.001);
        Assert.assertEquals((double)44.543, (double)ser.getDouble("lng"), (double)0.001);
        DataObject addr = ser.getObject("address");
        Assert.assertEquals((Object)"Hungary", (Object)addr.getString("country"));
        Assert.assertEquals((long)3030L, (long)addr.getInt("zip"));
        Assert.assertEquals((Object)"Main street", (Object)addr.getString("street"));
        DataArray nicks = ser.getArray("nicks");
        Assert.assertEquals((long)2L, (long)nicks.size());
        Assert.assertEquals((Object)"mr. mayday", (Object)nicks.getString(0));
        Assert.assertEquals((Object)"dr. doomsday", (Object)nicks.getString(1));
    }
}

