/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.datareprez.abstractImpl;

import eu.javaexperience.datareprez.DataArray;
import eu.javaexperience.datareprez.DataObject;
import eu.javaexperience.datareprez.DataReprezException;
import eu.javaexperience.datareprez.abstractImpl.DataProtocolAbstractImpl;
import eu.javaexperience.datareprez.convertFrom.DataReprezType;
import java.util.ArrayList;
import java.util.List;

public abstract class DataArrayAbstractImpl
extends DataProtocolAbstractImpl
implements DataArray {
    protected abstract <T> void setSubjectValue(int var1, Class<T> var2, T var3);

    protected <T> T getValueAs(int index, Class<T> retType, boolean mayNull) {
        if (this.size() < index) {
            return null;
        }
        T ret = this.getValueAs(index, retType);
        if (!mayNull && null == ret) {
            throw new DataReprezException("No value present under index: " + index);
        }
        if (this.isObjectNull(ret)) {
            return null;
        }
        return ret;
    }

    protected abstract <T> T getValueAs(int var1, Class<T> var2);

    protected <T> T getValueOpt(int index, Class<T> cls, T defaultValue) {
        T ret = this.getValueAs(index, cls, true);
        if (null != ret) {
            return ret;
        }
        return defaultValue;
    }

    @Override
    public void putString(int i, String val) {
        this.setSubjectValue(i, String.class, val);
    }

    @Override
    public void putLong(int i, long val) {
        this.setSubjectValue(i, Long.TYPE, val);
    }

    @Override
    public void putDouble(int i, double val) {
        this.setSubjectValue(i, Double.TYPE, val);
    }

    @Override
    public void putInt(int i, int val) {
        this.setSubjectValue(i, Integer.TYPE, val);
    }

    @Override
    public void putBoolean(int i, boolean val) {
        this.setSubjectValue(i, Boolean.TYPE, val);
    }

    @Override
    public void putObject(int i, DataObject val) {
        this.setSubjectValue(i, DataObject.class, val);
    }

    @Override
    public void putArray(int i, DataArray val) {
        this.setSubjectValue(i, DataArray.class, val);
    }

    @Override
    public void putNull(int i) {
        this.setSubjectValue(i, Void.TYPE, this.getProtocolHandler().getNullObject());
    }

    @Override
    public String getString(int i) {
        return this.getValueAs(i, String.class, false);
    }

    @Override
    public long getLong(int i) {
        return this.getValueAs(i, Long.TYPE, false);
    }

    @Override
    public double getDouble(int i) {
        return this.getValueAs(i, Double.class, false);
    }

    @Override
    public int getInt(int i) {
        return this.getValueAs(i, Integer.TYPE, false);
    }

    @Override
    public boolean getBoolean(int i) {
        return this.getValueAs(i, Boolean.TYPE, false);
    }

    @Override
    public DataObject getObject(int i) {
        return this.getValueAs(i, DataObject.class, false);
    }

    @Override
    public DataArray getArray(int i) {
        return this.getValueAs(i, DataArray.class, false);
    }

    @Override
    public String optString(int i) {
        return this.getValueAs(i, String.class, true);
    }

    @Override
    public Long optLong(int i) {
        return this.getValueAs(i, Long.TYPE, true);
    }

    @Override
    public Double optDouble(int i) {
        return this.getValueAs(i, Double.TYPE, true);
    }

    @Override
    public Integer optInt(int i) {
        return this.getValueAs(i, Integer.TYPE, true);
    }

    @Override
    public Boolean optBoolean(int i) {
        return this.getValueAs(i, Boolean.TYPE, true);
    }

    @Override
    public DataObject optObject(int i) {
        return this.getValueAs(i, DataObject.class, true);
    }

    @Override
    public DataArray optArray(int i) {
        return this.getValueAs(i, DataArray.class, true);
    }

    @Override
    public String optString(int i, String def) {
        return this.getValueOpt(i, String.class, def);
    }

    @Override
    public long optLong(int i, long def) {
        return this.getValueOpt(i, Long.TYPE, def);
    }

    @Override
    public double optDouble(int i, double val) {
        return this.getValueOpt(i, Double.TYPE, val);
    }

    @Override
    public int optInt(int i, int def) {
        return this.getValueOpt(i, Integer.TYPE, def);
    }

    @Override
    public boolean optBoolean(int i, boolean def) {
        return this.getValueOpt(i, Boolean.TYPE, def);
    }

    @Override
    public DataObject optObject(int i, DataObject def) {
        return this.getValueOpt(i, DataObject.class, def);
    }

    @Override
    public DataArray optArray(int i, DataArray def) {
        return this.getValueOpt(i, DataArray.class, def);
    }

    @Override
    public void unset(int i) {
        this.setSubjectValue(i, null, null);
    }

    @Override
    public boolean isString(int i) {
        return this.getValueAs(i, String.class, true) instanceof String;
    }

    @Override
    public boolean isLong(int i) {
        return this.getValueAs(i, Long.class, true) instanceof Long;
    }

    @Override
    public boolean isDouble(int i) {
        return this.getValueAs(i, Double.class, true) instanceof Double;
    }

    @Override
    public boolean isInt(int i) {
        return this.getValueAs(i, Integer.class, true) instanceof Integer;
    }

    @Override
    public boolean isBoolean(int i) {
        return this.getValueAs(i, Boolean.class, true) instanceof Boolean;
    }

    @Override
    public boolean isObject(int i) {
        return this.getValueAs(i, DataObject.class, true) instanceof DataObject;
    }

    @Override
    public boolean isArray(int i) {
        return this.getValueAs(i, DataArray.class, true) instanceof DataArray;
    }

    @Override
    public boolean isNull(int i) {
        return this.isObjectNull(this.opt(i));
    }

    @Override
    public void putString(String val) {
        this.setSubjectValue(this.size(), String.class, val);
    }

    @Override
    public void putLong(long val) {
        this.setSubjectValue(this.size(), Long.TYPE, val);
    }

    @Override
    public void putDouble(double val) {
        this.setSubjectValue(this.size(), Double.TYPE, val);
    }

    @Override
    public void putInt(int val) {
        this.setSubjectValue(this.size(), Integer.TYPE, val);
    }

    @Override
    public void putBoolean(boolean val) {
        this.setSubjectValue(this.size(), Boolean.TYPE, val);
    }

    @Override
    public void putObject(DataObject val) {
        this.setSubjectValue(this.size(), DataObject.class, val);
    }

    @Override
    public void putArray(DataArray val) {
        this.setSubjectValue(this.size(), DataArray.class, val);
    }

    @Override
    public void putNull() {
        this.setSubjectValue(this.size(), Void.TYPE, null);
    }

    public Object get(int key) {
        return this.getValueAs(key, null, false);
    }

    @Override
    public Object opt(int key) {
        return this.getValueAs(key, null, true);
    }

    @Override
    public Object opt(int key, Object obj) {
        Object o = this.opt(key);
        if (o == null) {
            return obj;
        }
        return o;
    }

    @Override
    public List<Object> asJavaList() {
        ArrayList<Object> ret = new ArrayList<Object>();
        int s = this.size();
        for (int i = 0; i < s; ++i) {
            Object curr = this.opt(i);
            if (curr instanceof DataArray) {
                ret.add(((DataArray)curr).asJavaList());
                continue;
            }
            if (curr instanceof DataObject) {
                ret.add(((DataObject)curr).asJavaMap());
                continue;
            }
            ret.add(curr);
        }
        return ret;
    }

    @Override
    public void putBlob(byte[] blob) {
        this.setSubjectValue(this.size(), byte[].class, blob);
    }

    @Override
    public void putBlob(int i, byte[] blob) {
        this.setSubjectValue(i, byte[].class, blob);
    }

    @Override
    public byte[] getBlob(int i) {
        return this.getValueAs(i, byte[].class, false);
    }

    @Override
    public byte[] optBlob(int i) {
        return this.getValueAs(i, byte[].class, true);
    }

    @Override
    public byte[] optBlob(int i, byte[] blob) {
        try {
            byte[] ret = this.getValueAs(i, byte[].class, true);
            if (null == ret) {
                return blob;
            }
            return ret;
        }
        catch (Exception e) {
            return blob;
        }
    }

    @Override
    public boolean isBlob(int i) {
        return this.getValueAs(i, byte[].class, true) instanceof byte[];
    }

    @Override
    public DataReprezType getDataReprezType() {
        return DataReprezType.ARRAY;
    }
}

