/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.datareprez.abstractImpl;

import eu.javaexperience.collection.map.SmallMap;
import eu.javaexperience.datareprez.DataArray;
import eu.javaexperience.datareprez.DataObject;
import eu.javaexperience.datareprez.DataReprezException;
import eu.javaexperience.datareprez.abstractImpl.DataProtocolAbstractImpl;
import eu.javaexperience.datareprez.convertFrom.DataReprezType;
import java.util.Map;

public abstract class DataObjectAbstractImpl
extends DataProtocolAbstractImpl
implements DataObject {
    protected abstract void setSubjectValue(String var1, Class<?> var2, Object var3);

    protected <T> T getValueAs(String key, Class<T> retType, boolean mayNull) {
        T ret = this.getValueAs(key, retType);
        if (!mayNull && null == ret && !this.has(key)) {
            throw new DataReprezException("No value present under key: " + key);
        }
        if (this.isObjectNull(ret)) {
            return null;
        }
        return ret;
    }

    protected abstract <T> T getValueAs(String var1, Class<T> var2);

    protected void deleteKey(String key) {
        this.setSubjectValue(key, Void.TYPE, null);
    }

    protected <T> T getValueOpt(String key, Class<T> retType, T defaultValue) {
        T ret = this.getValueAs(key, retType, true);
        if (this.isObjectNull(ret)) {
            return null;
        }
        if (null != ret) {
            return ret;
        }
        return defaultValue;
    }

    @Override
    public void putString(String key, String val) {
        this.setSubjectValue(key, String.class, val);
    }

    @Override
    public void putLong(String key, long val) {
        this.setSubjectValue(key, Long.TYPE, val);
    }

    @Override
    public void putDouble(String key, double val) {
        this.setSubjectValue(key, Double.TYPE, val);
    }

    @Override
    public void putInt(String key, int val) {
        this.setSubjectValue(key, Integer.TYPE, val);
    }

    @Override
    public void putBoolean(String key, boolean val) {
        this.setSubjectValue(key, Boolean.TYPE, val);
    }

    @Override
    public void putObject(String key, DataObject val) {
        this.setSubjectValue(key, DataObject.class, val);
    }

    @Override
    public void putNull(String key) {
        this.setSubjectValue(key, Void.TYPE, null);
    }

    @Override
    public void putArray(String key, DataArray val) {
        this.setSubjectValue(key, DataArray.class, val);
    }

    @Override
    public void putBlob(String key, byte[] blob) {
        this.setSubjectValue(key, byte[].class, blob);
    }

    @Override
    public String getString(String key) {
        return this.getValueAs(key, String.class, false);
    }

    @Override
    public long getLong(String key) {
        return this.getValueAs(key, Long.TYPE, false);
    }

    @Override
    public double getDouble(String key) {
        return this.getValueAs(key, Double.TYPE, false);
    }

    @Override
    public int getInt(String key) {
        return this.getValueAs(key, Integer.TYPE, false);
    }

    @Override
    public boolean getBoolean(String key) {
        return this.getValueAs(key, Boolean.TYPE, false);
    }

    @Override
    public DataObject getObject(String key) {
        return this.getValueAs(key, DataObject.class, false);
    }

    @Override
    public DataArray getArray(String key) {
        return this.getValueAs(key, DataArray.class, false);
    }

    @Override
    public byte[] getBlob(String key) {
        return this.getValueAs(key, byte[].class, false);
    }

    @Override
    public String optString(String key) {
        return this.getValueOpt(key, String.class, null);
    }

    @Override
    public Long optLong(String key) {
        return this.getValueOpt(key, Long.TYPE, null);
    }

    @Override
    public Double optDouble(String key) {
        return this.getValueOpt(key, Double.TYPE, null);
    }

    @Override
    public Integer optInt(String key) {
        return this.getValueOpt(key, Integer.TYPE, null);
    }

    @Override
    public Boolean optBoolean(String key) {
        return this.getValueOpt(key, Boolean.TYPE, null);
    }

    @Override
    public DataObject optObject(String key) {
        return this.getValueOpt(key, DataObject.class, null);
    }

    @Override
    public DataArray optArray(String key) {
        return this.getValueOpt(key, DataArray.class, null);
    }

    @Override
    public byte[] optBlob(String key) {
        return this.getValueOpt(key, byte[].class, null);
    }

    @Override
    public String optString(String key, String def) {
        return this.getValueOpt(key, String.class, def);
    }

    @Override
    public long optLong(String key, long def) {
        return this.getValueOpt(key, Long.TYPE, def);
    }

    @Override
    public double optDouble(String key, double def) {
        return this.getValueOpt(key, Double.TYPE, def);
    }

    @Override
    public int optInt(String key, int def) {
        return this.getValueOpt(key, Integer.TYPE, def);
    }

    @Override
    public boolean optBoolean(String key, boolean def) {
        return this.getValueOpt(key, Boolean.TYPE, def);
    }

    @Override
    public DataObject optObject(String key, DataObject def) {
        return this.getValueAs(key, DataObject.class, false);
    }

    @Override
    public DataArray optArray(String key, DataArray def) {
        return this.getValueAs(key, DataArray.class, true);
    }

    @Override
    public byte[] optBlob(String key, byte[] def) {
        try {
            return this.getValueOpt(key, byte[].class, def);
        }
        catch (Exception e) {
            return def;
        }
    }

    @Override
    public Object get(String key) {
        return this.getValueAs(key, Object.class, false);
    }

    @Override
    public Object opt(String key) {
        return this.getValueAs(key, Object.class, true);
    }

    @Override
    public Object opt(String key, Object o) {
        return this.getValueOpt(key, Object.class, o);
    }

    @Override
    public boolean has(String key) {
        return null != this.getValueAs(key, Object.class, true);
    }

    @Override
    public int size() {
        return this.keys().length;
    }

    @Override
    public boolean isString(String key) {
        return this.getValueAs(key, String.class, true) instanceof String;
    }

    @Override
    public boolean isLong(String key) {
        return this.getValueAs(key, Long.class, true) instanceof Long;
    }

    @Override
    public boolean isDouble(String key) {
        return this.getValueAs(key, Double.class, true) instanceof Double;
    }

    @Override
    public boolean isInt(String key) {
        return this.getValueAs(key, Integer.class, true) instanceof Integer;
    }

    @Override
    public boolean isBoolean(String key) {
        return this.getValueAs(key, Boolean.class, true) instanceof Boolean;
    }

    @Override
    public boolean isObject(String key) {
        return this.getValueAs(key, DataObject.class, true) instanceof DataObject;
    }

    @Override
    public boolean isArray(String key) {
        return this.getValueAs(key, DataArray.class, true) instanceof DataArray;
    }

    @Override
    public boolean isBlob(String key) {
        try {
            return this.getValueAs(key, byte[].class, true) instanceof byte[];
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean isNull(String key) {
        return this.isObjectNull(this.get(key));
    }

    @Override
    public Map<String, Object> asJavaMap() {
        SmallMap ret = new SmallMap();
        for (String k : this.keys()) {
            Object curr = this.getValueAs(k, null, false);
            if (curr instanceof DataArray) {
                ret.put(k, ((DataArray)curr).asJavaList());
                continue;
            }
            if (curr instanceof DataObject) {
                ret.put(k, ((DataObject)curr).asJavaMap());
                continue;
            }
            ret.put(k, curr);
        }
        return ret;
    }

    @Override
    public void remove(String key) {
        this.deleteKey(key);
    }

    @Override
    public DataReprezType getDataReprezType() {
        return DataReprezType.OBJECT;
    }
}

