/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.datareprez.javaImpl;

import eu.javaexperience.binary.FramedPacketCutter;
import eu.javaexperience.binary.PacketFramingTools;
import eu.javaexperience.datareprez.DataArray;
import eu.javaexperience.datareprez.DataCommon;
import eu.javaexperience.datareprez.DataCommonAbstractImpl;
import eu.javaexperience.datareprez.DataObject;
import eu.javaexperience.datareprez.abstractImpl.DataProtocol;
import eu.javaexperience.datareprez.convertFrom.DataReprezComponentTypes;
import eu.javaexperience.datareprez.javaImpl.DataArrayJavaImpl;
import eu.javaexperience.datareprez.javaImpl.DataObjectJavaImpl;
import eu.javaexperience.io.SerializationTools;
import eu.javaexperience.reflect.CastTo;
import eu.javaexperience.text.Format;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;

public abstract class DataCommonJavaImpl
extends DataCommonAbstractImpl {
    public static DataCommon PROTOTYPE = new DataObjectJavaImpl();
    public static final DataProtocol PROTOCOL = new DataProtocol(){

        @Override
        public void sendPacket(byte[] data, OutputStream os) throws IOException {
            os.write(PacketFramingTools.frameBytes((byte[])data, (byte)-1));
        }

        @Override
        public DataObject objectFromBlob(byte[] data) {
            return new DataObjectJavaImpl((Map)((Object)SerializationTools.deserializeFromBlob((byte[])data)));
        }

        @Override
        public DataObject newObjectInstance() {
            return new DataObjectJavaImpl();
        }

        @Override
        public DataArray newArrayInstance() {
            return new DataArrayJavaImpl();
        }

        @Override
        public Class getCommonsClass() {
            return Map.class;
        }

        @Override
        public DataArray arrayFromBlob(byte[] data) {
            return new DataArrayJavaImpl((List)((Object)SerializationTools.deserializeFromBlob((byte[])data)));
        }

        @Override
        public byte[] acquirePacket(InputStream is) throws IOException {
            return DataCommonJavaImpl.receiveData(is);
        }

        @Override
        public Object getNullObject() {
            return null;
        }
    };

    protected static byte[] receiveData(InputStream is) throws IOException {
        byte[][] rec = new byte[1][0];
        rec[0] = null;
        FramedPacketCutter cut = new FramedPacketCutter(-1, p -> {
            rec[0] = p;
        });
        byte[] read = new byte[1];
        while (null == rec[0]) {
            if (is.read(read, 0, 1) < 1) {
                return null;
            }
            cut.feedBytes(read, 1);
        }
        return rec[0];
    }

    public static <T> T castToType(Object o, Class<T> cls) {
        if (null != o) {
            DataReprezComponentTypes type;
            if (Object.class == cls || null == cls) {
                if (o instanceof Map) {
                    cls = DataObject.class;
                } else if (o instanceof List) {
                    cls = DataArray.class;
                } else {
                    return (T)o;
                }
            }
            if (null != (type = DataReprezComponentTypes.recognise(cls))) {
                switch (type) {
                    case Boolean: {
                        return (T)CastTo.Boolean.cast(o);
                    }
                    case DataArray: {
                        if (o instanceof DataArray) {
                            return (T)o;
                        }
                        return (T)new DataArrayJavaImpl((List)o);
                    }
                    case DataObject: {
                        if (o instanceof DataObject) {
                            return (T)o;
                        }
                        return (T)new DataObjectJavaImpl((Map)o);
                    }
                    case Double: {
                        return (T)CastTo.Double.cast(o);
                    }
                    case Integer: {
                        return (T)CastTo.Int.cast(o);
                    }
                    case Long: {
                        return (T)CastTo.Long.cast(o);
                    }
                    case NULL: {
                        return null;
                    }
                    case String: {
                        return (T)CastTo.String.cast(o);
                    }
                    case Blob: {
                        if (o instanceof byte[]) {
                            return (T)o;
                        }
                        if (!(o instanceof String)) break;
                        return (T)Format.base64Decode((String)((String)o));
                    }
                }
            }
            throw new RuntimeException("Unrecognised class type: " + cls);
        }
        return null;
    }

    public static Object wrapObjectToStore(Object val, Class valueType) {
        if (DataObject.class == valueType) {
            val = ((DataObjectJavaImpl)val).obj;
        } else if (DataArray.class == valueType) {
            val = ((DataArrayJavaImpl)val).arr;
        }
        return val;
    }
}

