/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.datareprez.jsonImpl;

import eu.javaexperience.datareprez.DataArray;
import eu.javaexperience.datareprez.DataCommonAbstractImpl;
import eu.javaexperience.datareprez.DataObject;
import eu.javaexperience.datareprez.abstractImpl.DataProtocol;
import eu.javaexperience.datareprez.convertFrom.DataReprezComponentTypes;
import eu.javaexperience.datareprez.jsonImpl.DataArrayJsonImpl;
import eu.javaexperience.datareprez.jsonImpl.DataObjectJsonImpl;
import eu.javaexperience.io.primitive.LineReader;
import eu.javaexperience.reflect.CastTo;
import eu.javaexperience.text.Format;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class DataCommonJsonImpl
extends DataCommonAbstractImpl {
    public static final DataProtocol PROTOCOL = new DataProtocol(){

        @Override
        public void sendPacket(byte[] data, OutputStream os) throws IOException {
            os.write(data);
            os.write(10);
        }

        @Override
        public byte[] acquirePacket(InputStream is) throws IOException {
            return LineReader.readLine((InputStream)is, (LineReader.LineMode)LineReader.LineMode.Unix).getBytes();
        }

        @Override
        public DataObject objectFromBlob(byte[] data) {
            return new DataObjectJsonImpl(new JSONObject(new String(data)));
        }

        @Override
        public DataObject newObjectInstance() {
            return new DataObjectJsonImpl();
        }

        @Override
        public DataArray newArrayInstance() {
            return new DataArrayJsonImpl();
        }

        @Override
        public Class getCommonsClass() {
            return JSONObject.class;
        }

        @Override
        public DataArray arrayFromBlob(byte[] data) {
            return new DataArrayJsonImpl(new JSONArray(new String(data)));
        }

        @Override
        public Object getNullObject() {
            return JSONObject.NULL;
        }
    };

    public static <T> T castToType(Object o, Class<T> cls) {
        if (null != o) {
            DataReprezComponentTypes type;
            if (Object.class == cls || null == cls) {
                if (o instanceof JSONObject) {
                    cls = DataObject.class;
                } else if (o instanceof JSONArray) {
                    cls = DataArray.class;
                } else {
                    return (T)o;
                }
            }
            if (null != (type = DataReprezComponentTypes.recognise(cls))) {
                switch (type) {
                    case Boolean: {
                        return (T)CastTo.Boolean.cast(o);
                    }
                    case DataArray: {
                        return (T)new DataArrayJsonImpl((JSONArray)o);
                    }
                    case DataObject: {
                        return (T)new DataObjectJsonImpl((JSONObject)o);
                    }
                    case Double: {
                        return (T)CastTo.Double.cast(o);
                    }
                    case Integer: {
                        return (T)CastTo.Int.cast(o);
                    }
                    case Long: {
                        return (T)CastTo.Long.cast(o);
                    }
                    case NULL: {
                        return null;
                    }
                    case String: {
                        return (T)CastTo.String.cast(o);
                    }
                    case Blob: {
                        if (o instanceof byte[]) {
                            return (T)o;
                        }
                        if (!(o instanceof String)) break;
                        return (T)Format.base64Decode((String)((String)o));
                    }
                }
            }
            throw new RuntimeException("Unrecognised class type: " + cls);
        }
        return null;
    }

    public static Object wrapObjectToStore(Object val, Class valueType) {
        if (DataObject.class == valueType) {
            val = ((DataObjectJsonImpl)val).obj;
        } else if (DataArray.class == valueType) {
            val = ((DataArrayJsonImpl)val).arr;
        } else if (null == val && Void.TYPE == valueType) {
            return JSONObject.NULL;
        }
        return val;
    }
}

