/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.datareprez.xmlImpl;

import eu.javaexperience.collection.NullCollection;
import eu.javaexperience.datareprez.abstractImpl.DataArrayAbstractImpl;
import eu.javaexperience.datareprez.abstractImpl.DataProtocol;
import eu.javaexperience.datareprez.convertFrom.DataReprezType;
import eu.javaexperience.datareprez.xmlImpl.DataCommonXmlImpl;
import eu.javaexperience.document.DocumentTools;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DataArrayXmlImpl
extends DataArrayAbstractImpl {
    protected Node node;
    protected String name;

    public DataArrayXmlImpl(String name, Node owner) {
        this.node = owner;
        this.name = name;
    }

    public DataArrayXmlImpl(Node owner) {
        this.node = owner;
        this.name = "DataReprezRoot";
    }

    public DataArrayXmlImpl() {
        this.node = DocumentTools.createEmptyDocument().createElement("DataReprezRoot");
        this.name = "DataReprezRoot";
        this.node.getOwnerDocument().appendChild(this.node);
    }

    protected int fillNodes(Collection<Node> dst) {
        NodeList nl = this.node.getChildNodes();
        int max = nl.getLength();
        int found = 0;
        for (int i = 0; i < max; ++i) {
            Node n = nl.item(i);
            if (!this.name.equals(n.getNodeName())) continue;
            ++found;
            dst.add(n);
        }
        return found;
    }

    @Override
    public Object getImpl() {
        return this.node;
    }

    @Override
    public Iterator<Object> iterator() {
        ArrayList<Node> ret = new ArrayList<Node>();
        this.fillNodes(ret);
        return ret.iterator();
    }

    @Override
    public DataReprezType getDataReprezType() {
        return DataReprezType.ARRAY;
    }

    @Override
    public Class getCommonsClass() {
        return Node.class;
    }

    @Override
    public byte[] toBlob() {
        return DataCommonXmlImpl.xmlToString(this.node).getBytes();
    }

    @Override
    protected <T> void setSubjectValue(int index, Class<T> cls, T value) {
        DataCommonXmlImpl.setSubjectValue(this.node, this.name, index, cls, value);
    }

    @Override
    protected <T> T getValueAs(int index, Class<T> retType) {
        return DataCommonXmlImpl.getValueAs(this.node, this.name, index, retType);
    }

    @Override
    protected DataProtocol getProtocolHandler() {
        return DataCommonXmlImpl.PROTOCOL;
    }

    public int size() {
        return this.fillNodes((Collection<Node>)NullCollection.INSTANCE);
    }

    public String toString() {
        return "DataArrayXmlImpl: " + this.name + ", " + DataCommonXmlImpl.xmlToString(this.node);
    }
}

