/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.datareprez.xmlImpl;

import eu.javaexperience.datareprez.DataArray;
import eu.javaexperience.datareprez.DataCommonAbstractImpl;
import eu.javaexperience.datareprez.DataObject;
import eu.javaexperience.datareprez.DataReprezTools;
import eu.javaexperience.datareprez.abstractImpl.DataProtocol;
import eu.javaexperience.datareprez.xmlImpl.DataArrayXmlImpl;
import eu.javaexperience.datareprez.xmlImpl.DataObjectXmlImpl;
import eu.javaexperience.document.DocumentTools;
import eu.javaexperience.interfaces.ObjectWithProperty;
import eu.javaexperience.io.primitive.LineReader;
import eu.javaexperience.reflect.CastTo;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.text.Format;
import eu.javaexperience.text.StringTools;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class DataCommonXmlImpl {
    static DataObjectXmlImpl objPrototype = new DataObjectXmlImpl();
    static DataArrayXmlImpl arrPrototype = new DataArrayXmlImpl();
    public static final String NODE_NAME_MARK_NEED_ADOPT = "DataReprezRoot";
    public static final String ATTRIBUTE_NAME_PREFIX = "-";
    public static final DataProtocol PROTOCOL = new DataProtocol(){

        @Override
        public void sendPacket(byte[] data, OutputStream os) throws IOException {
            os.write(data);
            os.write(10);
        }

        @Override
        public DataObject objectFromBlob(byte[] data) {
            return DataCommonXmlImpl.xmlObjectFromBlob(data);
        }

        @Override
        public DataObject newObjectInstance() {
            return new DataObjectXmlImpl();
        }

        @Override
        public DataArray newArrayInstance() {
            return new DataArrayXmlImpl();
        }

        @Override
        public Class getCommonsClass() {
            return Node.class;
        }

        @Override
        public DataArray arrayFromBlob(byte[] data) {
            return DataCommonXmlImpl.xmlArrayFromBlob(data);
        }

        @Override
        public byte[] acquirePacket(InputStream is) throws IOException {
            return LineReader.readByteLine((InputStream)is, (LineReader.LineMode)LineReader.LineMode.Unix);
        }

        @Override
        public Object getNullObject() {
            return null;
        }
    };

    public static DataArray xmlArrayFromBlob(byte[] data) {
        try {
            Document doc = DocumentTools.parseDocument((String)new String(data));
            return new DataArrayXmlImpl(doc.getFirstChild());
        }
        catch (Exception e) {
            Mirror.propagateAnyway((Throwable)e);
            return null;
        }
    }

    public static DataObject xmlObjectFromBlob(byte[] data) {
        try {
            Document doc = DocumentTools.parseDocument((String)new String(data));
            if (NODE_NAME_MARK_NEED_ADOPT.equals(doc.getFirstChild().getNodeName())) {
                return new DataObjectXmlImpl(doc.getFirstChild());
            }
            return new DataObjectXmlImpl(doc);
        }
        catch (Exception e) {
            Mirror.propagateAnyway((Throwable)e);
            return null;
        }
    }

    protected static void adoptNodeTo(Node dst, boolean childs, String name, Node src) {
        Document doc = DocumentTools.getOwnerDocument((Node)dst);
        if (childs) {
            DocumentTools.adoptAttributes((Document)doc, (Node)dst, (Node)src);
            NodeList nl = src.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                dst.appendChild(DataCommonXmlImpl.adoptOrCopy(doc, name, nl.item(i)));
            }
        } else {
            dst.appendChild(DataCommonXmlImpl.adoptOrCopy(doc, name, src));
        }
    }

    protected static Node adoptOrCopy(Document doc, String name, Node src) {
        if (null == name) {
            return DocumentTools.copyAttrAndAdopChilds((Document)doc, (Node)DataCommonXmlImpl.createTag(doc, src.getNodeName()), (Node)src);
        }
        return DocumentTools.copyAttrAndAdopChilds((Document)doc, (Node)DataCommonXmlImpl.createTag(doc, name), (Node)src);
    }

    protected static boolean needAdopt(Node node) {
        return NODE_NAME_MARK_NEED_ADOPT.equals(node.getNodeName());
    }

    public static void applyNodeValue(Node subject, Node n, String name, Class type, Object value) {
        if (null == value) {
            if (null == type) {
                subject.removeChild(n);
            } else {
                n.setTextContent("");
            }
            return;
        }
        if (value instanceof DataObjectXmlImpl) {
            DataObjectXmlImpl s = (DataObjectXmlImpl)value;
            DataCommonXmlImpl.adoptNodeTo(n, DataCommonXmlImpl.needAdopt(s.node), null, s.node);
        } else if (value instanceof DataObject) {
            DataObjectXmlImpl dst = new DataObjectXmlImpl(n);
            DataReprezTools.copyInto(dst, (ObjectWithProperty)((DataObject)value));
            DataCommonXmlImpl.applyNodeValue(subject, n, name, type, dst);
        } else {
            value = DataCommonAbstractImpl.wrapValueToStore(type, value);
            n.setTextContent(String.valueOf(value));
        }
    }

    protected static void keepSingleNode(Node subject, String name, Node keep) {
        NodeList nl = subject.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (!n.getNodeName().equals(name) || n.equals(keep)) continue;
            subject.removeChild(n);
            --i;
        }
    }

    protected static void setSubjectValue(Node xml, String nodeName, Object key, Class type, Object value) {
        String name = null;
        name = key instanceof String ? (String)key : nodeName;
        if (value instanceof DataArray) {
            String xKey;
            String string = xKey = null == nodeName ? name : nodeName;
            if (value instanceof DataArrayXmlImpl) {
                Document doc = DocumentTools.getOwnerDocument((Node)xml);
                DataArrayXmlImpl src = (DataArrayXmlImpl)value;
                if (null != nodeName) {
                    src.node = DataCommonXmlImpl.adoptOrCopy(doc, xKey, src.node);
                    xml.appendChild(src.node);
                    src.name = nodeName;
                } else {
                    DataCommonXmlImpl.deleteKey(xml, xKey);
                    NodeList cl = src.node.getChildNodes();
                    for (int i = 0; i < cl.getLength(); ++i) {
                        xml.appendChild(DataCommonXmlImpl.adoptOrCopy(doc, xKey, cl.item(i)));
                    }
                    src.node = xml;
                    src.name = xKey;
                }
            } else {
                DataArray src = (DataArray)value;
                DataArrayXmlImpl dst = new DataArrayXmlImpl(xKey, xml);
                DataReprezTools.copyInto(dst, src);
            }
        } else {
            Node node = DataCommonXmlImpl.getOrCreateSubjectValue(xml, nodeName, key, true);
            if (key instanceof String) {
                DataCommonXmlImpl.keepSingleNode(xml, name, node);
            }
            DataCommonXmlImpl.applyNodeValue(xml, node, name, type, value);
        }
    }

    protected static void deleteKey(Node node, String key) {
        boolean attr = key.startsWith(ATTRIBUTE_NAME_PREFIX);
        if (attr) {
            NamedNodeMap nm = node.getAttributes();
            key = StringTools.getSubstringAfterFirstString((String)key, (String)ATTRIBUTE_NAME_PREFIX);
            nm.removeNamedItem(key);
        } else {
            NodeList nl = node.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                Node n = nl.item(i);
                if (!n.getNodeName().equals(key)) continue;
                node.removeChild(n);
                --i;
            }
        }
    }

    public static Node createTag(Document doc, String name) {
        if (name.equals("#text")) {
            return doc.createTextNode("");
        }
        if (name.equals("#comment")) {
            return doc.createComment("");
        }
        return doc.createElement(name);
    }

    protected static int getNumberOfNodesWithName(Node node, String name) {
        int ret = 0;
        NodeList nl = node.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (!n.getNodeName().equals(name)) continue;
            ++ret;
        }
        return ret;
    }

    protected static <C> C getValueAs(Node node, String nodeName, Object _key, Class<C> cls) {
        int nums = DataCommonXmlImpl.getNumberOfNodesWithName(node, null == nodeName ? (String)_key : nodeName);
        if (0 == nums) {
            return null;
        }
        Node n = DataCommonXmlImpl.getOrCreateSubjectValue(node, nodeName, _key, false);
        if (null == cls || Object.class == cls) {
            if (nums > 1) {
                if (null == nodeName) {
                    return (C)new DataArrayXmlImpl((String)_key, node);
                }
                if (NODE_NAME_MARK_NEED_ADOPT.equals(nodeName) && n.getChildNodes().getLength() > 1) {
                    return (C)new DataArrayXmlImpl(nodeName, n);
                }
            }
            return (C)DataCommonXmlImpl.tryExamineOrWrapObject(n);
        }
        if (String.class == cls) {
            return (C)CastTo.String.cast((Object)n.getTextContent());
        }
        if (byte[].class == cls) {
            return (C)Format.base64Decode((String)((String)CastTo.String.cast((Object)n.getTextContent())));
        }
        if (Integer.TYPE == cls || Integer.class == cls) {
            return (C)CastTo.Int.cast((Object)n.getTextContent());
        }
        if (Long.TYPE == cls || Long.class == cls) {
            return (C)CastTo.Long.cast((Object)n.getTextContent());
        }
        if (Double.TYPE == cls || Double.class == cls) {
            return (C)CastTo.Double.cast((Object)n.getTextContent());
        }
        if (Boolean.TYPE == cls || Boolean.class == cls) {
            return (C)CastTo.Boolean.cast((Object)n.getTextContent());
        }
        if (DataObject.class == cls) {
            return (C)new DataObjectXmlImpl(n);
        }
        if (DataArray.class == cls) {
            if (_key instanceof String) {
                String key = (String)_key;
                boolean attr = key.startsWith(ATTRIBUTE_NAME_PREFIX);
                if (attr) {
                    NamedNodeMap nm = node.getAttributes();
                    Node ret = nm.getNamedItem(key = StringTools.getSubstringAfterFirstString((String)key, (String)ATTRIBUTE_NAME_PREFIX));
                    if (null != ret) {
                        return (C)new Node[]{ret};
                    }
                    return null;
                }
                return (C)new DataArrayXmlImpl(key, node);
            }
            return (C)new DataArrayXmlImpl(nodeName, n);
        }
        return null;
    }

    protected static Node getOrCreateSubjectValue(Node node, String nodeName, Object _key, boolean create) {
        boolean attr;
        String key = nodeName;
        if (null == nodeName) {
            key = (String)_key;
        }
        if (attr = key.startsWith(ATTRIBUTE_NAME_PREFIX)) {
            NamedNodeMap nm = node.getAttributes();
            Node ret = nm.getNamedItem(key = StringTools.getSubstringAfterFirstString((String)key, (String)ATTRIBUTE_NAME_PREFIX));
            if (null == ret && create) {
                ret = DocumentTools.getOwnerDocument((Node)node).createAttribute(key);
                nm.setNamedItem(ret);
            }
            return ret;
        }
        NodeList nl = node.getChildNodes();
        int ind = 0;
        if (_key instanceof Integer) {
            ind = (Integer)_key;
        }
        int crnt = 0;
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (!n.getNodeName().equals(key)) continue;
            if (crnt == ind) {
                return n;
            }
            ++crnt;
        }
        if (create) {
            Node add = null;
            add = key.equals("#text") ? DocumentTools.getOwnerDocument((Node)node).createTextNode("") : (key.equals("#comment") ? DocumentTools.getOwnerDocument((Node)node).createComment("") : DocumentTools.getOwnerDocument((Node)node).createElement(key));
            node.appendChild(add);
            return add;
        }
        return null;
    }

    public static Object tryExamineOrWrapObject(Node n) {
        NodeList ch = n.getChildNodes();
        switch (ch.getLength()) {
            case 0: {
                return null;
            }
            case 1: {
                if (!DocumentTools.isTextNode((Node)ch.item(0))) break;
                return n.getTextContent();
            }
        }
        return new DataObjectXmlImpl(n);
    }

    public static String xmlToString(Node node) {
        try {
            return DocumentTools.toString((Node)node);
        }
        catch (TransformerException e) {
            Mirror.propagateAnyway((Throwable)e);
            return null;
        }
    }
}

