/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.electronic.lcd.menu;

import eu.javaexperience.datareprez.DataCommon;
import eu.javaexperience.datareprez.DataObject;
import eu.javaexperience.electronic.lcd.menu.LcdDisplayState;
import eu.javaexperience.electronic.lcd.menu.LcdMenu;
import eu.javaexperience.electronic.lcd.menu.LcdMenuHost;
import eu.javaexperience.electronic.lcd.menu.input.InputEvent;
import eu.javaexperience.interfaces.simple.SimpleGet;
import eu.javaexperience.interfaces.simple.publish.SimplePublish1;

public class LcdTrailFrameMenu<L extends LcdMenu<L>>
implements LcdMenu<L> {
    protected String id;
    protected LcdMenuHost<L> host;
    protected int state = 0;
    protected long t0 = 0L;
    protected SimpleGet<LcdDisplayState> display;
    protected TrailFrame[] frames;

    public LcdTrailFrameMenu(String id, TrailFrame ... frames) {
        this.id = id;
        this.frames = frames;
    }

    protected void executeFrame() {
        if (this.state < this.frames.length && null != this.frames[this.state].enterState) {
            this.frames[this.state].enterState.publish((Object)this);
        }
    }

    protected void checkStepFrame() {
        if (this.state < this.frames.length && System.currentTimeMillis() >= this.t0 + (long)this.frames[this.state].timeToShow) {
            ++this.state;
            this.t0 = System.currentTimeMillis();
            this.executeFrame();
        }
    }

    @Override
    public void init(LcdMenuHost host) {
        this.host = host;
        this.state = 0;
        this.t0 = System.currentTimeMillis();
        this.executeFrame();
    }

    @Override
    public DataObject saveState(DataCommon proto) {
        return proto.newObjectInstance();
    }

    @Override
    public void restoreState(DataObject from) {
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void dispose() {
    }

    @Override
    public void refresh() {
        this.checkStepFrame();
        this.host.setDisplayState((LcdDisplayState)this.display.get());
    }

    @Override
    public boolean canEnter() {
        return true;
    }

    public void publish(InputEvent a) {
    }

    public void setDisplay(SimpleGet<LcdDisplayState> display) {
        this.display = display;
    }

    public static class TrailFrame {
        protected int timeToShow;
        protected SimplePublish1<LcdTrailFrameMenu> enterState;

        public TrailFrame(SimplePublish1<LcdTrailFrameMenu> enterState, int timeToShow) {
            this.timeToShow = timeToShow;
            this.enterState = enterState;
        }
    }
}

