/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.electronic.lcd.menu;

import eu.javaexperience.datareprez.DataCommon;
import eu.javaexperience.datareprez.DataObject;
import eu.javaexperience.electronic.lcd.menu.InputEventNavigationInterpreter;
import eu.javaexperience.electronic.lcd.menu.LcdDisplayState;
import eu.javaexperience.electronic.lcd.menu.LcdMenu;
import eu.javaexperience.electronic.lcd.menu.LcdMenuHost;
import eu.javaexperience.electronic.lcd.menu.input.InputEvent;
import eu.javaexperience.interfaces.simple.SimpleGet;
import eu.javaexperience.math.MathTools;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class LcdSpinnerMenu<L extends LcdMenu<L>>
implements LcdMenu<L> {
    protected LcdMenuHost<L> host;
    protected int index = 0;
    protected SimpleGet<L> back;
    protected List<Map.Entry<SimpleGet<LcdDisplayState>, SimpleGet<L>>> menuEntries = new ArrayList<Map.Entry<SimpleGet<LcdDisplayState>, SimpleGet<L>>>();
    protected InputEventNavigationInterpreter nav;

    public LcdSpinnerMenu(InputEventNavigationInterpreter nav) {
        this.nav = nav;
    }

    public List<Map.Entry<SimpleGet<LcdDisplayState>, SimpleGet<L>>> getRwMenuEntries() {
        return this.menuEntries;
    }

    public void publish(InputEvent a) {
        if (null != this.back && this.nav.isBack(a)) {
            this.host.enterMenu((LcdMenu)this.back.get());
        } else if (this.nav.isUp(a)) {
            this.setIndex(this.index - 1 <= 0 ? this.menuEntries.size() - 1 : this.index - 1);
        } else if (this.nav.isDown(a)) {
            this.setIndex(this.index + 1 >= this.menuEntries.size() ? 0 : this.index + 1);
        } else if (this.nav.isSelect(a) && null != this.menuEntries.get(this.index).getValue()) {
            this.host.enterMenu((LcdMenu)this.menuEntries.get(this.index).getValue().get());
        }
    }

    @Override
    public void init(LcdMenuHost<L> host) {
        this.host = host;
        this.setIndex(0);
    }

    public void setIndex(int index) {
        this.index = MathTools.clamp((int)0, (int)index, (int)(this.menuEntries.size() - 1));
        this.refresh();
    }

    @Override
    public DataObject saveState(DataCommon proto) {
        DataObject ret = proto.newObjectInstance();
        ret.putInt("index", this.index);
        return ret;
    }

    @Override
    public void restoreState(DataObject from) {
        this.setIndex(from.optInt("index", 0));
    }

    @Override
    public void dispose() {
    }

    public void setBackMenu(SimpleGet<L> back) {
        this.back = back;
    }

    @Override
    public void refresh() {
        SimpleGet<LcdDisplayState> cre = this.menuEntries.get(this.index).getKey();
        if (null != cre) {
            this.host.setDisplayState((LcdDisplayState)cre.get());
        }
    }
}

