package eu.javaexperience.electronic.lcd;

import java.util.HashMap;
import java.util.Map;

import eu.javaexperience.interfaces.simple.getBy.GetBy1;

/**
 * Monochrome LCD character that consist of 5 columns and 8 rows.
 * */
public class Lcd58Chars
{
	public enum Lcd58AsciiChars implements Lcd8Char
	{
		SPACE
		(
			' ',
			new byte[]
			{
				0b00000,
				0b00000,
				0b00000,
				0b00000,
				0b00000,
				0b00000,
				0b00000,
				0b00000
			}
		),
		
		EXCLAMATION
		(
			'!',
			new byte[]
			{
				0b00100,
				0b00100,
				0b00100,
				0b00100,
				0b00100,
				0b00100,
				0b00000,
				0b00100
			}
		),
		
		QUOTATION
		(
			'"',
			new byte[]
			{
				0b01010,
				0b01010,
				0b00000,
				0b00000,
				0b00000,
				0b00000,
				0b00000,
				0b00000
			}
		),
		
		HASHMARK
		(
			'#',
			new byte[]
			{
				0b01010,
				0b01010,
				0b11111,
				0b01010,
				0b01010,
				0b11111,
				0b01010,
				0b01010
			}
		),
		
		DOLLAR
		(
			'$',
			new byte[]
			{
				0b00000,
				0b00100,
				0b01111,
				0b10100,
				0b01110,
				0b00101,
				0b11110,
				0b00100
			}
		),
		
		PERCENTAGE
		(
			'%',
			new byte[]
			{
				0b00000,
				0b00000,
				0b11000,
				0b11010,
				0b00100,
				0b01000,
				0b10110,
				0b00110
			}
		),
		
		AND
		(
			'&',
			new byte[]
			{
				0b00000,
				0b01100,
				0b10010,
				0b10100,
				0b01000,
				0b10101,
				0b10010,
				0b01101
			}
		),
		
		APOSTROPHE
		(
			'\'',
			new byte[]
			{
				0b00110,
				0b00010,
				0b00100,
				0b00000,
				0b00000,
				0b00000,
				0b00000,
				0b00000
			}
		),
		
		PARENTHESIS_OPEN
		(
			'(',
			new byte[]
			{
				0b00000,
				0b00010,
				0b00100,
				0b01000,
				0b01000,
				0b01000,
				0b00100,
				0b00010
			}
		),
		
		PARENTHESIS_CLOSE
		(
			')',
			new byte[]
			{
				0b00000,
				0b01000,
				0b00100,
				0b00010,
				0b00010,
				0b00010,
				0b00100,
				0b01000
			}
		),
		
		START
		(
			'*',
			new byte[]
			{
				0b00000,
				0b00000,
				0b00100,
				0b10101,
				0b01110,
				0b10101,
				0b00100,
				0b00000
			}
		),
		
		PLUS
		(
			'+',
			new byte[]
			{
				0b00000,
				0b00000,
				0b00100,
				0b00100,
				0b01110,
				0b00100,
				0b00100,
				0b00000
			}
		),
		
		COMMA
		(
			',',
			new byte[]
			{
				0b00000,
				0b00000,
				0b00000,
				0b00000,
				0b00000,
				0b00110,
				0b00110,
				0b01000
			}
		),
		
		MINUS
		(
			'-',
			new byte[]
			{
				0b00000,
				0b00000,
				0b00000,
				0b00000,
				0b11110,
				0b00000,
				0b00000,
				0b00000
			}
		),
		
		DOT
		(
			'.',
			new byte[]
			{
				0b00000,
				0b00000,
				0b00000,
				0b00000,
				0b00000,
				0b00000,
				0b01100,
				0b01100
			}
		),
		
		SLASH
		(
			'/',
			new byte[]
			{
				0b00000,
				0b00001,
				0b00001,
				0b00010,
				0b00100,
				0b01000,
				0b10000,
				0b10000
			}
		),
		
		
		COLON
		(
			':',
			new byte[]
			{
				0b00000,
				0b00000,
				0b00110,
				0b00110,
				0b00000,
				0b00110,
				0b00110,
				0b00000
			}
		),
		
		SEMICOLON
		(
			';',
			new byte[]
			{
				0b00000,
				0b00000,
				0b00110,
				0b00110,
				0b00000,
				0b00110,
				0b00110,
				0b00100
			}
		),
		
		LASS_THAN
		(
			'<',
			new byte[]
			{
				0b00000,
				0b00010,
				0b00100,
				0b01000,
				0b10000,
				0b01000,
				0b00100,
				0b00010
			}
		),
		
		EQUALS
		(
			'=',
			new byte[]
			{
				0b00000,
				0b00000,
				0b00000,
				0b11111,
				0b00000,
				0b11111,
				0b00000,
				0b00000
			}
		),
		
		GREATER_THAN
		(
			'>',
			new byte[]
			{
				0b00000,
				0b01000,
				0b00100,
				0b00010,
				0b00001,
				0b00010,
				0b00100,
				0b01000
			}
		),
		
		QUESTION_MARK
		(
			'?',
			new byte[]
			{
				0b00000,
				0b01110,
				0b10001,
				0b00001,
				0b00010,
				0b00100,
				0b00000,
				0b00100
			}
		),
		
		AT
		(
			'@',
			new byte[]
			{
				0b00000,
				0b00000,
				0b01110,
				0b10001,
				0b10101,
				0b10111,
				0b10000,
				0b01110
			}
		),
		
		BRACKET_OPEN
		(
			'[',
			new byte[]
			{
				0b00000,
				0b01110,
				0b01000,
				0b01000,
				0b01000,
				0b01000,
				0b01000,
				0b01110
			}
		),
		
		BACK_SLASH
		(
			'\\',
			new byte[]
			{
				0b00000,
				0b00000,
				0b00000,
				0b10000,
				0b01000,
				0b00100,
				0b00010,
				0b00001
			}
		),
		
		BRACKET_CLOSE
		(
			']',
			new byte[]
			{
				0b00000,
				0b01110,
				0b00010,
				0b00010,
				0b00010,
				0b00010,
				0b00010,
				0b01110
			}
		),
		
		POWER
		(
			'^',
			new byte[]
			{
				0b00100,
				0b01010,
				0b10001,
				0b00000,
				0b00000,
				0b00000,
				0b00000,
				0b00000
			}
		),
		
		UNDERSCORE
		(
			'_',
			new byte[]
			{
				0b00000,
				0b00000,
				0b00000,
				0b00000,
				0b00000,
				0b00000,
				0b00000,
				0b11111
			}
		),
		
		BACK_APOSTROPHE
		(
			'`',
			new byte[]
			{
				0b01000,
				0b00100,
				0b00010,
				0b00000,
				0b00000,
				0b00000,
				0b00000,
				0b00000
			}
		),
		
		BRACE_OPEN
		(
			'{',
			new byte[]
			{
				0b00000,
				0b00010,
				0b00100,
				0b00100,
				0b01000,
				0b00100,
				0b00100,
				0b00010
			}
		),
		
		PIPELINE
		(
			'|',
			new byte[]
			{
				0b00100,
				0b00100,
				0b00100,
				0b00100,
				0b00100,
				0b00100,
				0b00100,
				0b00100
			}
		),
		
		BRACE_CLOSE
		(
			'}',
			new byte[]
			{
				0b00000,
				0b01000,
				0b00100,
				0b00100,
				0b00010,
				0b00100,
				0b00100,
				0b01000
			}
		),
		
		TILDE
		(
			'~',
			new byte[]
			{
				0b00000,
				0b00000,
				0b00000,
				0b00000,
				0b01001,
				0b10110,
				0b00000,
				0b00000
			}
		),
		
		_0
		(
			'0',
			new byte[]
			{
				0b00000,
				0b01110,
				0b10001,
				0b10011,
				0b10101,
				0b11001,
				0b10001,
				0b01110
			}
		),
		
		_1
		(
			'1',
			new byte[]
			{
				0b00000,
				0b00100,
				0b01100,
				0b00100,
				0b00100,
				0b00100,
				0b00100,
				0b01110
			}
		),
		
		_2
		(
			'2',
			new byte[]
			{
				0b00000,
				0b01100,
				0b10010,
				0b00010,
				0b00100,
				0b01000,
				0b10000,
				0b11110
			}
		),
		
		_3
		(
			'3',
			new byte[]
			{
				0b00000,
				0b11100,
				0b00010,
				0b00010,
				0b01100,
				0b00010,
				0b00010,
				0b11100
			}
		),
		
		_4
		(
			'4',
			new byte[]
			{
				0b00000,
				0b00100,
				0b01100,
				0b10100,
				0b10100,
				0b11110,
				0b00100,
				0b00100
			}
		),
		
		_5
		(
			'5',
			new byte[]
			{
				0b00000,
				0b11110,
				0b10000,
				0b11100,
				0b10010,
				0b00010,
				0b10010,
				0b01100
			}
		),
		
		_6
		(
			'6',
			new byte[]
			{
				0b00000,
				0b01100,
				0b10010,
				0b10000,
				0b11100,
				0b10010,
				0b10010,
				0b01100
			}
		),
		
		_7
		(
			'7',
			new byte[]
			{
				0b00000,
				0b11110,
				0b00010,
				0b00100,
				0b00100,
				0b0100,
				0b01000,
				0b01000
			}
		),
		
		_8
		(
			'8',
			new byte[]
			{
				0b00000,
				0b01100,
				0b10010,
				0b10010,
				0b01100,
				0b10010,
				0b10010,
				0b01100
			}
		),
		
		_9
		(
			'9',
			new byte[]
			{
				0b00000,
				0b01100,
				0b10010,
				0b10010,
				0b01110,
				0b00010,
				0b10010,
				0b01100
			}
		),
		
		a
		(
			'a',
			new byte[]
			{
				0b00000,
				0b00000,
				0b00000,
				0b01110,
				0b00001,
				0b01111,
				0b10001,
				0b01111
			}
		),
		
		b
		(
			'b',
			new byte[]
			{
				0b00000,
				0b00000,
				0b10000,
				0b10000,
				0b11100,
				0b10010,
				0b10010,
				0b11100
			}
		),
		
		c
		(
			'c',
			new byte[]
			{
				0b00000,
				0b00000,
				0b00000,
				0b01100,
				0b10010,
				0b10000,
				0b10010,
				0b01100
			}
		),
		
		d
		(
			'd',
			new byte[]
			{
				0b00000,
				0b00000,
				0b00010,
				0b00010,
				0b01110,
				0b10010,
				0b10010,
				0b01110
			}
		),
		
		e
		(
			'e',
			new byte[]
			{
				0b00000,
				0b00000,
				0b00000,
				0b01100,
				0b10010,
				0b11110,
				0b10000,
				0b01100
			}
		),
		
		f
		(
			'f',
			new byte[]
			{
				0b00000,
				0b00000,
				0b01100,
				0b01000,
				0b11100,
				0b01000,
				0b01000,
				0b01000
			}
		),
		
		g
		(
			'g',
			new byte[]
			{
				0b00000,
				0b00000,
				0b01100,
				0b10010,
				0b10010,
				0b01110,
				0b00010,
				0b01100
			}
		),
		
		h
		(
			'h',
			new byte[]
			{
				0b00000,
				0b00000,
				0b10000,
				0b10000,
				0b11100,
				0b10010,
				0b10010,
				0b10010
			}
		),
		
		i
		(
			'i',
			new byte[]
			{
				0b00000,
				0b00000,
				0b00100,
				0b00000,
				0b00100,
				0b00100,
				0b00100,
				0b00100
			}
		),
		
		j
		(
			'j',
			new byte[]
			{
				0b00000,
				0b00000,
				0b00100,
				0b00000,
				0b00100,
				0b00100,
				0b10100,
				0b01000
			}
		),
		
		k
		(
			'k',
			new byte[]
			{
				0b00000,
				0b00000,
				0b10000,
				0b10010,
				0b10100,
				0b11000,
				0b10100,
				0b10010
			}
		),
		
		l
		(
			'l',
			new byte[]
			{
				0b00000,
				0b00000,
				0b11000,
				0b01000,
				0b01000,
				0b01000,
				0b01000,
				0b00100
			}
		),
		
		m
		(
			'm',
			new byte[]
			{
				0b00000,
				0b00000,
				0b00000,
				0b11010,
				0b10101,
				0b10101,
				0b10101,
				0b10101
				
			}
		),
		
		n
		(
			'n',
			new byte[]
			{
				0b00000,
				0b00000,
				0b00000,
				0b10110,
				0b11001,
				0b10001,
				0b10001,
				0b10001
			}
		),
		
		o
		(
			'o',
			new byte[]
			{
				0b00000,
				0b00000,
				0b00000,
				0b01110,
				0b10001,
				0b10001,
				0b10001,
				0b01110
			}
		),
		
		p
		(
			'p',
			new byte[]
			{
				0b00000,
				0b00000,
				0b00000,
				0b11100,
				0b10010,
				0b10010,
				0b11100,
				0b10000
			}
		),
		
		q
		(
			'q',
			new byte[]
			{
				0b00000,
				0b00000,
				0b00000,
				0b01010,
				0b10110,
				0b10010,
				0b01110,
				0b00010
			}
		),

		r
		(
			'r',
			new byte[]
			{
				0b00000,
				0b00000,
				0b00000,
				0b10100,
				0b11010,
				0b10000,
				0b10000,
				0b10000
			}
		),

		s
		(
			's',
			new byte[]
			{
				0b00000,
				0b00000,
				0b00000,
				0b01110,
				0b10000,
				0b01100,
				0b00010,
				0b11100
			}
		),

		t
		(
			't',
			new byte[]
			{
				0b00000,
				0b00000,
				0b10000,
				0b11000,
				0b10000,
				0b10000,
				0b10010,
				0b01100
			}
		),

		u
		(
			'u',
			new byte[]
			{
				0b00000,
				0b00000,
				0b00000,
				0b10010,
				0b10010,
				0b10010,
				0b10110,
				0b11010
			}
		),

		v
		(
			'v',
			new byte[]
			{
				0b00000,
				0b00000,
				0b00000,
				0b10001,
				0b10001,
				0b01010,
				0b01010,
				0b00100
			}
		),

		w
		(
			'w',
			new byte[]
			{
				0b00000,
				0b00000,
				0b00000,
				0b10101,
				0b10101,
				0b10101,
				0b10101,
				0b01010
			}
		),

		x
		(
			'x',
			new byte[]
			{
				0b00000,
				0b00000,
				0b00000,
				0b10001,
				0b01010,
				0b00100,
				0b01010,
				0b10001,
			}
		),

		y
		(
			'y',
			new byte[]
			{
				0b00000,
				0b00000,
				0b00000,
				0b10010,
				0b10010,
				0b01110,
				0b00010,
				0b01100
			}
		),

		z
		(
			'z',
			new byte[]
			{
				0b00000,
				0b00000,
				0b00000,
				0b11111,
				0b00010,
				0b00100,
				0b01000,
				0b11111
			}
		),

		A
		(
			'A',
			new byte[]
			{
				0b01110,
				0b10001,
				0b10001,
				0b10001,
				0b11111,
				0b10001,
				0b10001,
				0b10001
			}
		),

		B
		(
			'B',
			new byte[]
			{
				0b11110,
				0b10001,
				0b10001,
				0b11110,
				0b10001,
				0b10001,
				0b10001,
				0b11110
			}
		),

		C
		(
			'C',
			new byte[]
			{
				0b01110,
				0b10001,
				0b10000,
				0b10000,
				0b10000,
				0b10000,
				0b10001,
				0b01110
			}
		),

		D
		(
			'D',
			new byte[]
			{
				0b11100,
				0b10010,
				0b10001,
				0b10001,
				0b10001,
				0b10001,
				0b10010,
				0b11100
			}
		),

		E
		(
			'E',
			new byte[]
			{
				0b11111,
				0b10000,
				0b10000,
				0b11111,
				0b10000,
				0b10000,
				0b10000,
				0b11111
			}
		),

		F
		(
			'F',
			new byte[]
			{
				0b11111,
				0b10000,
				0b10000,
				0b11111,
				0b10000,
				0b10000,
				0b10000,
				0b10000
			}
		),

		G
		(
			'G',
			new byte[]
			{
				0b01110,
				0b10001,
				0b10000,
				0b10000,
				0b10110,
				0b10001,
				0b10001,
				0b01110
			}
		),

		H
		(
			'H',
			new byte[]
			{
				0b10001,
				0b10001,
				0b10001,
				0b11111,
				0b10001,
				0b10001,
				0b10001,
				0b10001
			}
		),

		I
		(
			'I',
			new byte[]
			{
				0b01110,
				0b00100,
				0b00100,
				0b00100,
				0b00100,
				0b00100,
				0b00100,
				0b01110
			}
		),

		J
		(
			'J',
			new byte[]
			{
				0b00111,
				0b00001,
				0b00001,
				0b00011,
				0b00001,
				0b00001,
				0b10001,
				0b01110
			}
		),

		K
		(
			'K',
			new byte[]
			{
				0b10001,
				0b10010,
				0b10100,
				0b11000,
				0b11000,
				0b10100,
				0b10010,
				0b10001
			}
		),

		L
		(
			'L',
			new byte[]
			{
				0b10000,
				0b10000,
				0b10000,
				0b10000,
				0b10000,
				0b10000,
				0b10000,
				0b11111
			}
		),

		M
		(
			'M',
			new byte[]
			{
				0b10001,
				0b11011,
				0b10101,
				0b10001,
				0b10001,
				0b10001,
				0b10001,
				0b10001
			}
		),

		N
		(
			'N',
			new byte[]
			{
				0b10001,
				0b10001,
				0b11001,
				0b10101,
				0b10011,
				0b10001,
				0b10001,
				0b10001
			}
		),

		O
		(
			'O',
			new byte[]
			{
				0b01110,
				0b10001,
				0b10001,
				0b10001,
				0b10001,
				0b10001,
				0b10001,
				0b01110
			}
		),
		
		P
		(
			'P',
			new byte[]
			{
				0b11110,
				0b10001,
				0b10001,
				0b11110,
				0b10000,
				0b10000,
				0b10000,
				0b10000
			}
		),
		
		Q
		(
			'Q',
			new byte[]
			{
				0b01110,
				0b10001,
				0b10001,
				0b10001,
				0b10001,
				0b10001,
				0b10010,
				0b01101
			}
		),
		
		R
		(
			'R',
			new byte[]
			{
				0b11110,
				0b10001,
				0b10001,
				0b11110,
				0b11000,
				0b10100,
				0b10010,
				0b10001
			}
		),
		
		S
		(
			'S',
			new byte[]
			{
				0b01110,
				0b10001,
				0b10000,
				0b01110,
				0b00001,
				0b00001,
				0b10001,
				0b01110
			}
		),
		
		T
		(
			'T',
			new byte[]
			{
				0b11111,
				0b00100,
				0b00100,
				0b00100,
				0b00100,
				0b00100,
				0b00100,
				0b00100
			}
		),
		
		U
		(
			'U',
			new byte[]
			{
				0b10001,
				0b10001,
				0b10001,
				0b10001,
				0b10001,
				0b10001,
				0b10001,
				0b01110
			}
		),
		
		V
		(
			'V',
			new byte[]
			{
				0b10001,
				0b10001,
				0b10001,
				0b10001,
				0b01010,
				0b01010,
				0b01010,
				0b00100
			}
		),
		
		W
		(
			'W',
			new byte[]
			{
				0b10001,
				0b10001,
				0b10101,
				0b10101,
				0b10101,
				0b10101,
				0b10101,
				0b01010
			}
		),
		
		X
		(
			'X',
			new byte[]
			{
				0b10001,
				0b10001,
				0b01010,
				0b00100,
				0b00100,
				0b01010,
				0b10001,
				0b10001
			}
		),
		
		Y
		(
			'Y',
			new byte[]
			{
				0b10001,
				0b10001,
				0b01010,
				0b00100,
				0b00100,
				0b00100,
				0b00100,
				0b00100
			}
		),
		
		Z
		(
			'Z',
			new byte[]
			{
				0b11111,
				0b00001,
				0b00010,
				0b00100,
				0b01000,
				0b10000,
				0b10000,
				0b11111
			}
		),
		
		;
		
		protected final char ascii;
		protected final byte[] charMap;
		
		private Lcd58AsciiChars(char ascii, byte[] charMap)
		{
			this.ascii = ascii;
			this.charMap = charMap;
		}

		@Override
		public int getRowsCount()
		{
			return 8;
		}

		@Override
		public int getColumnCount()
		{
			return 5;
		}

		@Override
		public byte[] getColumns()
		{
			return charMap;
		}

		@Override
		public char getChar()
		{
			return ascii;
		}
	}
	
	public enum Lcd58ExtraChars implements Lcd8Char
	{
		ACCENT_a
		(
			'á',
			new byte[]
			{
				0b00000,
				0b00010,
				0b00100,
				0b01110,
				0b00001,
				0b01111,
				0b10001,
				0b01111
			}
		),
		
		ACCENT_A
		(
			'Á',
			new byte[]
			{
				0b00010,
				0b01110,
				0b10001,
				0b10001,
				0b11111,
				0b10001,
				0b10001,
				0b10001
			}
		),
		
		ACCENT_e
		(
			'é',
			new byte[]
			{
				0b00000,
				0b00100,
				0b01000,
				0b01100,
				0b10010,
				0b11110,
				0b10000,
				0b01100
			}
		),
		
		ACCENT_E
		(
			'É',
			new byte[]
			{
				0b00010,
				0b00100,
				0b11111,
				0b10000,
				0b11111,
				0b10000,
				0b10000,
				0b11111
			}
		),
		
		ACCENT_i
		(
			'í',
			new byte[]
			{
				0b00000,
				0b00010,
				0b00100,
				0b00000,
				0b00100,
				0b00100,
				0b00100,
				0b00100
			}
		),
		
		ACCENT_I
		(
			'Í',
			new byte[]
			{
				0b00010,
				0b00100,
				0b01110,
				0b00100,
				0b00100,
				0b00100,
				0b00100,
				0b01110
			}
		),
		
		ACCENT_o
		(
			'ó',
			new byte[]
			{
				0b00000,
				0b00010,
				0b00100,
				0b01110,
				0b10001,
				0b10001,
				0b10001,
				0b01110
			}
		),
		
		ACCENT_O
		(
			'Ó',
			new byte[]
			{
				0b00010,
				0b00100,
				0b01110,
				0b10001,
				0b10001,
				0b10001,
				0b10001,
				0b01110
			}
		),
		
		LONG_ACCENT_o
		(
			'ő',
			new byte[]
			{
				0b00101,
				0b01010,
				0b00000,
				0b01110,
				0b10001,
				0b10001,
				0b10001,
				0b01110
			}
		),
		
		LONG_ACCENT_O
		(
			'Ő',
			new byte[]
			{
				0b00101,
				0b01010,
				0b01110,
				0b10001,
				0b10001,
				0b10001,
				0b10001,
				0b01110
			}
		),
		
		ACCENT_u
		(
			'ú',
			new byte[]
			{
				0b00000,
				0b00010,
				0b00100,
				0b10010,
				0b10010,
				0b10010,
				0b10110,
				0b11010
			}
		),
		
		ACCENT_U
		(
			'Ú',
			new byte[]
			{
				0b00010,
				0b00100,
				0b10001,
				0b10001,
				0b10001,
				0b10001,
				0b10001,
				0b01110
			}
		),
		
		LONG_ACCENT_u
		(
			'ű',
			new byte[]
			{
				0b00101,
				0b01010,
				0b00000,
				0b10010,
				0b10010,
				0b10010,
				0b10110,
				0b11010
			}
		),
		
		LONG_ACCENT_U
		(
			'Ű',
			new byte[]
			{
				0b00101,
				0b01010,
				0b10001,
				0b10001,
				0b10001,
				0b10001,
				0b10001,
				0b01110
			}
		),
		
		UMLAUT_a
		(
			'ä',
			new byte[]
			{
				0b00000,
				0b01010,
				0b00000,
				0b11100,
				0b00010,
				0b01110,
				0b10010,
				0b01110
			}
		),
		
		UMLAUT_A
		(
			'Ä',
			new byte[]
			{
				0b01010,
				0b01110,
				0b10001,
				0b10001,
				0b11111,
				0b10001,
				0b10001,
				0b10001
			}
		),
		
		PLUS_MINUS
		(
			'±',
			new byte[]
			{
				0b00000,
				0b00000,
				0b00100,
				0b01110,
				0b00100,
				0b00000,
				0b01110,
				0b00000,
			}
		),
		
		UMLAUT_o
		(
			'ö',
			new byte[]
			{
				0b00000,
				0b01010,
				0b00000,
				0b01110,
				0b10001,
				0b10001,
				0b10001,
				0b01110
			}
		),
		
		UMLAUT_O
		(
			'Ö',
			new byte[]
			{
				0b01010,
				0b00000,
				0b01110,
				0b10001,
				0b10001,
				0b10001,
				0b10001,
				0b01110
			}
		),
		
		UMLAUT_ACCENT_u
		(
			'ü',
			new byte[]
			{
				0b00000,
				0b01010,
				0b00000,
				0b10010,
				0b10010,
				0b10010,
				0b10110,
				0b11010
			}
		),
		
		UMLAUT_ACCENT_U
		(
			'Ü',
			new byte[]
			{
				0b01010,
				0b00000,
				0b10001,
				0b10001,
				0b10001,
				0b10001,
				0b10001,
				0b01110
			}
		),
		
		;
		
		protected final char ascii;
		protected final byte[] charMap;
		
		private Lcd58ExtraChars(char ascii, byte[] charMap)
		{
			this.ascii = ascii;
			this.charMap = charMap;
		}

		@Override
		public int getRowsCount()
		{
			return 8;
		}

		@Override
		public int getColumnCount()
		{
			return 5;
		}

		@Override
		public byte[] getColumns()
		{
			return charMap;
		}

		@Override
		public char getChar()
		{
			return ascii;
		}
	}
	
	protected static final byte[] UNKOWN_CHAR_MAP = new byte[]
	{
		0b01010,
		0b10101,
		0b01010,
		0b10101,
		0b01010,
		0b10101,
		0b01010,
		0b10101
	};
	
	public static final Lcd8Char UNKOWN_CHAR_SYMBOL = new Lcd8Char()
	{
		@Override
		public int getRowsCount()
		{
			return 8;
		}

		@Override
		public int getColumnCount()
		{
			return 5;
		}
		
		
		@Override
		public byte[] getColumns()
		{
			return UNKOWN_CHAR_MAP;
		}

		@Override
		public char getChar()
		{
			return 0;
		}
	};
	
	protected static final Map<Character, Lcd8Char> CHARS = new HashMap<>();
	
	public static void fillKnownLcd58Chars(Map<Character, Lcd8Char> to)
	{
		for(Lcd58AsciiChars c:Lcd58AsciiChars.values())
		{
			to.put(c.getChar(), c);
		}
		
		for(Lcd58ExtraChars c:Lcd58ExtraChars.values())
		{
			to.put(c.getChar(), c);
		}
	}
	
	static
	{
		fillKnownLcd58Chars(CHARS);
	}
	
	public static Lcd8Char getChar(char c)
	{
		Lcd8Char ret = CHARS.get(c);
		if(null == ret)
		{
			ret = UNKOWN_CHAR_SYMBOL;
		}
		return ret;
	}
	
	public static final GetBy1<Lcd8Char, Character> CHAR_MAPPER = CHARS::get;
	
	public static final GetBy1<Lcd8Char, Character> CHAR_MAPPER_WITH_UNKNOWN = Lcd58Chars::getChar;
}
