package eu.javaexperience.electronic.lcd.display;

import java.util.ArrayList;
import java.util.List;

import eu.javaexperience.collection.CollectionTools;
import eu.javaexperience.electronic.lcd.menu.LcdDisplay;
import eu.javaexperience.electronic.lcd.menu.LcdDisplayState;

public class MatrixRenderInstructions implements LcdDisplayState
{
	protected List<RenderingInstruction> instructions = new ArrayList<>();
	
	public List<RenderingInstruction> getInstructions()
	{
		return instructions;
	}
	
	@Override
	public void render(LcdDisplay display)
	{
		for(RenderingInstruction i:instructions)
		{
			int x0 = i.getX0();
			int y0 = i.getY0();
			
			int height = i.getHeight();
			int width = i.getWidth();
			
			for(int h=0;h <height;h++)
			{
				for(int w=0;w<width;w++)
				{
					if(i.isSet(w, h))
					{
						display.setPixel(x0+w, y0+h);
					}
				}
			}
		}
	}
	
	public MatrixRenderInstructions(RenderingInstruction... instr)
	{
		CollectionTools.inlineAdd(instructions, instr);
	}
	
	public static MatrixRenderInstructions instructions(RenderingInstruction... instr)
	{
		return new MatrixRenderInstructions(instr);
	}

	public static MatrixRenderInstructions instrunctionList(List<RenderingInstruction> mri)
	{
		MatrixRenderInstructions ret = new MatrixRenderInstructions();
		ret.instructions = mri;
		return ret;
	}
}
