package eu.javaexperience.electronic.lcd.menu;

import java.util.ArrayList;
import java.util.List;
import java.util.Map.Entry;

import eu.javaexperience.collection.map.KeyVal;
import eu.javaexperience.interfaces.simple.SimpleGet;
import eu.javaexperience.interfaces.simple.getBy.GetBy1;

public class LcdMenuBuilderExtended<T> extends LcdMenuBuilderPlain
{
	protected GetBy1<LcdDisplayState, T> renderer;
	
	public LcdMenuBuilderExtended(InputEventNavigationInterpreter nav, GetBy1<LcdDisplayState, T> renderer)
	{
		super(nav);
		this.renderer = renderer;
	}
	
	public GetBy1<LcdDisplayState, T> getRenderer()
	{
		return renderer;
	}
	
	public <L extends LcdMenu<L>> LcdSpinnerMenu<L> createPostRenderedSpinnerMenu(String menuId, Entry<SimpleGet<T>, SimpleGet<L>>... entries)
	{
		List<Entry<SimpleGet<LcdDisplayState>, SimpleGet<L>>> pe = new ArrayList<>();
		
		for(Entry<SimpleGet<T>, SimpleGet<L>> ent:entries)
		{
			pe.add(new KeyVal<SimpleGet<LcdDisplayState>, SimpleGet<L>>(() -> renderer.getBy(ent.getKey().get()), ent.getValue()));
		}
		
		return createSpinnerMenu(menuId, pe.toArray(KeyVal.emptyArrayInstance));
	}
	
	
	public <L extends LcdMenu<L>> LcdSpinnerMenu<L> createRenderedSpinnerMenu(String menuId, Entry<T, SimpleGet<L>>... entries)
	{
		List<Entry<SimpleGet<LcdDisplayState>, SimpleGet<L>>> pe = new ArrayList<>();
		
		for(Entry<T, SimpleGet<L>> ent:entries)
		{
			pe.add(new KeyVal<SimpleGet<LcdDisplayState>, SimpleGet<L>>(() -> renderer.getBy(ent.getKey()), ent.getValue()));
		}
		
		return createSpinnerMenu(menuId, pe.toArray(KeyVal.emptyArrayInstance));
	}
	
	
	public <L extends LcdMenu<L>> LcdSpinnerMenu<L> createDynamicMenu
	(
		String menuId,
		GetBy1<List<Entry<SimpleGet<LcdDisplayState>, SimpleGet<L>>>, LcdMenu> entries
	)
	{
		return new LcdSpinnerMenu<L>(menuId, nav)
		{
			private void reload()
			{
				getRwMenuEntries().clear();
				
				for(Entry<SimpleGet<LcdDisplayState>, SimpleGet<L>> kv:entries.getBy(this))
				{
					getRwMenuEntries().add(kv);
				}
			}
			
			@Override
			public void refresh()
			{
				reload();
				super.refresh();
			}
		};
		
	}
}
