package eu.javaexperience.electronic.lcd.menu;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import eu.javaexperience.collection.map.SmallMap;
import eu.javaexperience.datareprez.DataCommon;
import eu.javaexperience.datareprez.DataObject;
import eu.javaexperience.electronic.lcd.menu.input.InputEvent;
import eu.javaexperience.interfaces.ExternalDataAttached;
import eu.javaexperience.interfaces.simple.SimpleGet;
import eu.javaexperience.interfaces.simple.publish.SimplePublish1;
import eu.javaexperience.math.MathTools;

public class LcdSpinnerMenu<L extends LcdMenu<L>> implements LcdMenu<L>, ExternalDataAttached
{
	protected String id;
	protected LcdMenuHost<L> host;
	protected int index = 0;
	
	protected SimpleGet<L> back;
	
	protected boolean autoBack = true;
	protected List<Entry<SimpleGet<LcdDisplayState>, SimpleGet<L>>> menuEntries = new ArrayList<>();
	
	protected InputEventNavigationInterpreter nav;
	
	protected int parentIndex = 0;
	
	protected SimplePublish1<LcdSpinnerMenu<L>> afterEnter;
	
	public LcdSpinnerMenu(String id, InputEventNavigationInterpreter nav)
	{
		this.id = id;
		this.nav = nav;
	}
	
	@Override
	public String getId()
	{
		return id;
	}
	
	public List<Entry<SimpleGet<LcdDisplayState>,SimpleGet<L>>> getRwMenuEntries()
	{
		return menuEntries;
	}
	
	@Override
	public void publish(InputEvent a)
	{
		if(null != back && nav.isBack(a))
		{
			enterMenuWithReturn(back.get(), false);
		}
		else if(nav.isUp(a))
		{
			setIndex(index < 1? menuEntries.size()-1:index-1);
		}
		else if(nav.isDown(a))
		{
			setIndex(index < menuEntries.size()-1?index+1:0);
		}
		else if(nav.isSelect(a) && null != menuEntries.get(index).getValue())
		{
			enterMenuWithReturn(menuEntries.get(index).getValue().get(), true);
		}
	}
	
	protected void enterMenuWithReturn(LcdMenu menu, boolean trueForward_falseBackward)
	{
		if(null == menu)
		{
			return;
		}
		
		if(menu.canEnter())
		{
			if(trueForward_falseBackward)
			{
				if(menu instanceof LcdSpinnerMenu)
				{
					LcdSpinnerMenu dst = (LcdSpinnerMenu) menu;
					if(dst.isAutoBack())
					{
						dst.setBackMenu(()->this);
					}
				}
			}
			
			if(trueForward_falseBackward && menu instanceof LcdSpinnerMenu)
			{
				((LcdSpinnerMenu)menu).parentIndex = index;
			}
			
			if(null != host)
			{
				host.enterMenu((L) menu);
			}
			
			if(!trueForward_falseBackward && menu instanceof LcdSpinnerMenu)
			{
				((LcdSpinnerMenu)menu).setIndex(parentIndex);
			}
		}
	}

	@Override
	public void init(LcdMenuHost<L> host)
	{
		this.host = host;
		setIndex(0);
		if(null != afterEnter)
		{
			afterEnter.publish(this);
		}
	}
	
	public LcdMenuHost<L> getMenuHost()
	{
		return host;
	}
	
	public void setIndex(int index)
	{
		this.index = MathTools.clamp(0, index, menuEntries.size()-1);
		refresh();
	}
	
	@Override
	public DataObject saveState(DataCommon proto)
	{
		DataObject ret = proto.newObjectInstance();
		ret.putInt("index", index);
		return ret;
	}
	
	@Override
	public void restoreState(DataObject from)
	{
		setIndex(from.optInt("index", 0));
	}

	@Override
	public void dispose(){}

	public void setBackMenu(SimpleGet<L> back)
	{
		this.back = back;
	}
	
	public SimpleGet<L> getBackMenu()
	{
		return this.back;
	}

	@Override
	public void refresh()
	{
		if(this.index < menuEntries.size())
		{
			SimpleGet<LcdDisplayState> cre = menuEntries.get(this.index).getKey();
			if(null != cre && null != host)
			{
				host.setDisplayState(cre.get());
			}
		}
	}
	
	public int getIndex()
	{
		return index;
	}
	
	public void setAutoBack(boolean autoBack)
	{
		this.autoBack = autoBack;
	}
	
	public LcdSpinnerMenu<L> unsetAutoBack()
	{
		this.autoBack = false;
		return this;
	}
	
	public boolean isAutoBack()
	{
		return this.autoBack;
	}
	
	@Override
	public boolean canEnter()
	{
		return !menuEntries.isEmpty();
	}

	public void pinBackMenu(SimpleGet<L> back)
	{
		this.autoBack = false;
		this.back = back;
	}
	
	@Override
	public String toString()
	{
		return "LcdSpinnerMenu(id:`"+id+"`)";
	}

	public void setAfterEnter(SimplePublish1<LcdSpinnerMenu<L>> afterEnter)
	{
		this.afterEnter = afterEnter;
	}
	
	public SimplePublish1<LcdSpinnerMenu<L>> getAfterEnter()
	{
		return afterEnter;
	}
	
	protected transient Map<String, Object> extraData;
	
	@Override
	public Map<String, Object> getExtraDataMap()
	{
		if(null == extraData)
		{
			extraData = new SmallMap<>();
		}
		return extraData;
	}
}
