package eu.javaexperience.electronic.lcd.menu.input;

import java.util.Set;

public interface InputEvent
{
	/**
	 * "user", "system", "restore", etc
	 * */
	public String getInputSourceEntity();
	
	
	/**
	 * "keyboard", "mouse", "touch_screen", "rotary_encorer", "proximity_sensor", "potentiometer", "impulse source" etc
	 * */
	public String getInputDevice();
	
	/**
	 * "key", "slide", "touch", etc
	 * */
	public String getInputType();
	
	/**
	 * "value_set", "key_down", "key_up", "key_pressed", "stream"
	 * */
	public String getInputMode();
	
	/**
	 * 	"alt", "ctrl", "shift", 
	 * or
	 * 	"pressed" (eg rotary encoder with click ability)
	 * */
	public Set<String> getInputModifiers();
	
	
	/**
	 * the value.:
	 * 	- null: (eg impulse source),
	 * 	- true/false: button pressed,
	 * 	- "k": keyboard button pressed,
	 *  - 0.235:potentiometer btw 0.0 - 1.0,
	 * 	- Point(0.35, 0.632) touchscreen,
	 * 	- Color(10, 213, 40) color sensor,
	 * */
	public Object getInputValue();
}
