/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.electronic.lcd.display;

import eu.javaexperience.electronic.lcd.display.AbstractRenderingInstruction;

public class GraphicRendering
extends AbstractRenderingInstruction {
    protected int[] data;
    protected int width;

    public GraphicRendering(int x0, int y0, boolean inverted, int[] data, int width) {
        super(x0, y0, inverted);
        this.data = data;
        this.width = width;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.data.length;
    }

    @Override
    public boolean isSet(int x, int y) {
        if (x > this.width || y > this.data.length) {
            return false;
        }
        return this.inverted != (0 != (this.data[y] & 1 << this.width - 1 - x));
    }
}

