/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.electronic.sevensegment;

import java.util.HashMap;
import java.util.Map;

public enum SevenSegmentCharacters {
    SPACE(' ', 0),
    EXCLAMATION('!', 2),
    DOUBLE_QUOTE('\"', 34),
    HASHMARK('#', 54),
    DOLLAR('$', 105),
    PERCENTAGE('%', 45),
    AMPERSTAND('&', 123),
    SINGLE_QUOUTE('\'', 32),
    PARENTHESIS_OPEN('(', 57),
    PARENTHESIS_CLOSE(')', 15),
    START('*', 99),
    PLUS('+', 112),
    COMMA(',', 12),
    MINUS('-', 64),
    DOT('.', 12),
    SLASH('/', 82),
    BACKSLASH('\\', 100),
    COLON(':', 72),
    SEMICOLON(';', 76),
    GREATER_THAN('<', 97),
    LESS_THAN('>', 67),
    EQUALS('=', 65),
    QUESTION_MARK('?', 83),
    AT('@', 95),
    BRACKET_OPEN('(', 57),
    BRACKET_CLOSE(')', 15),
    POW('^', 35),
    UNDERSCORE('_', 8),
    ZERO('0', 63),
    ONE('1', 6),
    TWO('2', 91),
    THREE('3', 79),
    FOUR('4', 102),
    FIVE('5', 109),
    SIX('6', 125),
    SEVEN('7', 7),
    EIGHT('8', 127),
    NINE('9', 111),
    A('A', 119),
    B('B', 124),
    C('C', 57),
    D('D', 94),
    E('E', 121),
    F('F', 113),
    G('G', 61),
    H('H', 116),
    I('I', 48),
    J('J', 30),
    K('K', 117),
    L('L', 56),
    M('M', 21),
    N('N', 55),
    O('O', 63),
    P('P', 115),
    Q('Q', 103),
    R('R', 51),
    S('S', 109),
    T('T', 120),
    U('U', 62),
    V('V', 46),
    W('W', 42),
    X('X', 118),
    Y('Y', 110),
    Z('Z', 75);

    protected char character;
    protected byte segmentsOn;
    protected static Map<Character, SevenSegmentCharacters> CHAR_MAP;

    private SevenSegmentCharacters(char c, int val) {
        this.character = c;
        this.segmentsOn = (byte)val;
    }

    public static SevenSegmentCharacters getByChar(char c) {
        return CHAR_MAP.get(Character.valueOf(c));
    }

    static {
        CHAR_MAP = new HashMap<Character, SevenSegmentCharacters>();
        for (SevenSegmentCharacters v : SevenSegmentCharacters.values()) {
            CHAR_MAP.put(Character.valueOf(v.character), v);
        }
    }
}

