package eu.javaexperience.electronic.lcd.display;

public class GraphicRendering extends AbstractRenderingInstruction
{
	protected int[] data;
	protected int width;
	
	public GraphicRendering(int x0, int y0, boolean inverted, int[] data, int width)
	{
		super(x0, y0, inverted);
		this.data = data;
		this.width = width;
	}
	
	@Override
	public int getWidth()
	{
		return width;
	}

	@Override
	public int getHeight()
	{
		return data.length;
	}

	@Override
	public boolean isSet(int x, int y)
	{
		//off the chart checks
		if(x > width || y > data.length)
		{
			return false;
		}
		
		return inverted != (0 != (data[y] & (0x1 << ((width-1)-x))));
	}
}
