package eu.javaexperience.electronic.lcd.menu;

import eu.javaexperience.datareprez.DataCommon;
import eu.javaexperience.datareprez.DataObject;
import eu.javaexperience.electronic.lcd.menu.input.InputEvent;
import eu.javaexperience.interfaces.simple.SimpleGet;
import eu.javaexperience.interfaces.simple.publish.SimplePublish1;

public class LcdTrailFrameMenu<L extends LcdMenu<L>> implements LcdMenu<L>
{
	protected String id;
	protected LcdMenuHost<L> host;
	protected int state = 0;
	protected long t0 = 0;
	protected SimpleGet<LcdDisplayState> display;
	
	public static class TrailFrame
	{
		protected int timeToShow;
		protected SimplePublish1<LcdTrailFrameMenu> enterState;
		
		public TrailFrame(SimplePublish1<LcdTrailFrameMenu> enterState, int timeToShow)
		{
			this.timeToShow = timeToShow;
			this.enterState = enterState;
		}
	}
	
	protected TrailFrame[] frames;
	
	public LcdTrailFrameMenu(String id, TrailFrame... frames)
	{
		this.id = id;
		this.frames = frames;
	}
	
	protected void executeFrame()
	{
		if(state < frames.length)
		{
			if(null != frames[state].enterState)
			{
				frames[state].enterState.publish(this);
			}
		}
	}
	
	protected void checkStepFrame()
	{
		if(state < frames.length)
		{
			if(System.currentTimeMillis() >= t0+frames[state].timeToShow)
			{
				++state;
				t0 = System.currentTimeMillis();
				executeFrame();
			}
		}		
	}
	
	@Override
	public void init(LcdMenuHost host)
	{
		this.host = host;
		state = 0;
		t0 = System.currentTimeMillis();
		executeFrame();
	}

	@Override
	public DataObject saveState(DataCommon proto)
	{
		return proto.newObjectInstance();
	}

	@Override
	public void restoreState(DataObject from)
	{
		
	}

	@Override
	public String getId()
	{
		return id;
	}

	@Override
	public void dispose()
	{
		
	}

	@Override
	public void refresh()
	{
		checkStepFrame();
		host.setDisplayState(display.get());
	}

	@Override
	public boolean canEnter()
	{
		return true;
	}

	@Override
	public void publish(InputEvent a)
	{
		//do nothing
	}

	public void setDisplay(SimpleGet<LcdDisplayState> display)
	{
		this.display = display;
	}
}
