/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.electronic.lcd;

import eu.javaexperience.electronic.lcd.Lcd8Char;
import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import java.util.HashMap;
import java.util.Map;

public class Lcd58Chars {
    protected static final byte[] UNKOWN_CHAR_MAP = new byte[]{10, 21, 10, 21, 10, 21, 10, 21};
    public static final Lcd8Char UNKOWN_CHAR_SYMBOL = new Lcd8Char(){

        @Override
        public int getRowsCount() {
            return 8;
        }

        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public byte[] getColumns() {
            return UNKOWN_CHAR_MAP;
        }

        @Override
        public char getChar() {
            return '\u0000';
        }
    };
    protected static final Map<Character, Lcd8Char> CHARS = new HashMap<Character, Lcd8Char>();
    public static final GetBy1<Lcd8Char, Character> CHAR_MAPPER;
    public static final GetBy1<Lcd8Char, Character> CHAR_MAPPER_WITH_UNKNOWN;

    public static void fillKnownLcd58Chars(Map<Character, Lcd8Char> to) {
        for (Lcd58AsciiChars lcd58AsciiChars : Lcd58AsciiChars.values()) {
            to.put(Character.valueOf(lcd58AsciiChars.getChar()), lcd58AsciiChars);
        }
        for (Enum enum_ : Lcd58ExtraChars.values()) {
            to.put(Character.valueOf(((Lcd58ExtraChars)enum_).getChar()), (Lcd8Char)((Object)enum_));
        }
    }

    public static Lcd8Char getChar(char c) {
        Lcd8Char ret = CHARS.get(Character.valueOf(c));
        if (null == ret) {
            ret = UNKOWN_CHAR_SYMBOL;
        }
        return ret;
    }

    static {
        Lcd58Chars.fillKnownLcd58Chars(CHARS);
        CHAR_MAPPER = CHARS::get;
        CHAR_MAPPER_WITH_UNKNOWN = Lcd58Chars::getChar;
    }

    public static enum Lcd58ExtraChars implements Lcd8Char
    {
        ACCENT_a('\u00e1', new byte[]{0, 2, 4, 14, 1, 15, 17, 15}),
        ACCENT_A('\u00c1', new byte[]{2, 14, 17, 17, 31, 17, 17, 17}),
        ACCENT_e('\u00e9', new byte[]{0, 4, 8, 12, 18, 30, 16, 12}),
        ACCENT_E('\u00c9', new byte[]{2, 4, 31, 16, 31, 16, 16, 31}),
        ACCENT_i('\u00ed', new byte[]{0, 2, 4, 0, 4, 4, 4, 4}),
        ACCENT_I('\u00cd', new byte[]{2, 4, 14, 4, 4, 4, 4, 14}),
        ACCENT_o('\u00f3', new byte[]{0, 2, 4, 14, 17, 17, 17, 14}),
        ACCENT_O('\u00d3', new byte[]{2, 4, 14, 17, 17, 17, 17, 14}),
        LONG_ACCENT_o('\u0151', new byte[]{5, 10, 0, 14, 17, 17, 17, 14}),
        LONG_ACCENT_O('\u0150', new byte[]{5, 10, 14, 17, 17, 17, 17, 14}),
        ACCENT_u('\u00fa', new byte[]{0, 2, 4, 18, 18, 18, 22, 26}),
        ACCENT_U('\u00da', new byte[]{2, 4, 17, 17, 17, 17, 17, 14}),
        LONG_ACCENT_u('\u0171', new byte[]{5, 10, 0, 18, 18, 18, 22, 26}),
        LONG_ACCENT_U('\u0170', new byte[]{5, 10, 17, 17, 17, 17, 17, 14}),
        UMLAUT_a('\u00e4', new byte[]{0, 10, 0, 28, 2, 14, 18, 14}),
        UMLAUT_A('\u00c4', new byte[]{10, 14, 17, 17, 31, 17, 17, 17}),
        PLUS_MINUS('\u00b1', new byte[]{0, 0, 4, 14, 4, 0, 14, 0}),
        UMLAUT_o('\u00f6', new byte[]{0, 10, 0, 14, 17, 17, 17, 14}),
        UMLAUT_O('\u00d6', new byte[]{10, 0, 14, 17, 17, 17, 17, 14}),
        UMLAUT_ACCENT_u('\u00fc', new byte[]{0, 10, 0, 18, 18, 18, 22, 26}),
        UMLAUT_ACCENT_U('\u00dc', new byte[]{10, 0, 17, 17, 17, 17, 17, 14});

        protected final char ascii;
        protected final byte[] charMap;

        private Lcd58ExtraChars(char ascii, byte[] charMap) {
            this.ascii = ascii;
            this.charMap = charMap;
        }

        @Override
        public int getRowsCount() {
            return 8;
        }

        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public byte[] getColumns() {
            return this.charMap;
        }

        @Override
        public char getChar() {
            return this.ascii;
        }
    }

    public static enum Lcd58AsciiChars implements Lcd8Char
    {
        SPACE(' ', new byte[]{0, 0, 0, 0, 0, 0, 0, 0}),
        EXCLAMATION('!', new byte[]{4, 4, 4, 4, 4, 4, 0, 4}),
        QUOTATION('\"', new byte[]{10, 10, 0, 0, 0, 0, 0, 0}),
        HASHMARK('#', new byte[]{10, 10, 31, 10, 10, 31, 10, 10}),
        DOLLAR('$', new byte[]{0, 4, 15, 20, 14, 5, 30, 4}),
        PERCENTAGE('%', new byte[]{0, 0, 24, 26, 4, 8, 22, 6}),
        AND('&', new byte[]{0, 12, 18, 20, 8, 21, 18, 13}),
        APOSTROPHE('\'', new byte[]{6, 2, 4, 0, 0, 0, 0, 0}),
        PARENTHESIS_OPEN('(', new byte[]{0, 2, 4, 8, 8, 8, 4, 2}),
        PARENTHESIS_CLOSE(')', new byte[]{0, 8, 4, 2, 2, 2, 4, 8}),
        START('*', new byte[]{0, 0, 4, 21, 14, 21, 4, 0}),
        PLUS('+', new byte[]{0, 0, 4, 4, 14, 4, 4, 0}),
        COMMA(',', new byte[]{0, 0, 0, 0, 0, 6, 6, 8}),
        MINUS('-', new byte[]{0, 0, 0, 0, 30, 0, 0, 0}),
        DOT('.', new byte[]{0, 0, 0, 0, 0, 0, 12, 12}),
        SLASH('/', new byte[]{0, 1, 1, 2, 4, 8, 16, 16}),
        COLON(':', new byte[]{0, 0, 6, 6, 0, 6, 6, 0}),
        SEMICOLON(';', new byte[]{0, 0, 6, 6, 0, 6, 6, 4}),
        LASS_THAN('<', new byte[]{0, 2, 4, 8, 16, 8, 4, 2}),
        EQUALS('=', new byte[]{0, 0, 0, 31, 0, 31, 0, 0}),
        GREATER_THAN('>', new byte[]{0, 8, 4, 2, 1, 2, 4, 8}),
        QUESTION_MARK('?', new byte[]{0, 14, 17, 1, 2, 4, 0, 4}),
        AT('@', new byte[]{0, 0, 14, 17, 21, 23, 16, 14}),
        BRACKET_OPEN('[', new byte[]{0, 14, 8, 8, 8, 8, 8, 14}),
        BACK_SLASH('\\', new byte[]{0, 0, 0, 16, 8, 4, 2, 1}),
        BRACKET_CLOSE(']', new byte[]{0, 14, 2, 2, 2, 2, 2, 14}),
        POWER('^', new byte[]{4, 10, 17, 0, 0, 0, 0, 0}),
        UNDERSCORE('_', new byte[]{0, 0, 0, 0, 0, 0, 0, 31}),
        BACK_APOSTROPHE('`', new byte[]{8, 4, 2, 0, 0, 0, 0, 0}),
        BRACE_OPEN('{', new byte[]{0, 2, 4, 4, 8, 4, 4, 2}),
        PIPELINE('|', new byte[]{4, 4, 4, 4, 4, 4, 4, 4}),
        BRACE_CLOSE('}', new byte[]{0, 8, 4, 4, 2, 4, 4, 8}),
        TILDE('~', new byte[]{0, 0, 0, 0, 9, 22, 0, 0}),
        _0('0', new byte[]{0, 14, 17, 19, 21, 25, 17, 14}),
        _1('1', new byte[]{0, 4, 12, 4, 4, 4, 4, 14}),
        _2('2', new byte[]{0, 12, 18, 2, 4, 8, 16, 30}),
        _3('3', new byte[]{0, 28, 2, 2, 12, 2, 2, 28}),
        _4('4', new byte[]{0, 4, 12, 20, 20, 30, 4, 4}),
        _5('5', new byte[]{0, 30, 16, 28, 18, 2, 18, 12}),
        _6('6', new byte[]{0, 12, 18, 16, 28, 18, 18, 12}),
        _7('7', new byte[]{0, 30, 2, 4, 4, 4, 8, 8}),
        _8('8', new byte[]{0, 12, 18, 18, 12, 18, 18, 12}),
        _9('9', new byte[]{0, 12, 18, 18, 14, 2, 18, 12}),
        a('a', new byte[]{0, 0, 0, 14, 1, 15, 17, 15}),
        b('b', new byte[]{0, 0, 16, 16, 28, 18, 18, 28}),
        c('c', new byte[]{0, 0, 0, 12, 18, 16, 18, 12}),
        d('d', new byte[]{0, 0, 2, 2, 14, 18, 18, 14}),
        e('e', new byte[]{0, 0, 0, 12, 18, 30, 16, 12}),
        f('f', new byte[]{0, 0, 12, 8, 28, 8, 8, 8}),
        g('g', new byte[]{0, 0, 12, 18, 18, 14, 2, 12}),
        h('h', new byte[]{0, 0, 16, 16, 28, 18, 18, 18}),
        i('i', new byte[]{0, 0, 4, 0, 4, 4, 4, 4}),
        j('j', new byte[]{0, 0, 4, 0, 4, 4, 20, 8}),
        k('k', new byte[]{0, 0, 16, 18, 20, 24, 20, 18}),
        l('l', new byte[]{0, 0, 24, 8, 8, 8, 8, 4}),
        m('m', new byte[]{0, 0, 0, 26, 21, 21, 21, 21}),
        n('n', new byte[]{0, 0, 0, 22, 25, 17, 17, 17}),
        o('o', new byte[]{0, 0, 0, 14, 17, 17, 17, 14}),
        p('p', new byte[]{0, 0, 0, 28, 18, 18, 28, 16}),
        q('q', new byte[]{0, 0, 0, 10, 22, 18, 14, 2}),
        r('r', new byte[]{0, 0, 0, 20, 26, 16, 16, 16}),
        s('s', new byte[]{0, 0, 0, 14, 16, 12, 2, 28}),
        t('t', new byte[]{0, 0, 16, 24, 16, 16, 18, 12}),
        u('u', new byte[]{0, 0, 0, 18, 18, 18, 22, 26}),
        v('v', new byte[]{0, 0, 0, 17, 17, 10, 10, 4}),
        w('w', new byte[]{0, 0, 0, 21, 21, 21, 21, 10}),
        x('x', new byte[]{0, 0, 0, 17, 10, 4, 10, 17}),
        y('y', new byte[]{0, 0, 0, 18, 18, 14, 2, 12}),
        z('z', new byte[]{0, 0, 0, 31, 2, 4, 8, 31}),
        A('A', new byte[]{14, 17, 17, 17, 31, 17, 17, 17}),
        B('B', new byte[]{30, 17, 17, 30, 17, 17, 17, 30}),
        C('C', new byte[]{14, 17, 16, 16, 16, 16, 17, 14}),
        D('D', new byte[]{28, 18, 17, 17, 17, 17, 18, 28}),
        E('E', new byte[]{31, 16, 16, 31, 16, 16, 16, 31}),
        F('F', new byte[]{31, 16, 16, 31, 16, 16, 16, 16}),
        G('G', new byte[]{14, 17, 16, 16, 22, 17, 17, 14}),
        H('H', new byte[]{17, 17, 17, 31, 17, 17, 17, 17}),
        I('I', new byte[]{14, 4, 4, 4, 4, 4, 4, 14}),
        J('J', new byte[]{7, 1, 1, 3, 1, 1, 17, 14}),
        K('K', new byte[]{17, 18, 20, 24, 24, 20, 18, 17}),
        L('L', new byte[]{16, 16, 16, 16, 16, 16, 16, 31}),
        M('M', new byte[]{17, 27, 21, 17, 17, 17, 17, 17}),
        N('N', new byte[]{17, 17, 25, 21, 19, 17, 17, 17}),
        O('O', new byte[]{14, 17, 17, 17, 17, 17, 17, 14}),
        P('P', new byte[]{30, 17, 17, 30, 16, 16, 16, 16}),
        Q('Q', new byte[]{14, 17, 17, 17, 17, 17, 18, 13}),
        R('R', new byte[]{30, 17, 17, 30, 24, 20, 18, 17}),
        S('S', new byte[]{14, 17, 16, 14, 1, 1, 17, 14}),
        T('T', new byte[]{31, 4, 4, 4, 4, 4, 4, 4}),
        U('U', new byte[]{17, 17, 17, 17, 17, 17, 17, 14}),
        V('V', new byte[]{17, 17, 17, 17, 10, 10, 10, 4}),
        W('W', new byte[]{17, 17, 21, 21, 21, 21, 21, 10}),
        X('X', new byte[]{17, 17, 10, 4, 4, 10, 17, 17}),
        Y('Y', new byte[]{17, 17, 10, 4, 4, 4, 4, 4}),
        Z('Z', new byte[]{31, 1, 2, 4, 8, 16, 16, 31});

        protected final char ascii;
        protected final byte[] charMap;

        private Lcd58AsciiChars(char ascii, byte[] charMap) {
            this.ascii = ascii;
            this.charMap = charMap;
        }

        @Override
        public int getRowsCount() {
            return 8;
        }

        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public byte[] getColumns() {
            return this.charMap;
        }

        @Override
        public char getChar() {
            return this.ascii;
        }
    }
}

