/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.electronic.lcd.menu;

import eu.javaexperience.collection.map.SmallMap;
import eu.javaexperience.datareprez.DataCommon;
import eu.javaexperience.datareprez.DataObject;
import eu.javaexperience.electronic.lcd.menu.InputEventNavigationInterpreter;
import eu.javaexperience.electronic.lcd.menu.LcdDisplayState;
import eu.javaexperience.electronic.lcd.menu.LcdMenu;
import eu.javaexperience.electronic.lcd.menu.LcdMenuHost;
import eu.javaexperience.electronic.lcd.menu.LcdSpinnerMenu;
import eu.javaexperience.electronic.lcd.menu.input.InputEvent;
import eu.javaexperience.interfaces.ExternalDataAttached;
import eu.javaexperience.interfaces.simple.SimpleGet;
import eu.javaexperience.interfaces.simple.publish.SimplePublish1;
import java.util.Map;

public abstract class AbstractLcdMenu<L extends LcdMenu<L>>
implements LcdMenu<L>,
ExternalDataAttached {
    protected String id;
    protected LcdMenuHost<L> host;
    protected int index = 0;
    protected SimpleGet<L> back;
    protected boolean autoBack = true;
    protected InputEventNavigationInterpreter nav;
    protected int parentIndex = 0;
    protected SimplePublish1<AbstractLcdMenu<L>> afterEnter;
    protected transient Map<String, Object> extraData;

    public AbstractLcdMenu(String id, InputEventNavigationInterpreter nav) {
        this.id = id;
        this.nav = nav;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void publish(InputEvent a) {
        if (null != this.back && this.nav.isBack(a)) {
            this.enterMenuWithReturn((LcdMenu)this.back.get(), false);
        } else if (this.nav.isUp(a)) {
            this.setIndex(++this.index);
        } else if (this.nav.isDown(a)) {
            this.setIndex(--this.index);
        } else if (this.nav.isSelect(a) && this.canSelectIndex(this.index)) {
            this.enterMenuWithReturn(this.getMenuByIndex(this.index), true);
        }
    }

    public abstract boolean canSelectIndex(int var1);

    protected void enterMenuWithReturn(LcdMenu menu, boolean trueForward_falseBackward) {
        if (null == menu) {
            return;
        }
        if (menu.canEnter()) {
            LcdSpinnerMenu dst;
            if (trueForward_falseBackward && menu instanceof LcdSpinnerMenu && (dst = (LcdSpinnerMenu)menu).isAutoBack()) {
                dst.setBackMenu(() -> this);
            }
            if (trueForward_falseBackward && menu instanceof LcdSpinnerMenu) {
                ((LcdSpinnerMenu)menu).parentIndex = this.index;
            }
            if (null != this.host) {
                this.host.enterMenu(menu);
            }
            if (!trueForward_falseBackward && menu instanceof LcdSpinnerMenu) {
                ((LcdSpinnerMenu)menu).setIndex(this.parentIndex);
            }
        }
    }

    public abstract LcdMenu getMenuByIndex(int var1);

    @Override
    public void init(LcdMenuHost<L> host) {
        this.host = host;
        this.setIndex(0);
        if (null != this.afterEnter) {
            this.afterEnter.publish((Object)this);
        }
    }

    public abstract int filterIndex(int var1);

    public abstract LcdDisplayState getCurrentDisplayState();

    @Override
    public void refresh() {
        LcdDisplayState state;
        if (null != this.host && null != (state = this.getCurrentDisplayState())) {
            this.host.setDisplayState(state);
        }
    }

    public LcdMenuHost<L> getMenuHost() {
        return this.host;
    }

    public void setIndex(int index) {
        this.index = this.filterIndex(index);
        this.refresh();
    }

    @Override
    public DataObject saveState(DataCommon proto) {
        DataObject ret = proto.newObjectInstance();
        ret.putInt("index", this.index);
        return ret;
    }

    @Override
    public void restoreState(DataObject from) {
        this.setIndex(from.optInt("index", 0));
    }

    @Override
    public void dispose() {
    }

    public void setBackMenu(SimpleGet<L> back) {
        this.back = back;
    }

    public int getIndex() {
        return this.index;
    }

    public void setAutoBack(boolean autoBack) {
        this.autoBack = autoBack;
    }

    public AbstractLcdMenu<L> unsetAutoBack() {
        this.autoBack = false;
        return this;
    }

    public boolean isAutoBack() {
        return this.autoBack;
    }

    @Override
    public abstract boolean canEnter();

    public void pinBackMenu(SimpleGet<L> back) {
        this.autoBack = false;
        this.back = back;
    }

    public String toString() {
        return "AbstractLcdMenu(id:`" + this.id + "`)";
    }

    public Map<String, Object> getExtraDataMap() {
        if (null == this.extraData) {
            this.extraData = new SmallMap();
        }
        return this.extraData;
    }
}

