package eu.javaexperience.electronic.lcd;

public interface OneCharSequence extends CharSequence
{
	public default int length()
	{
		return 1;
	}

	public default char charAt(int index)
	{
		if(0 == index)
		{
			return getChar();
		}
		throw new StringIndexOutOfBoundsException(index);
	}

	public char getChar();
	
	public default CharSequence subSequence(int start, int end)
	{
		if(0 == start && 1 == end)
		{
			return this;
		}
		
		if(start == end)
		{
			return "";
		}
		
		throw new StringIndexOutOfBoundsException(end);
	}
}
