package eu.javaexperience.electronic.lcd.display;

import eu.javaexperience.electronic.lcd.Lcd8Char;
import eu.javaexperience.electronic.lcd.display.CharacterDisplayState;
import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.javaexperience.text.StringTools;

public class Lcd58Rendering extends AbstractRenderingInstruction
{
	protected Lcd8Char[][] chars;
	protected int maxWidth = 0;
	
	public Lcd58Rendering(int x0, int y0, boolean inverted, Lcd8Char[][] chars)
	{
		super(x0, y0, inverted);
		this.chars = chars;
		for(Lcd8Char[] c:chars)
		{
			int real = realLength(c);
			if(maxWidth < real)
			{
				maxWidth = real;
			}
		}
	}
	
	protected static int realLength(Lcd8Char[] arr)
	{
		int i=0;
		for(;i<arr.length;++i)
		{
			if(null == arr[i])
			{
				break;
			}
		}
		return i;
	}
	
	@Override
	public int getWidth()
	{
		return maxWidth*6;
	}

	@Override
	public int getHeight()
	{
		return chars.length*9;
	}

	@Override
	public boolean isSet(int x, int y)
	{
		//6-os és 9-es csoportba osztjuk, az utoló indexek az eltartások
		int oX = x%6;
		if(5 == oX)
		{
			return inverted;
		}
		int oY = y%9;
		if(8 == oY)
		{
			return inverted;
		}
		
		int iY = y/9;
		//off the chart check
		if(iY >= chars.length)
		{
			return false;
		}
		
		Lcd8Char[] row = chars[iY];
		
		int iX = x/6;
		//off the chart check
		if(iX >= maxWidth)
		{
			return false;
		}
		
		Lcd8Char chr = row[iX];
		if(null == chr)
		{
			return inverted;
		}
		
		return inverted != (0 != (chr.getColumns()[oY] & (0x1 << (4-oX))));
	}
	
	public static Lcd58Rendering createMatrixText(int x0, int y0, boolean inverted, String text, boolean blinkShow, GetBy1<Lcd8Char, Character> getChar)
	{
		return new Lcd58Rendering(x0, y0, inverted, parseText(text, blinkShow, getChar, false, false).screenContent);
	}
	
	public static CharacterDisplayState parseText
	(
		String arg0,
		boolean blinkShow,
		GetBy1<Lcd8Char, Character> getChar,
		boolean fillspaces,
		boolean inverted
	)
	{
		if(arg0.contains("\b"))
		{
			if(blinkShow)
			{
				arg0 = StringTools.replaceAllStrings(arg0, "\b", "");
			}
			else
			{
				int i=0;
				while(arg0.contains("\b"))
				{
					String replace = StringTools.getFirstBetween(arg0, "\b", "\b", null);
					if(null == replace)
					{
						break;
					}
					arg0 = StringTools.replaceAllStrings(arg0, "\b"+replace+"\b", StringTools.repeatChar(' ', replace.length()));
					if(++i > 150)
					{
						break;
					}
				}
			}
		}
		
		return CharacterDisplayState.createFromString(getChar, arg0, 16, fillspaces, inverted);
	}
	
	public static final int TOP_LINE_Y = 0;
	public static final int BOTTOM_LINE_Y = 9;
}
