package eu.javaexperience.electronic.lcd.display;

import java.util.ArrayList;
import java.util.List;

import eu.javaexperience.collection.CollectionTools;
import eu.javaexperience.electronic.lcd.menu.LcdDisplay;
import eu.javaexperience.electronic.lcd.menu.LcdDisplayState;

public class MatrixRenderInstructions implements LcdDisplayState
{
	public boolean inverted = false;
	protected List<RenderingInstruction> instructions = new ArrayList<>();
	
	public List<RenderingInstruction> getInstructions()
	{
		return instructions;
	}
	
	@Override
	public void render(LcdDisplay display)
	{
		for(RenderingInstruction i:instructions)
		{
			int x0 = i.getX0();
			int y0 = i.getY0();
			
			int height = i.getHeight();
			int width = i.getWidth();
			
			for(int h=0;h <height;h++)
			{
				for(int w=0;w<width;w++)
				{
					if(i.isSet(w, h))
					{
						display.setPixel(x0+w, y0+h);
					}
				}
			}
		}
	}
	
	public MatrixRenderInstructions()
	{}
	
	public MatrixRenderInstructions(boolean inverted, RenderingInstruction... instr)
	{
		this.inverted = inverted;
		CollectionTools.inlineAdd(instructions, instr);
	}
	
	public static MatrixRenderInstructions instructions(boolean inverted, RenderingInstruction... instr)
	{
		return new MatrixRenderInstructions(inverted, instr);
	}

	public static MatrixRenderInstructions instrunctionList(boolean inverted, List<RenderingInstruction> mri)
	{
		MatrixRenderInstructions ret = new MatrixRenderInstructions();
		ret.inverted = inverted;
		ret.instructions = mri;
		return ret;
	}
}
