package eu.javaexperience.electronic.lcd.menu;

import java.util.Map.Entry;

import eu.javaexperience.interfaces.simple.SimpleGet;
import eu.javaexperience.interfaces.simple.publish.SimplePublish2;

public class LcdMenuBuilderPlain
{
	protected  InputEventNavigationInterpreter nav;
	protected SimplePublish2<String, SimpleGet<LcdMenu>> registry;
	
	public LcdMenuBuilderPlain(InputEventNavigationInterpreter nav)
	{
		this.nav = nav;
	}
	
	public <L extends LcdMenu<L>> LcdSpinnerMenu<L> createSpinnerMenu(String menuId, Entry<SimpleGet<LcdDisplayState>, SimpleGet<L>>... entries)
	{
		LcdSpinnerMenu<L> ret = new LcdSpinnerMenu<>(menuId, nav);
		
		for(Entry<SimpleGet<LcdDisplayState>, SimpleGet<L>> ent:entries)
		{
			SimpleGet<L> menu = ent.getValue();
			ret.getRwMenuEntries().add(ent);
			if(menu instanceof LcdSpinnerMenu)
			{
				((LcdSpinnerMenu)menu).setBackMenu(()->(L)ret);
			}
		}
		
		return ret;
	}
}
